<?php

namespace DHL\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostQuote_RAS StructType
 * @package DHL
 * @subpackage Structs
 */
class DHLPostQuote_RAS extends AbstractStructBase
{
    /**
     * The ShipperPostCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipperPostCode;
    /**
     * The ReceiverCountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReceiverCountryCode;
    /**
     * The PostCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostCode;
    /**
     * The fromCity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $fromCity;
    /**
     * The IsDutiable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsDutiable;
    /**
     * The PickupHours
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PickupHours;
    /**
     * The PickupMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PickupMinutes;
    /**
     * The DeclaredCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeclaredCurrency;
    /**
     * The DeclaredValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeclaredValue;
    /**
     * The NetworkTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NetworkTypeCode;
    /**
     * The GlobalProductCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GlobalProductCode;
    /**
     * The LocalProductCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocalProductCode;
    /**
     * The toCity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $toCity;
    /**
     * The PaymentAccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentAccountNumber;
    /**
     * The pieces
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $pieces;
    /**
     * The ShipPieceWt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipPieceWt;
    /**
     * The ShipPieceDepth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipPieceDepth;
    /**
     * The ShipPieceWidth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipPieceWidth;
    /**
     * The ShipPieceHeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipPieceHeight;
    /**
     * Constructor method for PostQuote_RAS
     * @uses DHLPostQuote_RAS::setShipperPostCode()
     * @uses DHLPostQuote_RAS::setReceiverCountryCode()
     * @uses DHLPostQuote_RAS::setPostCode()
     * @uses DHLPostQuote_RAS::setFromCity()
     * @uses DHLPostQuote_RAS::setIsDutiable()
     * @uses DHLPostQuote_RAS::setPickupHours()
     * @uses DHLPostQuote_RAS::setPickupMinutes()
     * @uses DHLPostQuote_RAS::setDeclaredCurrency()
     * @uses DHLPostQuote_RAS::setDeclaredValue()
     * @uses DHLPostQuote_RAS::setNetworkTypeCode()
     * @uses DHLPostQuote_RAS::setGlobalProductCode()
     * @uses DHLPostQuote_RAS::setLocalProductCode()
     * @uses DHLPostQuote_RAS::setToCity()
     * @uses DHLPostQuote_RAS::setPaymentAccountNumber()
     * @uses DHLPostQuote_RAS::setPieces()
     * @uses DHLPostQuote_RAS::setShipPieceWt()
     * @uses DHLPostQuote_RAS::setShipPieceDepth()
     * @uses DHLPostQuote_RAS::setShipPieceWidth()
     * @uses DHLPostQuote_RAS::setShipPieceHeight()
     * @param string $shipperPostCode
     * @param string $receiverCountryCode
     * @param string $postCode
     * @param string $fromCity
     * @param string $isDutiable
     * @param string $pickupHours
     * @param string $pickupMinutes
     * @param string $declaredCurrency
     * @param string $declaredValue
     * @param string $networkTypeCode
     * @param string $globalProductCode
     * @param string $localProductCode
     * @param string $toCity
     * @param string $paymentAccountNumber
     * @param int $pieces
     * @param string $shipPieceWt
     * @param string $shipPieceDepth
     * @param string $shipPieceWidth
     * @param string $shipPieceHeight
     */
    public function __construct($shipperPostCode = null, $receiverCountryCode = null, $postCode = null, $fromCity = null, $isDutiable = null, $pickupHours = null, $pickupMinutes = null, $declaredCurrency = null, $declaredValue = null, $networkTypeCode = null, $globalProductCode = null, $localProductCode = null, $toCity = null, $paymentAccountNumber = null, $pieces = null, $shipPieceWt = null, $shipPieceDepth = null, $shipPieceWidth = null, $shipPieceHeight = null)
    {
        $this
            ->setShipperPostCode($shipperPostCode)
            ->setReceiverCountryCode($receiverCountryCode)
            ->setPostCode($postCode)
            ->setFromCity($fromCity)
            ->setIsDutiable($isDutiable)
            ->setPickupHours($pickupHours)
            ->setPickupMinutes($pickupMinutes)
            ->setDeclaredCurrency($declaredCurrency)
            ->setDeclaredValue($declaredValue)
            ->setNetworkTypeCode($networkTypeCode)
            ->setGlobalProductCode($globalProductCode)
            ->setLocalProductCode($localProductCode)
            ->setToCity($toCity)
            ->setPaymentAccountNumber($paymentAccountNumber)
            ->setPieces($pieces)
            ->setShipPieceWt($shipPieceWt)
            ->setShipPieceDepth($shipPieceDepth)
            ->setShipPieceWidth($shipPieceWidth)
            ->setShipPieceHeight($shipPieceHeight);
    }
    /**
     * Get ShipperPostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipperPostCode()
    {
        return isset($this->ShipperPostCode) ? $this->ShipperPostCode : null;
    }
    /**
     * Set ShipperPostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipperPostCode
     * @return \DHL\StructType\DHLPostQuote_RAS
     */
    public function setShipperPostCode($shipperPostCode = null)
    {
        // validation for constraint: string
        if (!is_null($shipperPostCode) && !is_string($shipperPostCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperPostCode, true), gettype($shipperPostCode)), __LINE__);
        }
        if (is_null($shipperPostCode) || (is_array($shipperPostCode) && empty($shipperPostCode))) {
            unset($this->ShipperPostCode);
        } else {
            $this->ShipperPostCode = $shipperPostCode;
        }
        return $this;
    }
    /**
     * Get ReceiverCountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReceiverCountryCode()
    {
        return isset($this->ReceiverCountryCode) ? $this->ReceiverCountryCode : null;
    }
    /**
     * Set ReceiverCountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $receiverCountryCode
     * @return \DHL\StructType\DHLPostQuote_RAS
     */
    public function setReceiverCountryCode($receiverCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($receiverCountryCode) && !is_string($receiverCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverCountryCode, true), gettype($receiverCountryCode)), __LINE__);
        }
        if (is_null($receiverCountryCode) || (is_array($receiverCountryCode) && empty($receiverCountryCode))) {
            unset($this->ReceiverCountryCode);
        } else {
            $this->ReceiverCountryCode = $receiverCountryCode;
        }
        return $this;
    }
    /**
     * Get PostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostCode()
    {
        return isset($this->PostCode) ? $this->PostCode : null;
    }
    /**
     * Set PostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postCode
     * @return \DHL\StructType\DHLPostQuote_RAS
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postCode, true), gettype($postCode)), __LINE__);
        }
        if (is_null($postCode) || (is_array($postCode) && empty($postCode))) {
            unset($this->PostCode);
        } else {
            $this->PostCode = $postCode;
        }
        return $this;
    }
    /**
     * Get fromCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromCity()
    {
        return isset($this->fromCity) ? $this->fromCity : null;
    }
    /**
     * Set fromCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromCity
     * @return \DHL\StructType\DHLPostQuote_RAS
     */
    public function setFromCity($fromCity = null)
    {
        // validation for constraint: string
        if (!is_null($fromCity) && !is_string($fromCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromCity, true), gettype($fromCity)), __LINE__);
        }
        if (is_null($fromCity) || (is_array($fromCity) && empty($fromCity))) {
            unset($this->fromCity);
        } else {
            $this->fromCity = $fromCity;
        }
        return $this;
    }
    /**
     * Get IsDutiable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsDutiable()
    {
        return isset($this->IsDutiable) ? $this->IsDutiable : null;
    }
    /**
     * Set IsDutiable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isDutiable
     * @return \DHL\StructType\DHLPostQuote_RAS
     */
    public function setIsDutiable($isDutiable = null)
    {
        // validation for constraint: string
        if (!is_null($isDutiable) && !is_string($isDutiable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isDutiable, true), gettype($isDutiable)), __LINE__);
        }
        if (is_null($isDutiable) || (is_array($isDutiable) && empty($isDutiable))) {
            unset($this->IsDutiable);
        } else {
            $this->IsDutiable = $isDutiable;
        }
        return $this;
    }
    /**
     * Get PickupHours value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPickupHours()
    {
        return isset($this->PickupHours) ? $this->PickupHours : null;
    }
    /**
     * Set PickupHours value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pickupHours
     * @return \DHL\StructType\DHLPostQuote_RAS
     */
    public function setPickupHours($pickupHours = null)
    {
        // validation for constraint: string
        if (!is_null($pickupHours) && !is_string($pickupHours)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupHours, true), gettype($pickupHours)), __LINE__);
        }
        if (is_null($pickupHours) || (is_array($pickupHours) && empty($pickupHours))) {
            unset($this->PickupHours);
        } else {
            $this->PickupHours = $pickupHours;
        }
        return $this;
    }
    /**
     * Get PickupMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPickupMinutes()
    {
        return isset($this->PickupMinutes) ? $this->PickupMinutes : null;
    }
    /**
     * Set PickupMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pickupMinutes
     * @return \DHL\StructType\DHLPostQuote_RAS
     */
    public function setPickupMinutes($pickupMinutes = null)
    {
        // validation for constraint: string
        if (!is_null($pickupMinutes) && !is_string($pickupMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupMinutes, true), gettype($pickupMinutes)), __LINE__);
        }
        if (is_null($pickupMinutes) || (is_array($pickupMinutes) && empty($pickupMinutes))) {
            unset($this->PickupMinutes);
        } else {
            $this->PickupMinutes = $pickupMinutes;
        }
        return $this;
    }
    /**
     * Get DeclaredCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeclaredCurrency()
    {
        return isset($this->DeclaredCurrency) ? $this->DeclaredCurrency : null;
    }
    /**
     * Set DeclaredCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $declaredCurrency
     * @return \DHL\StructType\DHLPostQuote_RAS
     */
    public function setDeclaredCurrency($declaredCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($declaredCurrency) && !is_string($declaredCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($declaredCurrency, true), gettype($declaredCurrency)), __LINE__);
        }
        if (is_null($declaredCurrency) || (is_array($declaredCurrency) && empty($declaredCurrency))) {
            unset($this->DeclaredCurrency);
        } else {
            $this->DeclaredCurrency = $declaredCurrency;
        }
        return $this;
    }
    /**
     * Get DeclaredValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeclaredValue()
    {
        return isset($this->DeclaredValue) ? $this->DeclaredValue : null;
    }
    /**
     * Set DeclaredValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $declaredValue
     * @return \DHL\StructType\DHLPostQuote_RAS
     */
    public function setDeclaredValue($declaredValue = null)
    {
        // validation for constraint: string
        if (!is_null($declaredValue) && !is_string($declaredValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($declaredValue, true), gettype($declaredValue)), __LINE__);
        }
        if (is_null($declaredValue) || (is_array($declaredValue) && empty($declaredValue))) {
            unset($this->DeclaredValue);
        } else {
            $this->DeclaredValue = $declaredValue;
        }
        return $this;
    }
    /**
     * Get NetworkTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkTypeCode()
    {
        return isset($this->NetworkTypeCode) ? $this->NetworkTypeCode : null;
    }
    /**
     * Set NetworkTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $networkTypeCode
     * @return \DHL\StructType\DHLPostQuote_RAS
     */
    public function setNetworkTypeCode($networkTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($networkTypeCode) && !is_string($networkTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($networkTypeCode, true), gettype($networkTypeCode)), __LINE__);
        }
        if (is_null($networkTypeCode) || (is_array($networkTypeCode) && empty($networkTypeCode))) {
            unset($this->NetworkTypeCode);
        } else {
            $this->NetworkTypeCode = $networkTypeCode;
        }
        return $this;
    }
    /**
     * Get GlobalProductCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGlobalProductCode()
    {
        return isset($this->GlobalProductCode) ? $this->GlobalProductCode : null;
    }
    /**
     * Set GlobalProductCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $globalProductCode
     * @return \DHL\StructType\DHLPostQuote_RAS
     */
    public function setGlobalProductCode($globalProductCode = null)
    {
        // validation for constraint: string
        if (!is_null($globalProductCode) && !is_string($globalProductCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($globalProductCode, true), gettype($globalProductCode)), __LINE__);
        }
        if (is_null($globalProductCode) || (is_array($globalProductCode) && empty($globalProductCode))) {
            unset($this->GlobalProductCode);
        } else {
            $this->GlobalProductCode = $globalProductCode;
        }
        return $this;
    }
    /**
     * Get LocalProductCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalProductCode()
    {
        return isset($this->LocalProductCode) ? $this->LocalProductCode : null;
    }
    /**
     * Set LocalProductCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localProductCode
     * @return \DHL\StructType\DHLPostQuote_RAS
     */
    public function setLocalProductCode($localProductCode = null)
    {
        // validation for constraint: string
        if (!is_null($localProductCode) && !is_string($localProductCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localProductCode, true), gettype($localProductCode)), __LINE__);
        }
        if (is_null($localProductCode) || (is_array($localProductCode) && empty($localProductCode))) {
            unset($this->LocalProductCode);
        } else {
            $this->LocalProductCode = $localProductCode;
        }
        return $this;
    }
    /**
     * Get toCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToCity()
    {
        return isset($this->toCity) ? $this->toCity : null;
    }
    /**
     * Set toCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toCity
     * @return \DHL\StructType\DHLPostQuote_RAS
     */
    public function setToCity($toCity = null)
    {
        // validation for constraint: string
        if (!is_null($toCity) && !is_string($toCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toCity, true), gettype($toCity)), __LINE__);
        }
        if (is_null($toCity) || (is_array($toCity) && empty($toCity))) {
            unset($this->toCity);
        } else {
            $this->toCity = $toCity;
        }
        return $this;
    }
    /**
     * Get PaymentAccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentAccountNumber()
    {
        return isset($this->PaymentAccountNumber) ? $this->PaymentAccountNumber : null;
    }
    /**
     * Set PaymentAccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentAccountNumber
     * @return \DHL\StructType\DHLPostQuote_RAS
     */
    public function setPaymentAccountNumber($paymentAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($paymentAccountNumber) && !is_string($paymentAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentAccountNumber, true), gettype($paymentAccountNumber)), __LINE__);
        }
        if (is_null($paymentAccountNumber) || (is_array($paymentAccountNumber) && empty($paymentAccountNumber))) {
            unset($this->PaymentAccountNumber);
        } else {
            $this->PaymentAccountNumber = $paymentAccountNumber;
        }
        return $this;
    }
    /**
     * Get pieces value
     * @return int|null
     */
    public function getPieces()
    {
        return $this->pieces;
    }
    /**
     * Set pieces value
     * @param int $pieces
     * @return \DHL\StructType\DHLPostQuote_RAS
     */
    public function setPieces($pieces = null)
    {
        // validation for constraint: int
        if (!is_null($pieces) && !(is_int($pieces) || ctype_digit($pieces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pieces, true), gettype($pieces)), __LINE__);
        }
        $this->pieces = $pieces;
        return $this;
    }
    /**
     * Get ShipPieceWt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipPieceWt()
    {
        return isset($this->ShipPieceWt) ? $this->ShipPieceWt : null;
    }
    /**
     * Set ShipPieceWt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipPieceWt
     * @return \DHL\StructType\DHLPostQuote_RAS
     */
    public function setShipPieceWt($shipPieceWt = null)
    {
        // validation for constraint: string
        if (!is_null($shipPieceWt) && !is_string($shipPieceWt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipPieceWt, true), gettype($shipPieceWt)), __LINE__);
        }
        if (is_null($shipPieceWt) || (is_array($shipPieceWt) && empty($shipPieceWt))) {
            unset($this->ShipPieceWt);
        } else {
            $this->ShipPieceWt = $shipPieceWt;
        }
        return $this;
    }
    /**
     * Get ShipPieceDepth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipPieceDepth()
    {
        return isset($this->ShipPieceDepth) ? $this->ShipPieceDepth : null;
    }
    /**
     * Set ShipPieceDepth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipPieceDepth
     * @return \DHL\StructType\DHLPostQuote_RAS
     */
    public function setShipPieceDepth($shipPieceDepth = null)
    {
        // validation for constraint: string
        if (!is_null($shipPieceDepth) && !is_string($shipPieceDepth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipPieceDepth, true), gettype($shipPieceDepth)), __LINE__);
        }
        if (is_null($shipPieceDepth) || (is_array($shipPieceDepth) && empty($shipPieceDepth))) {
            unset($this->ShipPieceDepth);
        } else {
            $this->ShipPieceDepth = $shipPieceDepth;
        }
        return $this;
    }
    /**
     * Get ShipPieceWidth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipPieceWidth()
    {
        return isset($this->ShipPieceWidth) ? $this->ShipPieceWidth : null;
    }
    /**
     * Set ShipPieceWidth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipPieceWidth
     * @return \DHL\StructType\DHLPostQuote_RAS
     */
    public function setShipPieceWidth($shipPieceWidth = null)
    {
        // validation for constraint: string
        if (!is_null($shipPieceWidth) && !is_string($shipPieceWidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipPieceWidth, true), gettype($shipPieceWidth)), __LINE__);
        }
        if (is_null($shipPieceWidth) || (is_array($shipPieceWidth) && empty($shipPieceWidth))) {
            unset($this->ShipPieceWidth);
        } else {
            $this->ShipPieceWidth = $shipPieceWidth;
        }
        return $this;
    }
    /**
     * Get ShipPieceHeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipPieceHeight()
    {
        return isset($this->ShipPieceHeight) ? $this->ShipPieceHeight : null;
    }
    /**
     * Set ShipPieceHeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipPieceHeight
     * @return \DHL\StructType\DHLPostQuote_RAS
     */
    public function setShipPieceHeight($shipPieceHeight = null)
    {
        // validation for constraint: string
        if (!is_null($shipPieceHeight) && !is_string($shipPieceHeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipPieceHeight, true), gettype($shipPieceHeight)), __LINE__);
        }
        if (is_null($shipPieceHeight) || (is_array($shipPieceHeight) && empty($shipPieceHeight))) {
            unset($this->ShipPieceHeight);
        } else {
            $this->ShipPieceHeight = $shipPieceHeight;
        }
        return $this;
    }
}
