<?php

namespace DHL\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostQuoteResponse StructType
 * @package DHL
 * @subpackage Structs
 */
class DHLPostQuoteResponse extends AbstractStructBase
{
    /**
     * The PostQuoteResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostQuoteResult;
    /**
     * Constructor method for PostQuoteResponse
     * @uses DHLPostQuoteResponse::setPostQuoteResult()
     * @param string $postQuoteResult
     */
    public function __construct($postQuoteResult = null)
    {
        $this
            ->setPostQuoteResult($postQuoteResult);
    }
    /**
     * Get PostQuoteResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostQuoteResult()
    {
        return isset($this->PostQuoteResult) ? $this->PostQuoteResult : null;
    }
    /**
     * Set PostQuoteResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postQuoteResult
     * @return \DHL\StructType\DHLPostQuoteResponse
     */
    public function setPostQuoteResult($postQuoteResult = null)
    {
        // validation for constraint: string
        if (!is_null($postQuoteResult) && !is_string($postQuoteResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postQuoteResult, true), gettype($postQuoteResult)), __LINE__);
        }
        if (is_null($postQuoteResult) || (is_array($postQuoteResult) && empty($postQuoteResult))) {
            unset($this->PostQuoteResult);
        } else {
            $this->PostQuoteResult = $postQuoteResult;
        }
        return $this;
    }
}
