<?php

namespace DHL\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostPickup_v6 StructType
 * @package DHL
 * @subpackage Structs
 */
class DHLPostPickup_v6 extends AbstractStructBase
{
    /**
     * The ShipperCompName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipperCompName;
    /**
     * The ShipperAdd1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipperAdd1;
    /**
     * The ShipperAdd2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipperAdd2;
    /**
     * The PackageLocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PackageLocation;
    /**
     * The Shippercity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Shippercity;
    /**
     * The ShipperPostCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipperPostCode;
    /**
     * The ShipperCountyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipperCountyCode;
    /**
     * The ShipperName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipperName;
    /**
     * The ShipperPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipperPhone;
    /**
     * The PickupClosingTimeHrs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PickupClosingTimeHrs;
    /**
     * The PickupClosingTimeMins
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PickupClosingTimeMins;
    /**
     * The Pieces
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Pieces;
    /**
     * The PickupWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PickupWeight;
    /**
     * The PickupContactName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PickupContactName;
    /**
     * The PickupContactPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PickupContactPhone;
    /**
     * The PickupDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PickupDate;
    /**
     * The ReadyByTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReadyByTime;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * Constructor method for PostPickup_v6
     * @uses DHLPostPickup_v6::setShipperCompName()
     * @uses DHLPostPickup_v6::setShipperAdd1()
     * @uses DHLPostPickup_v6::setShipperAdd2()
     * @uses DHLPostPickup_v6::setPackageLocation()
     * @uses DHLPostPickup_v6::setShippercity()
     * @uses DHLPostPickup_v6::setShipperPostCode()
     * @uses DHLPostPickup_v6::setShipperCountyCode()
     * @uses DHLPostPickup_v6::setShipperName()
     * @uses DHLPostPickup_v6::setShipperPhone()
     * @uses DHLPostPickup_v6::setPickupClosingTimeHrs()
     * @uses DHLPostPickup_v6::setPickupClosingTimeMins()
     * @uses DHLPostPickup_v6::setPieces()
     * @uses DHLPostPickup_v6::setPickupWeight()
     * @uses DHLPostPickup_v6::setPickupContactName()
     * @uses DHLPostPickup_v6::setPickupContactPhone()
     * @uses DHLPostPickup_v6::setPickupDate()
     * @uses DHLPostPickup_v6::setReadyByTime()
     * @uses DHLPostPickup_v6::setAccountNumber()
     * @param string $shipperCompName
     * @param string $shipperAdd1
     * @param string $shipperAdd2
     * @param string $packageLocation
     * @param string $shippercity
     * @param string $shipperPostCode
     * @param string $shipperCountyCode
     * @param string $shipperName
     * @param string $shipperPhone
     * @param int $pickupClosingTimeHrs
     * @param int $pickupClosingTimeMins
     * @param string $pieces
     * @param string $pickupWeight
     * @param string $pickupContactName
     * @param string $pickupContactPhone
     * @param string $pickupDate
     * @param string $readyByTime
     * @param string $accountNumber
     */
    public function __construct($shipperCompName = null, $shipperAdd1 = null, $shipperAdd2 = null, $packageLocation = null, $shippercity = null, $shipperPostCode = null, $shipperCountyCode = null, $shipperName = null, $shipperPhone = null, $pickupClosingTimeHrs = null, $pickupClosingTimeMins = null, $pieces = null, $pickupWeight = null, $pickupContactName = null, $pickupContactPhone = null, $pickupDate = null, $readyByTime = null, $accountNumber = null)
    {
        $this
            ->setShipperCompName($shipperCompName)
            ->setShipperAdd1($shipperAdd1)
            ->setShipperAdd2($shipperAdd2)
            ->setPackageLocation($packageLocation)
            ->setShippercity($shippercity)
            ->setShipperPostCode($shipperPostCode)
            ->setShipperCountyCode($shipperCountyCode)
            ->setShipperName($shipperName)
            ->setShipperPhone($shipperPhone)
            ->setPickupClosingTimeHrs($pickupClosingTimeHrs)
            ->setPickupClosingTimeMins($pickupClosingTimeMins)
            ->setPieces($pieces)
            ->setPickupWeight($pickupWeight)
            ->setPickupContactName($pickupContactName)
            ->setPickupContactPhone($pickupContactPhone)
            ->setPickupDate($pickupDate)
            ->setReadyByTime($readyByTime)
            ->setAccountNumber($accountNumber);
    }
    /**
     * Get ShipperCompName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipperCompName()
    {
        return isset($this->ShipperCompName) ? $this->ShipperCompName : null;
    }
    /**
     * Set ShipperCompName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipperCompName
     * @return \DHL\StructType\DHLPostPickup_v6
     */
    public function setShipperCompName($shipperCompName = null)
    {
        // validation for constraint: string
        if (!is_null($shipperCompName) && !is_string($shipperCompName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperCompName, true), gettype($shipperCompName)), __LINE__);
        }
        if (is_null($shipperCompName) || (is_array($shipperCompName) && empty($shipperCompName))) {
            unset($this->ShipperCompName);
        } else {
            $this->ShipperCompName = $shipperCompName;
        }
        return $this;
    }
    /**
     * Get ShipperAdd1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipperAdd1()
    {
        return isset($this->ShipperAdd1) ? $this->ShipperAdd1 : null;
    }
    /**
     * Set ShipperAdd1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipperAdd1
     * @return \DHL\StructType\DHLPostPickup_v6
     */
    public function setShipperAdd1($shipperAdd1 = null)
    {
        // validation for constraint: string
        if (!is_null($shipperAdd1) && !is_string($shipperAdd1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperAdd1, true), gettype($shipperAdd1)), __LINE__);
        }
        if (is_null($shipperAdd1) || (is_array($shipperAdd1) && empty($shipperAdd1))) {
            unset($this->ShipperAdd1);
        } else {
            $this->ShipperAdd1 = $shipperAdd1;
        }
        return $this;
    }
    /**
     * Get ShipperAdd2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipperAdd2()
    {
        return isset($this->ShipperAdd2) ? $this->ShipperAdd2 : null;
    }
    /**
     * Set ShipperAdd2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipperAdd2
     * @return \DHL\StructType\DHLPostPickup_v6
     */
    public function setShipperAdd2($shipperAdd2 = null)
    {
        // validation for constraint: string
        if (!is_null($shipperAdd2) && !is_string($shipperAdd2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperAdd2, true), gettype($shipperAdd2)), __LINE__);
        }
        if (is_null($shipperAdd2) || (is_array($shipperAdd2) && empty($shipperAdd2))) {
            unset($this->ShipperAdd2);
        } else {
            $this->ShipperAdd2 = $shipperAdd2;
        }
        return $this;
    }
    /**
     * Get PackageLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPackageLocation()
    {
        return isset($this->PackageLocation) ? $this->PackageLocation : null;
    }
    /**
     * Set PackageLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packageLocation
     * @return \DHL\StructType\DHLPostPickup_v6
     */
    public function setPackageLocation($packageLocation = null)
    {
        // validation for constraint: string
        if (!is_null($packageLocation) && !is_string($packageLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageLocation, true), gettype($packageLocation)), __LINE__);
        }
        if (is_null($packageLocation) || (is_array($packageLocation) && empty($packageLocation))) {
            unset($this->PackageLocation);
        } else {
            $this->PackageLocation = $packageLocation;
        }
        return $this;
    }
    /**
     * Get Shippercity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShippercity()
    {
        return isset($this->Shippercity) ? $this->Shippercity : null;
    }
    /**
     * Set Shippercity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shippercity
     * @return \DHL\StructType\DHLPostPickup_v6
     */
    public function setShippercity($shippercity = null)
    {
        // validation for constraint: string
        if (!is_null($shippercity) && !is_string($shippercity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippercity, true), gettype($shippercity)), __LINE__);
        }
        if (is_null($shippercity) || (is_array($shippercity) && empty($shippercity))) {
            unset($this->Shippercity);
        } else {
            $this->Shippercity = $shippercity;
        }
        return $this;
    }
    /**
     * Get ShipperPostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipperPostCode()
    {
        return isset($this->ShipperPostCode) ? $this->ShipperPostCode : null;
    }
    /**
     * Set ShipperPostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipperPostCode
     * @return \DHL\StructType\DHLPostPickup_v6
     */
    public function setShipperPostCode($shipperPostCode = null)
    {
        // validation for constraint: string
        if (!is_null($shipperPostCode) && !is_string($shipperPostCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperPostCode, true), gettype($shipperPostCode)), __LINE__);
        }
        if (is_null($shipperPostCode) || (is_array($shipperPostCode) && empty($shipperPostCode))) {
            unset($this->ShipperPostCode);
        } else {
            $this->ShipperPostCode = $shipperPostCode;
        }
        return $this;
    }
    /**
     * Get ShipperCountyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipperCountyCode()
    {
        return isset($this->ShipperCountyCode) ? $this->ShipperCountyCode : null;
    }
    /**
     * Set ShipperCountyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipperCountyCode
     * @return \DHL\StructType\DHLPostPickup_v6
     */
    public function setShipperCountyCode($shipperCountyCode = null)
    {
        // validation for constraint: string
        if (!is_null($shipperCountyCode) && !is_string($shipperCountyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperCountyCode, true), gettype($shipperCountyCode)), __LINE__);
        }
        if (is_null($shipperCountyCode) || (is_array($shipperCountyCode) && empty($shipperCountyCode))) {
            unset($this->ShipperCountyCode);
        } else {
            $this->ShipperCountyCode = $shipperCountyCode;
        }
        return $this;
    }
    /**
     * Get ShipperName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipperName()
    {
        return isset($this->ShipperName) ? $this->ShipperName : null;
    }
    /**
     * Set ShipperName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipperName
     * @return \DHL\StructType\DHLPostPickup_v6
     */
    public function setShipperName($shipperName = null)
    {
        // validation for constraint: string
        if (!is_null($shipperName) && !is_string($shipperName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperName, true), gettype($shipperName)), __LINE__);
        }
        if (is_null($shipperName) || (is_array($shipperName) && empty($shipperName))) {
            unset($this->ShipperName);
        } else {
            $this->ShipperName = $shipperName;
        }
        return $this;
    }
    /**
     * Get ShipperPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipperPhone()
    {
        return isset($this->ShipperPhone) ? $this->ShipperPhone : null;
    }
    /**
     * Set ShipperPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipperPhone
     * @return \DHL\StructType\DHLPostPickup_v6
     */
    public function setShipperPhone($shipperPhone = null)
    {
        // validation for constraint: string
        if (!is_null($shipperPhone) && !is_string($shipperPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperPhone, true), gettype($shipperPhone)), __LINE__);
        }
        if (is_null($shipperPhone) || (is_array($shipperPhone) && empty($shipperPhone))) {
            unset($this->ShipperPhone);
        } else {
            $this->ShipperPhone = $shipperPhone;
        }
        return $this;
    }
    /**
     * Get PickupClosingTimeHrs value
     * @return int|null
     */
    public function getPickupClosingTimeHrs()
    {
        return $this->PickupClosingTimeHrs;
    }
    /**
     * Set PickupClosingTimeHrs value
     * @param int $pickupClosingTimeHrs
     * @return \DHL\StructType\DHLPostPickup_v6
     */
    public function setPickupClosingTimeHrs($pickupClosingTimeHrs = null)
    {
        // validation for constraint: int
        if (!is_null($pickupClosingTimeHrs) && !(is_int($pickupClosingTimeHrs) || ctype_digit($pickupClosingTimeHrs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pickupClosingTimeHrs, true), gettype($pickupClosingTimeHrs)), __LINE__);
        }
        $this->PickupClosingTimeHrs = $pickupClosingTimeHrs;
        return $this;
    }
    /**
     * Get PickupClosingTimeMins value
     * @return int|null
     */
    public function getPickupClosingTimeMins()
    {
        return $this->PickupClosingTimeMins;
    }
    /**
     * Set PickupClosingTimeMins value
     * @param int $pickupClosingTimeMins
     * @return \DHL\StructType\DHLPostPickup_v6
     */
    public function setPickupClosingTimeMins($pickupClosingTimeMins = null)
    {
        // validation for constraint: int
        if (!is_null($pickupClosingTimeMins) && !(is_int($pickupClosingTimeMins) || ctype_digit($pickupClosingTimeMins))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pickupClosingTimeMins, true), gettype($pickupClosingTimeMins)), __LINE__);
        }
        $this->PickupClosingTimeMins = $pickupClosingTimeMins;
        return $this;
    }
    /**
     * Get Pieces value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPieces()
    {
        return isset($this->Pieces) ? $this->Pieces : null;
    }
    /**
     * Set Pieces value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pieces
     * @return \DHL\StructType\DHLPostPickup_v6
     */
    public function setPieces($pieces = null)
    {
        // validation for constraint: string
        if (!is_null($pieces) && !is_string($pieces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pieces, true), gettype($pieces)), __LINE__);
        }
        if (is_null($pieces) || (is_array($pieces) && empty($pieces))) {
            unset($this->Pieces);
        } else {
            $this->Pieces = $pieces;
        }
        return $this;
    }
    /**
     * Get PickupWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPickupWeight()
    {
        return isset($this->PickupWeight) ? $this->PickupWeight : null;
    }
    /**
     * Set PickupWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pickupWeight
     * @return \DHL\StructType\DHLPostPickup_v6
     */
    public function setPickupWeight($pickupWeight = null)
    {
        // validation for constraint: string
        if (!is_null($pickupWeight) && !is_string($pickupWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupWeight, true), gettype($pickupWeight)), __LINE__);
        }
        if (is_null($pickupWeight) || (is_array($pickupWeight) && empty($pickupWeight))) {
            unset($this->PickupWeight);
        } else {
            $this->PickupWeight = $pickupWeight;
        }
        return $this;
    }
    /**
     * Get PickupContactName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPickupContactName()
    {
        return isset($this->PickupContactName) ? $this->PickupContactName : null;
    }
    /**
     * Set PickupContactName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pickupContactName
     * @return \DHL\StructType\DHLPostPickup_v6
     */
    public function setPickupContactName($pickupContactName = null)
    {
        // validation for constraint: string
        if (!is_null($pickupContactName) && !is_string($pickupContactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupContactName, true), gettype($pickupContactName)), __LINE__);
        }
        if (is_null($pickupContactName) || (is_array($pickupContactName) && empty($pickupContactName))) {
            unset($this->PickupContactName);
        } else {
            $this->PickupContactName = $pickupContactName;
        }
        return $this;
    }
    /**
     * Get PickupContactPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPickupContactPhone()
    {
        return isset($this->PickupContactPhone) ? $this->PickupContactPhone : null;
    }
    /**
     * Set PickupContactPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pickupContactPhone
     * @return \DHL\StructType\DHLPostPickup_v6
     */
    public function setPickupContactPhone($pickupContactPhone = null)
    {
        // validation for constraint: string
        if (!is_null($pickupContactPhone) && !is_string($pickupContactPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupContactPhone, true), gettype($pickupContactPhone)), __LINE__);
        }
        if (is_null($pickupContactPhone) || (is_array($pickupContactPhone) && empty($pickupContactPhone))) {
            unset($this->PickupContactPhone);
        } else {
            $this->PickupContactPhone = $pickupContactPhone;
        }
        return $this;
    }
    /**
     * Get PickupDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPickupDate()
    {
        return isset($this->PickupDate) ? $this->PickupDate : null;
    }
    /**
     * Set PickupDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pickupDate
     * @return \DHL\StructType\DHLPostPickup_v6
     */
    public function setPickupDate($pickupDate = null)
    {
        // validation for constraint: string
        if (!is_null($pickupDate) && !is_string($pickupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupDate, true), gettype($pickupDate)), __LINE__);
        }
        if (is_null($pickupDate) || (is_array($pickupDate) && empty($pickupDate))) {
            unset($this->PickupDate);
        } else {
            $this->PickupDate = $pickupDate;
        }
        return $this;
    }
    /**
     * Get ReadyByTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReadyByTime()
    {
        return isset($this->ReadyByTime) ? $this->ReadyByTime : null;
    }
    /**
     * Set ReadyByTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $readyByTime
     * @return \DHL\StructType\DHLPostPickup_v6
     */
    public function setReadyByTime($readyByTime = null)
    {
        // validation for constraint: string
        if (!is_null($readyByTime) && !is_string($readyByTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($readyByTime, true), gettype($readyByTime)), __LINE__);
        }
        if (is_null($readyByTime) || (is_array($readyByTime) && empty($readyByTime))) {
            unset($this->ReadyByTime);
        } else {
            $this->ReadyByTime = $readyByTime;
        }
        return $this;
    }
    /**
     * Get AccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->AccountNumber) ? $this->AccountNumber : null;
    }
    /**
     * Set AccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \DHL\StructType\DHLPostPickup_v6
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->AccountNumber);
        } else {
            $this->AccountNumber = $accountNumber;
        }
        return $this;
    }
}
