<?php

namespace DHL\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Post ServiceType
 * @package DHL
 * @subpackage Services
 */
class DHLPost extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PostQuotePos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostQuotePos $parameters
     * @return \DHL\StructType\DHLPostQuotePosResponse|bool
     */
    public function PostQuotePos(\DHL\StructType\DHLPostQuotePos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostQuotePos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostQuotePos_V6
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostQuotePos_V6 $parameters
     * @return \DHL\StructType\DHLPostQuotePos_V6Response|bool
     */
    public function PostQuotePos_V6(\DHL\StructType\DHLPostQuotePos_V6 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostQuotePos_V6($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostQuote_RAS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostQuote_RAS $parameters
     * @return \DHL\StructType\DHLPostQuote_RASResponse|bool
     */
    public function PostQuote_RAS(\DHL\StructType\DHLPostQuote_RAS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostQuote_RAS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostQuote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostQuote $parameters
     * @return \DHL\StructType\DHLPostQuoteResponse|bool
     */
    public function PostQuote(\DHL\StructType\DHLPostQuote $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostQuote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostCapability
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostCapability $parameters
     * @return \DHL\StructType\DHLPostCapabilityResponse|bool
     */
    public function PostCapability(\DHL\StructType\DHLPostCapability $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostCapability($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostPickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostPickup $parameters
     * @return \DHL\StructType\DHLPostPickupResponse|bool
     */
    public function PostPickup(\DHL\StructType\DHLPostPickup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostPickup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostPickup_v6
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostPickup_v6 $parameters
     * @return \DHL\StructType\DHLPostPickup_v6Response|bool
     */
    public function PostPickup_v6(\DHL\StructType\DHLPostPickup_v6 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostPickup_v6($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * PostShipmentWithSpecialService3C_V6
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipmentWithSpecialService3C_V6 $parameters
     * @return \DHL\StructType\DHLPostShipmentWithSpecialService3C_V6Response|bool
     */
    public function PostShipmentWithSpecialService3C_V6(\DHL\StructType\DHLPostShipmentWithSpecialService3C_V6 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipmentWithSpecialService3C_V6($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostShipment3C_V6
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipment3C_V6 $parameters
     * @return \DHL\StructType\DHLPostShipment3C_V6Response|bool
     */
    public function PostShipment3C_V6(\DHL\StructType\DHLPostShipment3C_V6 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipment3C_V6($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostShipment_V6
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipment_V6 $parameters
     * @return \DHL\StructType\DHLPostShipment_V6Response|bool
     */
    public function PostShipment_V6(\DHL\StructType\DHLPostShipment_V6 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipment_V6($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostShipment3CMPML_V6
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipment3CMPML_V6 $parameters
     * @return \DHL\StructType\DHLPostShipment3CMPML_V6Response|bool
     */
    public function PostShipment3CMPML_V6(\DHL\StructType\DHLPostShipment3CMPML_V6 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipment3CMPML_V6($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostTracking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostTracking $parameters
     * @return \DHL\StructType\DHLPostTrackingResponse|bool
     */
    public function PostTracking(\DHL\StructType\DHLPostTracking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostTracking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostTrackingReference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostTrackingReference $parameters
     * @return \DHL\StructType\DHLPostTrackingReferenceResponse|bool
     */
    public function PostTrackingReference(\DHL\StructType\DHLPostTrackingReference $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostTrackingReference($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostShipmentWithSpecialService3C
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipmentWithSpecialService3C $parameters
     * @return \DHL\StructType\DHLPostShipmentWithSpecialService3CResponse|bool
     */
    public function PostShipmentWithSpecialService3C(\DHL\StructType\DHLPostShipmentWithSpecialService3C $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipmentWithSpecialService3C($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostShipment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipment $parameters
     * @return \DHL\StructType\DHLPostShipmentResponse|bool
     */
    public function PostShipment(\DHL\StructType\DHLPostShipment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostShipment3C
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipment3C $parameters
     * @return \DHL\StructType\DHLPostShipment3CResponse|bool
     */
    public function PostShipment3C(\DHL\StructType\DHLPostShipment3C $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipment3C($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostShipmentwithCash_V6
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipmentwithCash_V6 $parameters
     * @return \DHL\StructType\DHLPostShipmentwithCash_V6Response|bool
     */
    public function PostShipmentwithCash_V6(\DHL\StructType\DHLPostShipmentwithCash_V6 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipmentwithCash_V6($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostShipmentCSB2_V6
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipmentCSB2_V6 $parameters
     * @return \DHL\StructType\DHLPostShipmentCSB2_V6Response|bool
     */
    public function PostShipmentCSB2_V6(\DHL\StructType\DHLPostShipmentCSB2_V6 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipmentCSB2_V6($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * PostShipmentCashwithSpecialService_v6
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipmentCashwithSpecialService_v6 $parameters
     * @return \DHL\StructType\DHLPostShipmentCashwithSpecialService_v6Response|bool
     */
    public function PostShipmentCashwithSpecialService_v6(\DHL\StructType\DHLPostShipmentCashwithSpecialService_v6 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipmentCashwithSpecialService_v6($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostShipmentCashwithSpecialService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipmentCashwithSpecialService $parameters
     * @return \DHL\StructType\DHLPostShipmentCashwithSpecialServiceResponse|bool
     */
    public function PostShipmentCashwithSpecialService(\DHL\StructType\DHLPostShipmentCashwithSpecialService $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipmentCashwithSpecialService($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * PostShipmentWithSpecialServiceCSB2_INS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipmentWithSpecialServiceCSB2_INS $parameters
     * @return \DHL\StructType\DHLPostShipmentWithSpecialServiceCSB2_INSResponse|bool
     */
    public function PostShipmentWithSpecialServiceCSB2_INS(\DHL\StructType\DHLPostShipmentWithSpecialServiceCSB2_INS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipmentWithSpecialServiceCSB2_INS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostShipmentWithSpecialService_INS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipmentWithSpecialService_INS $parameters
     * @return \DHL\StructType\DHLPostShipmentWithSpecialService_INSResponse|bool
     */
    public function PostShipmentWithSpecialService_INS(\DHL\StructType\DHLPostShipmentWithSpecialService_INS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipmentWithSpecialService_INS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * PostShipmentWithSpecialService3CMPML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipmentWithSpecialService3CMPML $parameters
     * @return \DHL\StructType\DHLPostShipmentWithSpecialService3CMPMLResponse|bool
     */
    public function PostShipmentWithSpecialService3CMPML(\DHL\StructType\DHLPostShipmentWithSpecialService3CMPML $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipmentWithSpecialService3CMPML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * PostShipmentWithSpecialService3CMPML_V6
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipmentWithSpecialService3CMPML_V6 $parameters
     * @return \DHL\StructType\DHLPostShipmentWithSpecialService3CMPML_V6Response|bool
     */
    public function PostShipmentWithSpecialService3CMPML_V6(\DHL\StructType\DHLPostShipmentWithSpecialService3CMPML_V6 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipmentWithSpecialService3CMPML_V6($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostShipment3CMPML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipment3CMPML $parameters
     * @return \DHL\StructType\DHLPostShipment3CMPMLResponse|bool
     */
    public function PostShipment3CMPML(\DHL\StructType\DHLPostShipment3CMPML $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipment3CMPML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostShipmentCSB2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipmentCSB2 $parameters
     * @return \DHL\StructType\DHLPostShipmentCSB2Response|bool
     */
    public function PostShipmentCSB2(\DHL\StructType\DHLPostShipmentCSB2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipmentCSB2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostShipmentWithSpecialService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipmentWithSpecialService $parameters
     * @return \DHL\StructType\DHLPostShipmentWithSpecialServiceResponse|bool
     */
    public function PostShipmentWithSpecialService(\DHL\StructType\DHLPostShipmentWithSpecialService $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipmentWithSpecialService($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostShipmentWithSpecialServiceCSB2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipmentWithSpecialServiceCSB2 $parameters
     * @return \DHL\StructType\DHLPostShipmentWithSpecialServiceCSB2Response|bool
     */
    public function PostShipmentWithSpecialServiceCSB2(\DHL\StructType\DHLPostShipmentWithSpecialServiceCSB2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipmentWithSpecialServiceCSB2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * PostShipmentWithSpecialServiceCSB2_V6
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipmentWithSpecialServiceCSB2_V6 $parameters
     * @return \DHL\StructType\DHLPostShipmentWithSpecialServiceCSB2_V6Response|bool
     */
    public function PostShipmentWithSpecialServiceCSB2_V6(\DHL\StructType\DHLPostShipmentWithSpecialServiceCSB2_V6 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipmentWithSpecialServiceCSB2_V6($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostShipmentwithCash
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipmentwithCash $parameters
     * @return \DHL\StructType\DHLPostShipmentwithCashResponse|bool
     */
    public function PostShipmentwithCash(\DHL\StructType\DHLPostShipmentwithCash $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipmentwithCash($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * PostShipmentCashwithSpecialServiceCSB5_v6
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipmentCashwithSpecialServiceCSB5_v6 $parameters
     * @return \DHL\StructType\DHLPostShipmentCashwithSpecialServiceCSB5_v6Response|bool
     */
    public function PostShipmentCashwithSpecialServiceCSB5_v6(\DHL\StructType\DHLPostShipmentCashwithSpecialServiceCSB5_v6 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipmentCashwithSpecialServiceCSB5_v6($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PostTracking_AllCheckpoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostTracking_AllCheckpoint $parameters
     * @return \DHL\StructType\DHLPostTracking_AllCheckpointResponse|bool
     */
    public function PostTracking_AllCheckpoint(\DHL\StructType\DHLPostTracking_AllCheckpoint $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostTracking_AllCheckpoint($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * PostTrackingReference_AllCheckpoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostTrackingReference_AllCheckpoint $parameters
     * @return \DHL\StructType\DHLPostTrackingReference_AllCheckpointResponse|bool
     */
    public function PostTrackingReference_AllCheckpoint(\DHL\StructType\DHLPostTrackingReference_AllCheckpoint $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostTrackingReference_AllCheckpoint($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * PostShipmentWithSpecialServiceSCC_V6
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipmentWithSpecialServiceSCC_V6 $parameters
     * @return \DHL\StructType\DHLPostShipmentWithSpecialServiceSCC_V6Response|bool
     */
    public function PostShipmentWithSpecialServiceSCC_V6(\DHL\StructType\DHLPostShipmentWithSpecialServiceSCC_V6 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipmentWithSpecialServiceSCC_V6($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * PostShipmentCashwithSpecialServiceCSB5New_v6
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipmentCashwithSpecialServiceCSB5New_v6 $parameters
     * @return \DHL\StructType\DHLPostShipmentCashwithSpecialServiceCSB5New_v6Response|bool
     */
    public function PostShipmentCashwithSpecialServiceCSB5New_v6(\DHL\StructType\DHLPostShipmentCashwithSpecialServiceCSB5New_v6 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipmentCashwithSpecialServiceCSB5New_v6($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * PostShipmentWithSpecialService3CMPMLNew_V6
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLPostShipmentWithSpecialService3CMPMLNew_V6 $parameters
     * @return \DHL\StructType\DHLPostShipmentWithSpecialService3CMPMLNew_V6Response|bool
     */
    public function PostShipmentWithSpecialService3CMPMLNew_V6(\DHL\StructType\DHLPostShipmentWithSpecialService3CMPMLNew_V6 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PostShipmentWithSpecialService3CMPMLNew_V6($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \DHL\StructType\DHLPostCapabilityResponse|\DHL\StructType\DHLPostPickupResponse|\DHL\StructType\DHLPostPickup_v6Response|\DHL\StructType\DHLPostQuotePosResponse|\DHL\StructType\DHLPostQuotePos_V6Response|\DHL\StructType\DHLPostQuoteResponse|\DHL\StructType\DHLPostQuote_RASResponse|\DHL\StructType\DHLPostShipment3CMPMLResponse|\DHL\StructType\DHLPostShipment3CMPML_V6Response|\DHL\StructType\DHLPostShipment3CResponse|\DHL\StructType\DHLPostShipment3C_V6Response|\DHL\StructType\DHLPostShipmentCashwithSpecialServiceCSB5New_v6Response|\DHL\StructType\DHLPostShipmentCashwithSpecialServiceCSB5_v6Response|\DHL\StructType\DHLPostShipmentCashwithSpecialServiceResponse|\DHL\StructType\DHLPostShipmentCashwithSpecialService_v6Response|\DHL\StructType\DHLPostShipmentCSB2Response|\DHL\StructType\DHLPostShipmentCSB2_V6Response|\DHL\StructType\DHLPostShipmentResponse|\DHL\StructType\DHLPostShipmentwithCashResponse|\DHL\StructType\DHLPostShipmentwithCash_V6Response|\DHL\StructType\DHLPostShipmentWithSpecialService3CMPMLNew_V6Response|\DHL\StructType\DHLPostShipmentWithSpecialService3CMPMLResponse|\DHL\StructType\DHLPostShipmentWithSpecialService3CMPML_V6Response|\DHL\StructType\DHLPostShipmentWithSpecialService3CResponse|\DHL\StructType\DHLPostShipmentWithSpecialService3C_V6Response|\DHL\StructType\DHLPostShipmentWithSpecialServiceCSB2Response|\DHL\StructType\DHLPostShipmentWithSpecialServiceCSB2_INSResponse|\DHL\StructType\DHLPostShipmentWithSpecialServiceCSB2_V6Response|\DHL\StructType\DHLPostShipmentWithSpecialServiceResponse|\DHL\StructType\DHLPostShipmentWithSpecialServiceSCC_V6Response|\DHL\StructType\DHLPostShipmentWithSpecialService_INSResponse|\DHL\StructType\DHLPostShipment_V6Response|\DHL\StructType\DHLPostTrackingReferenceResponse|\DHL\StructType\DHLPostTrackingReference_AllCheckpointResponse|\DHL\StructType\DHLPostTrackingResponse|\DHL\StructType\DHLPostTracking_AllCheckpointResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
