<?php

namespace DHL\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @package DHL
 * @subpackage Services
 */
class DHLGet extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetIndemnityClause
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DHL\StructType\DHLGetIndemnityClause $parameters
     * @return \DHL\StructType\DHLGetIndemnityClauseResponse|bool
     */
    public function GetIndemnityClause(\DHL\StructType\DHLGetIndemnityClause $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetIndemnityClause($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \DHL\StructType\DHLGetIndemnityClauseResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
