<?php

namespace DHL\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostTrackingResponse StructType
 * @package DHL
 * @subpackage Structs
 */
class DHLPostTrackingResponse extends AbstractStructBase
{
    /**
     * The PostTrackingResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostTrackingResult;
    /**
     * Constructor method for PostTrackingResponse
     * @uses DHLPostTrackingResponse::setPostTrackingResult()
     * @param string $postTrackingResult
     */
    public function __construct($postTrackingResult = null)
    {
        $this
            ->setPostTrackingResult($postTrackingResult);
    }
    /**
     * Get PostTrackingResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostTrackingResult()
    {
        return isset($this->PostTrackingResult) ? $this->PostTrackingResult : null;
    }
    /**
     * Set PostTrackingResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postTrackingResult
     * @return \DHL\StructType\DHLPostTrackingResponse
     */
    public function setPostTrackingResult($postTrackingResult = null)
    {
        // validation for constraint: string
        if (!is_null($postTrackingResult) && !is_string($postTrackingResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postTrackingResult, true), gettype($postTrackingResult)), __LINE__);
        }
        if (is_null($postTrackingResult) || (is_array($postTrackingResult) && empty($postTrackingResult))) {
            unset($this->PostTrackingResult);
        } else {
            $this->PostTrackingResult = $postTrackingResult;
        }
        return $this;
    }
}
