<?php

namespace DHL\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostTracking StructType
 * @package DHL
 * @subpackage Structs
 */
class DHLPostTracking extends AbstractStructBase
{
    /**
     * The awbnumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $awbnumber;
    /**
     * Constructor method for PostTracking
     * @uses DHLPostTracking::setAwbnumber()
     * @param string $awbnumber
     */
    public function __construct($awbnumber = null)
    {
        $this
            ->setAwbnumber($awbnumber);
    }
    /**
     * Get awbnumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAwbnumber()
    {
        return isset($this->awbnumber) ? $this->awbnumber : null;
    }
    /**
     * Set awbnumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $awbnumber
     * @return \DHL\StructType\DHLPostTracking
     */
    public function setAwbnumber($awbnumber = null)
    {
        // validation for constraint: string
        if (!is_null($awbnumber) && !is_string($awbnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($awbnumber, true), gettype($awbnumber)), __LINE__);
        }
        if (is_null($awbnumber) || (is_array($awbnumber) && empty($awbnumber))) {
            unset($this->awbnumber);
        } else {
            $this->awbnumber = $awbnumber;
        }
        return $this;
    }
}
