<?php

namespace DHL\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostShipmentCSB2Response StructType
 * @package DHL
 * @subpackage Structs
 */
class DHLPostShipmentCSB2Response extends AbstractStructBase
{
    /**
     * The PostShipmentCSB2Result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostShipmentCSB2Result;
    /**
     * Constructor method for PostShipmentCSB2Response
     * @uses DHLPostShipmentCSB2Response::setPostShipmentCSB2Result()
     * @param string $postShipmentCSB2Result
     */
    public function __construct($postShipmentCSB2Result = null)
    {
        $this
            ->setPostShipmentCSB2Result($postShipmentCSB2Result);
    }
    /**
     * Get PostShipmentCSB2Result value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostShipmentCSB2Result()
    {
        return isset($this->PostShipmentCSB2Result) ? $this->PostShipmentCSB2Result : null;
    }
    /**
     * Set PostShipmentCSB2Result value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postShipmentCSB2Result
     * @return \DHL\StructType\DHLPostShipmentCSB2Response
     */
    public function setPostShipmentCSB2Result($postShipmentCSB2Result = null)
    {
        // validation for constraint: string
        if (!is_null($postShipmentCSB2Result) && !is_string($postShipmentCSB2Result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postShipmentCSB2Result, true), gettype($postShipmentCSB2Result)), __LINE__);
        }
        if (is_null($postShipmentCSB2Result) || (is_array($postShipmentCSB2Result) && empty($postShipmentCSB2Result))) {
            unset($this->PostShipmentCSB2Result);
        } else {
            $this->PostShipmentCSB2Result = $postShipmentCSB2Result;
        }
        return $this;
    }
}
