<?php

namespace DHL\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostQuotePos StructType
 * @package DHL
 * @subpackage Structs
 */
class DHLPostQuotePos extends AbstractStructBase
{
    /**
     * The ShipperPostCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipperPostCode;
    /**
     * The ReceiverCountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReceiverCountryCode;
    /**
     * The PostCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostCode;
    /**
     * The fromCity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $fromCity;
    /**
     * The IsDutiable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsDutiable;
    /**
     * The PickupHours
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PickupHours;
    /**
     * The PickupMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PickupMinutes;
    /**
     * The DeclaredCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeclaredCurrency;
    /**
     * The DeclaredValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeclaredValue;
    /**
     * The GlobalProductCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GlobalProductCode;
    /**
     * The toCity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $toCity;
    /**
     * The PaymentAccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentAccountNumber;
    /**
     * Constructor method for PostQuotePos
     * @uses DHLPostQuotePos::setShipperPostCode()
     * @uses DHLPostQuotePos::setReceiverCountryCode()
     * @uses DHLPostQuotePos::setPostCode()
     * @uses DHLPostQuotePos::setFromCity()
     * @uses DHLPostQuotePos::setIsDutiable()
     * @uses DHLPostQuotePos::setPickupHours()
     * @uses DHLPostQuotePos::setPickupMinutes()
     * @uses DHLPostQuotePos::setDeclaredCurrency()
     * @uses DHLPostQuotePos::setDeclaredValue()
     * @uses DHLPostQuotePos::setGlobalProductCode()
     * @uses DHLPostQuotePos::setToCity()
     * @uses DHLPostQuotePos::setPaymentAccountNumber()
     * @param string $shipperPostCode
     * @param string $receiverCountryCode
     * @param string $postCode
     * @param string $fromCity
     * @param string $isDutiable
     * @param string $pickupHours
     * @param string $pickupMinutes
     * @param string $declaredCurrency
     * @param string $declaredValue
     * @param string $globalProductCode
     * @param string $toCity
     * @param string $paymentAccountNumber
     */
    public function __construct($shipperPostCode = null, $receiverCountryCode = null, $postCode = null, $fromCity = null, $isDutiable = null, $pickupHours = null, $pickupMinutes = null, $declaredCurrency = null, $declaredValue = null, $globalProductCode = null, $toCity = null, $paymentAccountNumber = null)
    {
        $this
            ->setShipperPostCode($shipperPostCode)
            ->setReceiverCountryCode($receiverCountryCode)
            ->setPostCode($postCode)
            ->setFromCity($fromCity)
            ->setIsDutiable($isDutiable)
            ->setPickupHours($pickupHours)
            ->setPickupMinutes($pickupMinutes)
            ->setDeclaredCurrency($declaredCurrency)
            ->setDeclaredValue($declaredValue)
            ->setGlobalProductCode($globalProductCode)
            ->setToCity($toCity)
            ->setPaymentAccountNumber($paymentAccountNumber);
    }
    /**
     * Get ShipperPostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipperPostCode()
    {
        return isset($this->ShipperPostCode) ? $this->ShipperPostCode : null;
    }
    /**
     * Set ShipperPostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipperPostCode
     * @return \DHL\StructType\DHLPostQuotePos
     */
    public function setShipperPostCode($shipperPostCode = null)
    {
        // validation for constraint: string
        if (!is_null($shipperPostCode) && !is_string($shipperPostCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperPostCode, true), gettype($shipperPostCode)), __LINE__);
        }
        if (is_null($shipperPostCode) || (is_array($shipperPostCode) && empty($shipperPostCode))) {
            unset($this->ShipperPostCode);
        } else {
            $this->ShipperPostCode = $shipperPostCode;
        }
        return $this;
    }
    /**
     * Get ReceiverCountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReceiverCountryCode()
    {
        return isset($this->ReceiverCountryCode) ? $this->ReceiverCountryCode : null;
    }
    /**
     * Set ReceiverCountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $receiverCountryCode
     * @return \DHL\StructType\DHLPostQuotePos
     */
    public function setReceiverCountryCode($receiverCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($receiverCountryCode) && !is_string($receiverCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverCountryCode, true), gettype($receiverCountryCode)), __LINE__);
        }
        if (is_null($receiverCountryCode) || (is_array($receiverCountryCode) && empty($receiverCountryCode))) {
            unset($this->ReceiverCountryCode);
        } else {
            $this->ReceiverCountryCode = $receiverCountryCode;
        }
        return $this;
    }
    /**
     * Get PostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostCode()
    {
        return isset($this->PostCode) ? $this->PostCode : null;
    }
    /**
     * Set PostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postCode
     * @return \DHL\StructType\DHLPostQuotePos
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postCode, true), gettype($postCode)), __LINE__);
        }
        if (is_null($postCode) || (is_array($postCode) && empty($postCode))) {
            unset($this->PostCode);
        } else {
            $this->PostCode = $postCode;
        }
        return $this;
    }
    /**
     * Get fromCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromCity()
    {
        return isset($this->fromCity) ? $this->fromCity : null;
    }
    /**
     * Set fromCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromCity
     * @return \DHL\StructType\DHLPostQuotePos
     */
    public function setFromCity($fromCity = null)
    {
        // validation for constraint: string
        if (!is_null($fromCity) && !is_string($fromCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromCity, true), gettype($fromCity)), __LINE__);
        }
        if (is_null($fromCity) || (is_array($fromCity) && empty($fromCity))) {
            unset($this->fromCity);
        } else {
            $this->fromCity = $fromCity;
        }
        return $this;
    }
    /**
     * Get IsDutiable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsDutiable()
    {
        return isset($this->IsDutiable) ? $this->IsDutiable : null;
    }
    /**
     * Set IsDutiable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isDutiable
     * @return \DHL\StructType\DHLPostQuotePos
     */
    public function setIsDutiable($isDutiable = null)
    {
        // validation for constraint: string
        if (!is_null($isDutiable) && !is_string($isDutiable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isDutiable, true), gettype($isDutiable)), __LINE__);
        }
        if (is_null($isDutiable) || (is_array($isDutiable) && empty($isDutiable))) {
            unset($this->IsDutiable);
        } else {
            $this->IsDutiable = $isDutiable;
        }
        return $this;
    }
    /**
     * Get PickupHours value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPickupHours()
    {
        return isset($this->PickupHours) ? $this->PickupHours : null;
    }
    /**
     * Set PickupHours value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pickupHours
     * @return \DHL\StructType\DHLPostQuotePos
     */
    public function setPickupHours($pickupHours = null)
    {
        // validation for constraint: string
        if (!is_null($pickupHours) && !is_string($pickupHours)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupHours, true), gettype($pickupHours)), __LINE__);
        }
        if (is_null($pickupHours) || (is_array($pickupHours) && empty($pickupHours))) {
            unset($this->PickupHours);
        } else {
            $this->PickupHours = $pickupHours;
        }
        return $this;
    }
    /**
     * Get PickupMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPickupMinutes()
    {
        return isset($this->PickupMinutes) ? $this->PickupMinutes : null;
    }
    /**
     * Set PickupMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pickupMinutes
     * @return \DHL\StructType\DHLPostQuotePos
     */
    public function setPickupMinutes($pickupMinutes = null)
    {
        // validation for constraint: string
        if (!is_null($pickupMinutes) && !is_string($pickupMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupMinutes, true), gettype($pickupMinutes)), __LINE__);
        }
        if (is_null($pickupMinutes) || (is_array($pickupMinutes) && empty($pickupMinutes))) {
            unset($this->PickupMinutes);
        } else {
            $this->PickupMinutes = $pickupMinutes;
        }
        return $this;
    }
    /**
     * Get DeclaredCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeclaredCurrency()
    {
        return isset($this->DeclaredCurrency) ? $this->DeclaredCurrency : null;
    }
    /**
     * Set DeclaredCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $declaredCurrency
     * @return \DHL\StructType\DHLPostQuotePos
     */
    public function setDeclaredCurrency($declaredCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($declaredCurrency) && !is_string($declaredCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($declaredCurrency, true), gettype($declaredCurrency)), __LINE__);
        }
        if (is_null($declaredCurrency) || (is_array($declaredCurrency) && empty($declaredCurrency))) {
            unset($this->DeclaredCurrency);
        } else {
            $this->DeclaredCurrency = $declaredCurrency;
        }
        return $this;
    }
    /**
     * Get DeclaredValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeclaredValue()
    {
        return isset($this->DeclaredValue) ? $this->DeclaredValue : null;
    }
    /**
     * Set DeclaredValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $declaredValue
     * @return \DHL\StructType\DHLPostQuotePos
     */
    public function setDeclaredValue($declaredValue = null)
    {
        // validation for constraint: string
        if (!is_null($declaredValue) && !is_string($declaredValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($declaredValue, true), gettype($declaredValue)), __LINE__);
        }
        if (is_null($declaredValue) || (is_array($declaredValue) && empty($declaredValue))) {
            unset($this->DeclaredValue);
        } else {
            $this->DeclaredValue = $declaredValue;
        }
        return $this;
    }
    /**
     * Get GlobalProductCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGlobalProductCode()
    {
        return isset($this->GlobalProductCode) ? $this->GlobalProductCode : null;
    }
    /**
     * Set GlobalProductCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $globalProductCode
     * @return \DHL\StructType\DHLPostQuotePos
     */
    public function setGlobalProductCode($globalProductCode = null)
    {
        // validation for constraint: string
        if (!is_null($globalProductCode) && !is_string($globalProductCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($globalProductCode, true), gettype($globalProductCode)), __LINE__);
        }
        if (is_null($globalProductCode) || (is_array($globalProductCode) && empty($globalProductCode))) {
            unset($this->GlobalProductCode);
        } else {
            $this->GlobalProductCode = $globalProductCode;
        }
        return $this;
    }
    /**
     * Get toCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToCity()
    {
        return isset($this->toCity) ? $this->toCity : null;
    }
    /**
     * Set toCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toCity
     * @return \DHL\StructType\DHLPostQuotePos
     */
    public function setToCity($toCity = null)
    {
        // validation for constraint: string
        if (!is_null($toCity) && !is_string($toCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toCity, true), gettype($toCity)), __LINE__);
        }
        if (is_null($toCity) || (is_array($toCity) && empty($toCity))) {
            unset($this->toCity);
        } else {
            $this->toCity = $toCity;
        }
        return $this;
    }
    /**
     * Get PaymentAccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentAccountNumber()
    {
        return isset($this->PaymentAccountNumber) ? $this->PaymentAccountNumber : null;
    }
    /**
     * Set PaymentAccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentAccountNumber
     * @return \DHL\StructType\DHLPostQuotePos
     */
    public function setPaymentAccountNumber($paymentAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($paymentAccountNumber) && !is_string($paymentAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentAccountNumber, true), gettype($paymentAccountNumber)), __LINE__);
        }
        if (is_null($paymentAccountNumber) || (is_array($paymentAccountNumber) && empty($paymentAccountNumber))) {
            unset($this->PaymentAccountNumber);
        } else {
            $this->PaymentAccountNumber = $paymentAccountNumber;
        }
        return $this;
    }
}
