<?php

namespace DHL\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostPickupResponse StructType
 * @package DHL
 * @subpackage Structs
 */
class DHLPostPickupResponse extends AbstractStructBase
{
    /**
     * The PostPickupResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostPickupResult;
    /**
     * Constructor method for PostPickupResponse
     * @uses DHLPostPickupResponse::setPostPickupResult()
     * @param string $postPickupResult
     */
    public function __construct($postPickupResult = null)
    {
        $this
            ->setPostPickupResult($postPickupResult);
    }
    /**
     * Get PostPickupResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostPickupResult()
    {
        return isset($this->PostPickupResult) ? $this->PostPickupResult : null;
    }
    /**
     * Set PostPickupResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postPickupResult
     * @return \DHL\StructType\DHLPostPickupResponse
     */
    public function setPostPickupResult($postPickupResult = null)
    {
        // validation for constraint: string
        if (!is_null($postPickupResult) && !is_string($postPickupResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postPickupResult, true), gettype($postPickupResult)), __LINE__);
        }
        if (is_null($postPickupResult) || (is_array($postPickupResult) && empty($postPickupResult))) {
            unset($this->PostPickupResult);
        } else {
            $this->PostPickupResult = $postPickupResult;
        }
        return $this;
    }
}
