<?php

namespace DHL\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostCapabilityResponse StructType
 * @package DHL
 * @subpackage Structs
 */
class DHLPostCapabilityResponse extends AbstractStructBase
{
    /**
     * The PostCapabilityResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostCapabilityResult;
    /**
     * Constructor method for PostCapabilityResponse
     * @uses DHLPostCapabilityResponse::setPostCapabilityResult()
     * @param string $postCapabilityResult
     */
    public function __construct($postCapabilityResult = null)
    {
        $this
            ->setPostCapabilityResult($postCapabilityResult);
    }
    /**
     * Get PostCapabilityResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostCapabilityResult()
    {
        return isset($this->PostCapabilityResult) ? $this->PostCapabilityResult : null;
    }
    /**
     * Set PostCapabilityResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postCapabilityResult
     * @return \DHL\StructType\DHLPostCapabilityResponse
     */
    public function setPostCapabilityResult($postCapabilityResult = null)
    {
        // validation for constraint: string
        if (!is_null($postCapabilityResult) && !is_string($postCapabilityResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postCapabilityResult, true), gettype($postCapabilityResult)), __LINE__);
        }
        if (is_null($postCapabilityResult) || (is_array($postCapabilityResult) && empty($postCapabilityResult))) {
            unset($this->PostCapabilityResult);
        } else {
            $this->PostCapabilityResult = $postCapabilityResult;
        }
        return $this;
    }
}
