<?php

namespace \TestSpace\WsdlExample\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Say ServiceType
 * @subpackage Services
 */
class Say extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sayHello
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $firstName
     * @return string|bool
     */
    public function sayHello($firstName)
    {
        try {
            $this->setResult($this->getSoapClient()->sayHello($firstName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
