<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://a3693855d8a8.ngrok.io/?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://a3693855d8a8.ngrok.io/?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Hello ServiceType
 */
$hello = new \ServiceType\Hello($options);
/**
 * Sample call for hello operation/method
 */
if ($hello->hello(new \StructType\Hello()) !== false) {
    print_r($hello->getResult());
} else {
    print_r($hello->getLastError());
}
/**
 * Samples for Me ServiceType
 */
$me = new \ServiceType\Me($options);
/**
 * Sample call for me operation/method
 */
if ($me->me(new \StructType\Me()) !== false) {
    print_r($me->getResult());
} else {
    print_r($me->getLastError());
}
