<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Me ServiceType
 * @subpackage Services
 */
class Me extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named me
     * Meta information extracted from the WSDL
     * - documentation: Returns yoyr data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Me $parameters
     * @return \StructType\MeResponse|bool
     */
    public function me(\StructType\Me $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->me($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
