<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Ctrl ServiceType
 */
$ctrl = new \ServiceType\Ctrl($options);
/**
 * Sample call for CtrlWS operation/method
 */
if ($ctrl->CtrlWS() !== false) {
    print_r($ctrl->getResult());
} else {
    print_r($ctrl->getLastError());
}
/**
 * Sample call for CtrlCoupon operation/method
 */
if ($ctrl->CtrlCoupon($sLogin, $sMdp, $sCode) !== false) {
    print_r($ctrl->getResult());
} else {
    print_r($ctrl->getLastError());
}
/**
 * Sample call for CtrlLogin operation/method
 */
if ($ctrl->CtrlLogin($sLogin, $sMdp) !== false) {
    print_r($ctrl->getResult());
} else {
    print_r($ctrl->getLastError());
}
/**
 * Samples for DH ServiceType
 */
$dH = new \ServiceType\DH($options);
/**
 * Sample call for DHeureSys operation/method
 */
if ($dH->DHeureSys() !== false) {
    print_r($dH->getResult());
} else {
    print_r($dH->getLastError());
}
/**
 * Samples for Valide ServiceType
 */
$valide = new \ServiceType\Valide($options);
/**
 * Sample call for ValideCoupon operation/method
 */
if ($valide->ValideCoupon($sLogin, $sMdp, $sCode, $Prix) !== false) {
    print_r($valide->getResult());
} else {
    print_r($valide->getLastError());
}
/**
 * Samples for Annule ServiceType
 */
$annule = new \ServiceType\Annule($options);
/**
 * Sample call for AnnuleCoupon operation/method
 */
if ($annule->AnnuleCoupon($sLogin, $sMdp, $sCode) !== false) {
    print_r($annule->getResult());
} else {
    print_r($annule->getLastError());
}
