<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for STSoft StructType
 * Meta information extracted from the WSDL
 * - nomcomplet: WSLescrans.STSoft
 * @subpackage Structs
 */
class STSoft extends AbstractStructBase
{
    /**
     * The sLibErr
     * @var string
     */
    public $sLibErr;
    /**
     * The MajFic
     * @var string
     */
    public $MajFic;
    /**
     * The bTrace
     * @var bool
     */
    public $bTrace;
    /**
     * The DateS
     * @var string
     */
    public $DateS;
    /**
     * The bErr
     * @var bool
     */
    public $bErr;
    /**
     * The ModeServ
     * @var bool
     */
    public $ModeServ;
    /**
     * The ModeTest
     * @var bool
     */
    public $ModeTest;
    /**
     * The ModeDev
     * @var bool
     */
    public $ModeDev;
    /**
     * The ModeDemo
     * @var bool
     */
    public $ModeDemo;
    /**
     * The bFerme
     * @var bool
     */
    public $bFerme;
    /**
     * The MdpFic
     * @var string
     */
    public $MdpFic;
    /**
     * The MdpSoft
     * @var string
     */
    public $MdpSoft;
    /**
     * The NomComplet
     * @var string
     */
    public $NomComplet;
    /**
     * The NomExe
     * @var string
     */
    public $NomExe;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The HeureS
     * @var string
     */
    public $HeureS;
    /**
     * The FtpId
     * @var string
     */
    public $FtpId;
    /**
     * The ZipId
     * @var string
     */
    public $ZipId;
    /**
     * The ZipNom
     * @var string
     */
    public $ZipNom;
    /**
     * The FtpEnCours
     * @var string
     */
    public $FtpEnCours;
    /**
     * The ZipEnCours
     * @var string
     */
    public $ZipEnCours;
    /**
     * The sZipRet
     * @var string
     */
    public $sZipRet;
    /**
     * The nMailTimeOut
     * @var int
     */
    public $nMailTimeOut;
    /**
     * The nHttpTimeOut
     * @var int
     */
    public $nHttpTimeOut;
    /**
     * The HttpRet
     * @var string
     */
    public $HttpRet;
    /**
     * The CineCode
     * @var string
     */
    public $CineCode;
    /**
     * The PCsId
     * @var string
     */
    public $PCsId;
    /**
     * Constructor method for STSoft
     * @uses STSoft::setSLibErr()
     * @uses STSoft::setMajFic()
     * @uses STSoft::setBTrace()
     * @uses STSoft::setDateS()
     * @uses STSoft::setBErr()
     * @uses STSoft::setModeServ()
     * @uses STSoft::setModeTest()
     * @uses STSoft::setModeDev()
     * @uses STSoft::setModeDemo()
     * @uses STSoft::setBFerme()
     * @uses STSoft::setMdpFic()
     * @uses STSoft::setMdpSoft()
     * @uses STSoft::setNomComplet()
     * @uses STSoft::setNomExe()
     * @uses STSoft::setVersion()
     * @uses STSoft::setHeureS()
     * @uses STSoft::setFtpId()
     * @uses STSoft::setZipId()
     * @uses STSoft::setZipNom()
     * @uses STSoft::setFtpEnCours()
     * @uses STSoft::setZipEnCours()
     * @uses STSoft::setSZipRet()
     * @uses STSoft::setNMailTimeOut()
     * @uses STSoft::setNHttpTimeOut()
     * @uses STSoft::setHttpRet()
     * @uses STSoft::setCineCode()
     * @uses STSoft::setPCsId()
     * @param string $sLibErr
     * @param string $majFic
     * @param bool $bTrace
     * @param string $dateS
     * @param bool $bErr
     * @param bool $modeServ
     * @param bool $modeTest
     * @param bool $modeDev
     * @param bool $modeDemo
     * @param bool $bFerme
     * @param string $mdpFic
     * @param string $mdpSoft
     * @param string $nomComplet
     * @param string $nomExe
     * @param string $version
     * @param string $heureS
     * @param string $ftpId
     * @param string $zipId
     * @param string $zipNom
     * @param string $ftpEnCours
     * @param string $zipEnCours
     * @param string $sZipRet
     * @param int $nMailTimeOut
     * @param int $nHttpTimeOut
     * @param string $httpRet
     * @param string $cineCode
     * @param string $pCsId
     */
    public function __construct($sLibErr = null, $majFic = null, $bTrace = null, $dateS = null, $bErr = null, $modeServ = null, $modeTest = null, $modeDev = null, $modeDemo = null, $bFerme = null, $mdpFic = null, $mdpSoft = null, $nomComplet = null, $nomExe = null, $version = null, $heureS = null, $ftpId = null, $zipId = null, $zipNom = null, $ftpEnCours = null, $zipEnCours = null, $sZipRet = null, $nMailTimeOut = null, $nHttpTimeOut = null, $httpRet = null, $cineCode = null, $pCsId = null)
    {
        $this
            ->setSLibErr($sLibErr)
            ->setMajFic($majFic)
            ->setBTrace($bTrace)
            ->setDateS($dateS)
            ->setBErr($bErr)
            ->setModeServ($modeServ)
            ->setModeTest($modeTest)
            ->setModeDev($modeDev)
            ->setModeDemo($modeDemo)
            ->setBFerme($bFerme)
            ->setMdpFic($mdpFic)
            ->setMdpSoft($mdpSoft)
            ->setNomComplet($nomComplet)
            ->setNomExe($nomExe)
            ->setVersion($version)
            ->setHeureS($heureS)
            ->setFtpId($ftpId)
            ->setZipId($zipId)
            ->setZipNom($zipNom)
            ->setFtpEnCours($ftpEnCours)
            ->setZipEnCours($zipEnCours)
            ->setSZipRet($sZipRet)
            ->setNMailTimeOut($nMailTimeOut)
            ->setNHttpTimeOut($nHttpTimeOut)
            ->setHttpRet($httpRet)
            ->setCineCode($cineCode)
            ->setPCsId($pCsId);
    }
    /**
     * Get sLibErr value
     * @return string|null
     */
    public function getSLibErr()
    {
        return $this->sLibErr;
    }
    /**
     * Set sLibErr value
     * @param string $sLibErr
     * @return \StructType\STSoft
     */
    public function setSLibErr($sLibErr = null)
    {
        // validation for constraint: string
        if (!is_null($sLibErr) && !is_string($sLibErr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLibErr, true), gettype($sLibErr)), __LINE__);
        }
        $this->sLibErr = $sLibErr;
        return $this;
    }
    /**
     * Get MajFic value
     * @return string|null
     */
    public function getMajFic()
    {
        return $this->MajFic;
    }
    /**
     * Set MajFic value
     * @param string $majFic
     * @return \StructType\STSoft
     */
    public function setMajFic($majFic = null)
    {
        // validation for constraint: string
        if (!is_null($majFic) && !is_string($majFic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($majFic, true), gettype($majFic)), __LINE__);
        }
        $this->MajFic = $majFic;
        return $this;
    }
    /**
     * Get bTrace value
     * @return bool|null
     */
    public function getBTrace()
    {
        return $this->bTrace;
    }
    /**
     * Set bTrace value
     * @param bool $bTrace
     * @return \StructType\STSoft
     */
    public function setBTrace($bTrace = null)
    {
        // validation for constraint: boolean
        if (!is_null($bTrace) && !is_bool($bTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bTrace, true), gettype($bTrace)), __LINE__);
        }
        $this->bTrace = $bTrace;
        return $this;
    }
    /**
     * Get DateS value
     * @return string|null
     */
    public function getDateS()
    {
        return $this->DateS;
    }
    /**
     * Set DateS value
     * @param string $dateS
     * @return \StructType\STSoft
     */
    public function setDateS($dateS = null)
    {
        // validation for constraint: string
        if (!is_null($dateS) && !is_string($dateS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateS, true), gettype($dateS)), __LINE__);
        }
        $this->DateS = $dateS;
        return $this;
    }
    /**
     * Get bErr value
     * @return bool|null
     */
    public function getBErr()
    {
        return $this->bErr;
    }
    /**
     * Set bErr value
     * @param bool $bErr
     * @return \StructType\STSoft
     */
    public function setBErr($bErr = null)
    {
        // validation for constraint: boolean
        if (!is_null($bErr) && !is_bool($bErr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bErr, true), gettype($bErr)), __LINE__);
        }
        $this->bErr = $bErr;
        return $this;
    }
    /**
     * Get ModeServ value
     * @return bool|null
     */
    public function getModeServ()
    {
        return $this->ModeServ;
    }
    /**
     * Set ModeServ value
     * @param bool $modeServ
     * @return \StructType\STSoft
     */
    public function setModeServ($modeServ = null)
    {
        // validation for constraint: boolean
        if (!is_null($modeServ) && !is_bool($modeServ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modeServ, true), gettype($modeServ)), __LINE__);
        }
        $this->ModeServ = $modeServ;
        return $this;
    }
    /**
     * Get ModeTest value
     * @return bool|null
     */
    public function getModeTest()
    {
        return $this->ModeTest;
    }
    /**
     * Set ModeTest value
     * @param bool $modeTest
     * @return \StructType\STSoft
     */
    public function setModeTest($modeTest = null)
    {
        // validation for constraint: boolean
        if (!is_null($modeTest) && !is_bool($modeTest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modeTest, true), gettype($modeTest)), __LINE__);
        }
        $this->ModeTest = $modeTest;
        return $this;
    }
    /**
     * Get ModeDev value
     * @return bool|null
     */
    public function getModeDev()
    {
        return $this->ModeDev;
    }
    /**
     * Set ModeDev value
     * @param bool $modeDev
     * @return \StructType\STSoft
     */
    public function setModeDev($modeDev = null)
    {
        // validation for constraint: boolean
        if (!is_null($modeDev) && !is_bool($modeDev)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modeDev, true), gettype($modeDev)), __LINE__);
        }
        $this->ModeDev = $modeDev;
        return $this;
    }
    /**
     * Get ModeDemo value
     * @return bool|null
     */
    public function getModeDemo()
    {
        return $this->ModeDemo;
    }
    /**
     * Set ModeDemo value
     * @param bool $modeDemo
     * @return \StructType\STSoft
     */
    public function setModeDemo($modeDemo = null)
    {
        // validation for constraint: boolean
        if (!is_null($modeDemo) && !is_bool($modeDemo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modeDemo, true), gettype($modeDemo)), __LINE__);
        }
        $this->ModeDemo = $modeDemo;
        return $this;
    }
    /**
     * Get bFerme value
     * @return bool|null
     */
    public function getBFerme()
    {
        return $this->bFerme;
    }
    /**
     * Set bFerme value
     * @param bool $bFerme
     * @return \StructType\STSoft
     */
    public function setBFerme($bFerme = null)
    {
        // validation for constraint: boolean
        if (!is_null($bFerme) && !is_bool($bFerme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bFerme, true), gettype($bFerme)), __LINE__);
        }
        $this->bFerme = $bFerme;
        return $this;
    }
    /**
     * Get MdpFic value
     * @return string|null
     */
    public function getMdpFic()
    {
        return $this->MdpFic;
    }
    /**
     * Set MdpFic value
     * @param string $mdpFic
     * @return \StructType\STSoft
     */
    public function setMdpFic($mdpFic = null)
    {
        // validation for constraint: string
        if (!is_null($mdpFic) && !is_string($mdpFic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdpFic, true), gettype($mdpFic)), __LINE__);
        }
        $this->MdpFic = $mdpFic;
        return $this;
    }
    /**
     * Get MdpSoft value
     * @return string|null
     */
    public function getMdpSoft()
    {
        return $this->MdpSoft;
    }
    /**
     * Set MdpSoft value
     * @param string $mdpSoft
     * @return \StructType\STSoft
     */
    public function setMdpSoft($mdpSoft = null)
    {
        // validation for constraint: string
        if (!is_null($mdpSoft) && !is_string($mdpSoft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mdpSoft, true), gettype($mdpSoft)), __LINE__);
        }
        $this->MdpSoft = $mdpSoft;
        return $this;
    }
    /**
     * Get NomComplet value
     * @return string|null
     */
    public function getNomComplet()
    {
        return $this->NomComplet;
    }
    /**
     * Set NomComplet value
     * @param string $nomComplet
     * @return \StructType\STSoft
     */
    public function setNomComplet($nomComplet = null)
    {
        // validation for constraint: string
        if (!is_null($nomComplet) && !is_string($nomComplet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomComplet, true), gettype($nomComplet)), __LINE__);
        }
        $this->NomComplet = $nomComplet;
        return $this;
    }
    /**
     * Get NomExe value
     * @return string|null
     */
    public function getNomExe()
    {
        return $this->NomExe;
    }
    /**
     * Set NomExe value
     * @param string $nomExe
     * @return \StructType\STSoft
     */
    public function setNomExe($nomExe = null)
    {
        // validation for constraint: string
        if (!is_null($nomExe) && !is_string($nomExe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomExe, true), gettype($nomExe)), __LINE__);
        }
        $this->NomExe = $nomExe;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\STSoft
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get HeureS value
     * @return string|null
     */
    public function getHeureS()
    {
        return $this->HeureS;
    }
    /**
     * Set HeureS value
     * @param string $heureS
     * @return \StructType\STSoft
     */
    public function setHeureS($heureS = null)
    {
        // validation for constraint: string
        if (!is_null($heureS) && !is_string($heureS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($heureS, true), gettype($heureS)), __LINE__);
        }
        $this->HeureS = $heureS;
        return $this;
    }
    /**
     * Get FtpId value
     * @return string|null
     */
    public function getFtpId()
    {
        return $this->FtpId;
    }
    /**
     * Set FtpId value
     * @param string $ftpId
     * @return \StructType\STSoft
     */
    public function setFtpId($ftpId = null)
    {
        // validation for constraint: string
        if (!is_null($ftpId) && !is_string($ftpId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ftpId, true), gettype($ftpId)), __LINE__);
        }
        $this->FtpId = $ftpId;
        return $this;
    }
    /**
     * Get ZipId value
     * @return string|null
     */
    public function getZipId()
    {
        return $this->ZipId;
    }
    /**
     * Set ZipId value
     * @param string $zipId
     * @return \StructType\STSoft
     */
    public function setZipId($zipId = null)
    {
        // validation for constraint: string
        if (!is_null($zipId) && !is_string($zipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipId, true), gettype($zipId)), __LINE__);
        }
        $this->ZipId = $zipId;
        return $this;
    }
    /**
     * Get ZipNom value
     * @return string|null
     */
    public function getZipNom()
    {
        return $this->ZipNom;
    }
    /**
     * Set ZipNom value
     * @param string $zipNom
     * @return \StructType\STSoft
     */
    public function setZipNom($zipNom = null)
    {
        // validation for constraint: string
        if (!is_null($zipNom) && !is_string($zipNom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipNom, true), gettype($zipNom)), __LINE__);
        }
        $this->ZipNom = $zipNom;
        return $this;
    }
    /**
     * Get FtpEnCours value
     * @return string|null
     */
    public function getFtpEnCours()
    {
        return $this->FtpEnCours;
    }
    /**
     * Set FtpEnCours value
     * @param string $ftpEnCours
     * @return \StructType\STSoft
     */
    public function setFtpEnCours($ftpEnCours = null)
    {
        // validation for constraint: string
        if (!is_null($ftpEnCours) && !is_string($ftpEnCours)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ftpEnCours, true), gettype($ftpEnCours)), __LINE__);
        }
        $this->FtpEnCours = $ftpEnCours;
        return $this;
    }
    /**
     * Get ZipEnCours value
     * @return string|null
     */
    public function getZipEnCours()
    {
        return $this->ZipEnCours;
    }
    /**
     * Set ZipEnCours value
     * @param string $zipEnCours
     * @return \StructType\STSoft
     */
    public function setZipEnCours($zipEnCours = null)
    {
        // validation for constraint: string
        if (!is_null($zipEnCours) && !is_string($zipEnCours)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipEnCours, true), gettype($zipEnCours)), __LINE__);
        }
        $this->ZipEnCours = $zipEnCours;
        return $this;
    }
    /**
     * Get sZipRet value
     * @return string|null
     */
    public function getSZipRet()
    {
        return $this->sZipRet;
    }
    /**
     * Set sZipRet value
     * @param string $sZipRet
     * @return \StructType\STSoft
     */
    public function setSZipRet($sZipRet = null)
    {
        // validation for constraint: string
        if (!is_null($sZipRet) && !is_string($sZipRet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sZipRet, true), gettype($sZipRet)), __LINE__);
        }
        $this->sZipRet = $sZipRet;
        return $this;
    }
    /**
     * Get nMailTimeOut value
     * @return int|null
     */
    public function getNMailTimeOut()
    {
        return $this->nMailTimeOut;
    }
    /**
     * Set nMailTimeOut value
     * @param int $nMailTimeOut
     * @return \StructType\STSoft
     */
    public function setNMailTimeOut($nMailTimeOut = null)
    {
        // validation for constraint: int
        if (!is_null($nMailTimeOut) && !(is_int($nMailTimeOut) || ctype_digit($nMailTimeOut))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nMailTimeOut, true), gettype($nMailTimeOut)), __LINE__);
        }
        $this->nMailTimeOut = $nMailTimeOut;
        return $this;
    }
    /**
     * Get nHttpTimeOut value
     * @return int|null
     */
    public function getNHttpTimeOut()
    {
        return $this->nHttpTimeOut;
    }
    /**
     * Set nHttpTimeOut value
     * @param int $nHttpTimeOut
     * @return \StructType\STSoft
     */
    public function setNHttpTimeOut($nHttpTimeOut = null)
    {
        // validation for constraint: int
        if (!is_null($nHttpTimeOut) && !(is_int($nHttpTimeOut) || ctype_digit($nHttpTimeOut))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nHttpTimeOut, true), gettype($nHttpTimeOut)), __LINE__);
        }
        $this->nHttpTimeOut = $nHttpTimeOut;
        return $this;
    }
    /**
     * Get HttpRet value
     * @return string|null
     */
    public function getHttpRet()
    {
        return $this->HttpRet;
    }
    /**
     * Set HttpRet value
     * @param string $httpRet
     * @return \StructType\STSoft
     */
    public function setHttpRet($httpRet = null)
    {
        // validation for constraint: string
        if (!is_null($httpRet) && !is_string($httpRet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($httpRet, true), gettype($httpRet)), __LINE__);
        }
        $this->HttpRet = $httpRet;
        return $this;
    }
    /**
     * Get CineCode value
     * @return string|null
     */
    public function getCineCode()
    {
        return $this->CineCode;
    }
    /**
     * Set CineCode value
     * @param string $cineCode
     * @return \StructType\STSoft
     */
    public function setCineCode($cineCode = null)
    {
        // validation for constraint: string
        if (!is_null($cineCode) && !is_string($cineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cineCode, true), gettype($cineCode)), __LINE__);
        }
        $this->CineCode = $cineCode;
        return $this;
    }
    /**
     * Get PCsId value
     * @return string|null
     */
    public function getPCsId()
    {
        return $this->PCsId;
    }
    /**
     * Set PCsId value
     * @param string $pCsId
     * @return \StructType\STSoft
     */
    public function setPCsId($pCsId = null)
    {
        // validation for constraint: string
        if (!is_null($pCsId) && !is_string($pCsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pCsId, true), gettype($pCsId)), __LINE__);
        }
        $this->PCsId = $pCsId;
        return $this;
    }
}
