<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ctrl ServiceType
 * @subpackage Services
 */
class Ctrl extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CtrlWS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function CtrlWS()
    {
        try {
            $this->setResult($this->getSoapClient()->CtrlWS());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CtrlCoupon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sLogin
     * @param string $sMdp
     * @param string $sCode
     * @return string|bool
     */
    public function CtrlCoupon($sLogin, $sMdp, $sCode)
    {
        try {
            $this->setResult($this->getSoapClient()->CtrlCoupon($sLogin, $sMdp, $sCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CtrlLogin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sLogin
     * @param string $sMdp
     * @return string|bool
     */
    public function CtrlLogin($sLogin, $sMdp)
    {
        try {
            $this->setResult($this->getSoapClient()->CtrlLogin($sLogin, $sMdp));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
