<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StWS StructType
 * Meta information extracted from the WSDL
 * - nomcomplet: WSLescrans.StWS
 * @subpackage Structs
 */
class StWS extends AbstractStructBase
{
    /**
     * The CodErr
     * @var int
     */
    public $CodErr;
    /**
     * The TxtErr
     * @var string
     */
    public $TxtErr;
    /**
     * The Reponse
     * @var string
     */
    public $Reponse;
    /**
     * The sData
     * @var string
     */
    public $sData;
    /**
     * Constructor method for StWS
     * @uses StWS::setCodErr()
     * @uses StWS::setTxtErr()
     * @uses StWS::setReponse()
     * @uses StWS::setSData()
     * @param int $codErr
     * @param string $txtErr
     * @param string $reponse
     * @param string $sData
     */
    public function __construct($codErr = null, $txtErr = null, $reponse = null, $sData = null)
    {
        $this
            ->setCodErr($codErr)
            ->setTxtErr($txtErr)
            ->setReponse($reponse)
            ->setSData($sData);
    }
    /**
     * Get CodErr value
     * @return int|null
     */
    public function getCodErr()
    {
        return $this->CodErr;
    }
    /**
     * Set CodErr value
     * @param int $codErr
     * @return \StructType\StWS
     */
    public function setCodErr($codErr = null)
    {
        // validation for constraint: int
        if (!is_null($codErr) && !(is_int($codErr) || ctype_digit($codErr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codErr, true), gettype($codErr)), __LINE__);
        }
        $this->CodErr = $codErr;
        return $this;
    }
    /**
     * Get TxtErr value
     * @return string|null
     */
    public function getTxtErr()
    {
        return $this->TxtErr;
    }
    /**
     * Set TxtErr value
     * @param string $txtErr
     * @return \StructType\StWS
     */
    public function setTxtErr($txtErr = null)
    {
        // validation for constraint: string
        if (!is_null($txtErr) && !is_string($txtErr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($txtErr, true), gettype($txtErr)), __LINE__);
        }
        $this->TxtErr = $txtErr;
        return $this;
    }
    /**
     * Get Reponse value
     * @return string|null
     */
    public function getReponse()
    {
        return $this->Reponse;
    }
    /**
     * Set Reponse value
     * @param string $reponse
     * @return \StructType\StWS
     */
    public function setReponse($reponse = null)
    {
        // validation for constraint: string
        if (!is_null($reponse) && !is_string($reponse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reponse, true), gettype($reponse)), __LINE__);
        }
        $this->Reponse = $reponse;
        return $this;
    }
    /**
     * Get sData value
     * @return string|null
     */
    public function getSData()
    {
        return $this->sData;
    }
    /**
     * Set sData value
     * @param string $sData
     * @return \StructType\StWS
     */
    public function setSData($sData = null)
    {
        // validation for constraint: string
        if (!is_null($sData) && !is_string($sData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sData, true), gettype($sData)), __LINE__);
        }
        $this->sData = $sData;
        return $this;
    }
}
