<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Valide ServiceType
 * @subpackage Services
 */
class Valide extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ValideCoupon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sLogin
     * @param string $sMdp
     * @param string $sCode
     * @param string $prix
     * @return string|bool
     */
    public function ValideCoupon($sLogin, $sMdp, $sCode, $prix)
    {
        try {
            $this->setResult($this->getSoapClient()->ValideCoupon($sLogin, $sMdp, $sCode, $prix));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
