<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for STRep StructType
 * Meta information extracted from the WSDL
 * - nomcomplet: WSLescrans.STRep
 * @subpackage Structs
 */
class STRep extends AbstractStructBase
{
    /**
     * The OrigL
     * @var string
     */
    public $OrigL;
    /**
     * The OrigS
     * @var string
     */
    public $OrigS;
    /**
     * The Fic
     * @var string
     */
    public $Fic;
    /**
     * The Exe
     * @var string
     */
    public $Exe;
    /**
     * The ExeL
     * @var string
     */
    public $ExeL;
    /**
     * The Image
     * @var string
     */
    public $Image;
    /**
     * The Client
     * @var string
     */
    public $Client;
    /**
     * The Export
     * @var string
     */
    public $Export;
    /**
     * The Divers
     * @var string
     */
    public $Divers;
    /**
     * The BA
     * @var string
     */
    public $BA;
    /**
     * Constructor method for STRep
     * @uses STRep::setOrigL()
     * @uses STRep::setOrigS()
     * @uses STRep::setFic()
     * @uses STRep::setExe()
     * @uses STRep::setExeL()
     * @uses STRep::setImage()
     * @uses STRep::setClient()
     * @uses STRep::setExport()
     * @uses STRep::setDivers()
     * @uses STRep::setBA()
     * @param string $origL
     * @param string $origS
     * @param string $fic
     * @param string $exe
     * @param string $exeL
     * @param string $image
     * @param string $client
     * @param string $export
     * @param string $divers
     * @param string $bA
     */
    public function __construct($origL = null, $origS = null, $fic = null, $exe = null, $exeL = null, $image = null, $client = null, $export = null, $divers = null, $bA = null)
    {
        $this
            ->setOrigL($origL)
            ->setOrigS($origS)
            ->setFic($fic)
            ->setExe($exe)
            ->setExeL($exeL)
            ->setImage($image)
            ->setClient($client)
            ->setExport($export)
            ->setDivers($divers)
            ->setBA($bA);
    }
    /**
     * Get OrigL value
     * @return string|null
     */
    public function getOrigL()
    {
        return $this->OrigL;
    }
    /**
     * Set OrigL value
     * @param string $origL
     * @return \StructType\STRep
     */
    public function setOrigL($origL = null)
    {
        // validation for constraint: string
        if (!is_null($origL) && !is_string($origL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origL, true), gettype($origL)), __LINE__);
        }
        $this->OrigL = $origL;
        return $this;
    }
    /**
     * Get OrigS value
     * @return string|null
     */
    public function getOrigS()
    {
        return $this->OrigS;
    }
    /**
     * Set OrigS value
     * @param string $origS
     * @return \StructType\STRep
     */
    public function setOrigS($origS = null)
    {
        // validation for constraint: string
        if (!is_null($origS) && !is_string($origS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origS, true), gettype($origS)), __LINE__);
        }
        $this->OrigS = $origS;
        return $this;
    }
    /**
     * Get Fic value
     * @return string|null
     */
    public function getFic()
    {
        return $this->Fic;
    }
    /**
     * Set Fic value
     * @param string $fic
     * @return \StructType\STRep
     */
    public function setFic($fic = null)
    {
        // validation for constraint: string
        if (!is_null($fic) && !is_string($fic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fic, true), gettype($fic)), __LINE__);
        }
        $this->Fic = $fic;
        return $this;
    }
    /**
     * Get Exe value
     * @return string|null
     */
    public function getExe()
    {
        return $this->Exe;
    }
    /**
     * Set Exe value
     * @param string $exe
     * @return \StructType\STRep
     */
    public function setExe($exe = null)
    {
        // validation for constraint: string
        if (!is_null($exe) && !is_string($exe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exe, true), gettype($exe)), __LINE__);
        }
        $this->Exe = $exe;
        return $this;
    }
    /**
     * Get ExeL value
     * @return string|null
     */
    public function getExeL()
    {
        return $this->ExeL;
    }
    /**
     * Set ExeL value
     * @param string $exeL
     * @return \StructType\STRep
     */
    public function setExeL($exeL = null)
    {
        // validation for constraint: string
        if (!is_null($exeL) && !is_string($exeL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exeL, true), gettype($exeL)), __LINE__);
        }
        $this->ExeL = $exeL;
        return $this;
    }
    /**
     * Get Image value
     * @return string|null
     */
    public function getImage()
    {
        return $this->Image;
    }
    /**
     * Set Image value
     * @param string $image
     * @return \StructType\STRep
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image, true), gettype($image)), __LINE__);
        }
        $this->Image = $image;
        return $this;
    }
    /**
     * Get Client value
     * @return string|null
     */
    public function getClient()
    {
        return $this->Client;
    }
    /**
     * Set Client value
     * @param string $client
     * @return \StructType\STRep
     */
    public function setClient($client = null)
    {
        // validation for constraint: string
        if (!is_null($client) && !is_string($client)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($client, true), gettype($client)), __LINE__);
        }
        $this->Client = $client;
        return $this;
    }
    /**
     * Get Export value
     * @return string|null
     */
    public function getExport()
    {
        return $this->Export;
    }
    /**
     * Set Export value
     * @param string $export
     * @return \StructType\STRep
     */
    public function setExport($export = null)
    {
        // validation for constraint: string
        if (!is_null($export) && !is_string($export)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($export, true), gettype($export)), __LINE__);
        }
        $this->Export = $export;
        return $this;
    }
    /**
     * Get Divers value
     * @return string|null
     */
    public function getDivers()
    {
        return $this->Divers;
    }
    /**
     * Set Divers value
     * @param string $divers
     * @return \StructType\STRep
     */
    public function setDivers($divers = null)
    {
        // validation for constraint: string
        if (!is_null($divers) && !is_string($divers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($divers, true), gettype($divers)), __LINE__);
        }
        $this->Divers = $divers;
        return $this;
    }
    /**
     * Get BA value
     * @return string|null
     */
    public function getBA()
    {
        return $this->BA;
    }
    /**
     * Set BA value
     * @param string $bA
     * @return \StructType\STRep
     */
    public function setBA($bA = null)
    {
        // validation for constraint: string
        if (!is_null($bA) && !is_string($bA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bA, true), gettype($bA)), __LINE__);
        }
        $this->BA = $bA;
        return $this;
    }
}
