<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Annule ServiceType
 * @subpackage Services
 */
class Annule extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AnnuleCoupon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $sLogin
     * @param string $sMdp
     * @param string $sCode
     * @return string|bool
     */
    public function AnnuleCoupon($sLogin, $sMdp, $sCode)
    {
        try {
            $this->setResult($this->getSoapClient()->AnnuleCoupon($sLogin, $sMdp, $sCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
