<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WsRole StructType
 * @subpackage Structs
 */
class WsRole extends AbstractStructBase
{
    /**
     * The role
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $role;
    /**
     * The isDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isDefault;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The isLoggedInRole
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isLoggedInRole;
    /**
     * Constructor method for WsRole
     * @uses WsRole::setRole()
     * @uses WsRole::setIsDefault()
     * @uses WsRole::setIsInactive()
     * @uses WsRole::setIsLoggedInRole()
     * @param \StructType\RecordRef $role
     * @param bool $isDefault
     * @param bool $isInactive
     * @param bool $isLoggedInRole
     */
    public function __construct(\StructType\RecordRef $role = null, $isDefault = null, $isInactive = null, $isLoggedInRole = null)
    {
        $this
            ->setRole($role)
            ->setIsDefault($isDefault)
            ->setIsInactive($isInactive)
            ->setIsLoggedInRole($isLoggedInRole);
    }
    /**
     * Get role value
     * @return \StructType\RecordRef|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @param \StructType\RecordRef $role
     * @return \StructType\WsRole
     */
    public function setRole(\StructType\RecordRef $role = null)
    {
        $this->role = $role;
        return $this;
    }
    /**
     * Get isDefault value
     * @return bool|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param bool $isDefault
     * @return \StructType\WsRole
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\WsRole
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get isLoggedInRole value
     * @return bool|null
     */
    public function getIsLoggedInRole()
    {
        return $this->isLoggedInRole;
    }
    /**
     * Set isLoggedInRole value
     * @param bool $isLoggedInRole
     * @return \StructType\WsRole
     */
    public function setIsLoggedInRole($isLoggedInRole = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLoggedInRole) && !is_bool($isLoggedInRole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLoggedInRole, true), gettype($isLoggedInRole)), __LINE__);
        }
        $this->isLoggedInRole = $isLoggedInRole;
        return $this;
    }
}
