<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WorkOrderIssueComponent StructType
 * @subpackage Structs
 */
class WorkOrderIssueComponent extends AbstractStructBase
{
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The operationSequenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $operationSequenceNumber;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The componentInventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $componentInventoryDetail;
    /**
     * The lineNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $lineNumber;
    /**
     * Constructor method for WorkOrderIssueComponent
     * @uses WorkOrderIssueComponent::setItem()
     * @uses WorkOrderIssueComponent::setOperationSequenceNumber()
     * @uses WorkOrderIssueComponent::setQuantity()
     * @uses WorkOrderIssueComponent::setComponentInventoryDetail()
     * @uses WorkOrderIssueComponent::setLineNumber()
     * @param \StructType\RecordRef $item
     * @param int $operationSequenceNumber
     * @param float $quantity
     * @param \StructType\InventoryDetail $componentInventoryDetail
     * @param int $lineNumber
     */
    public function __construct(\StructType\RecordRef $item = null, $operationSequenceNumber = null, $quantity = null, \StructType\InventoryDetail $componentInventoryDetail = null, $lineNumber = null)
    {
        $this
            ->setItem($item)
            ->setOperationSequenceNumber($operationSequenceNumber)
            ->setQuantity($quantity)
            ->setComponentInventoryDetail($componentInventoryDetail)
            ->setLineNumber($lineNumber);
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\WorkOrderIssueComponent
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get operationSequenceNumber value
     * @return int|null
     */
    public function getOperationSequenceNumber()
    {
        return $this->operationSequenceNumber;
    }
    /**
     * Set operationSequenceNumber value
     * @param int $operationSequenceNumber
     * @return \StructType\WorkOrderIssueComponent
     */
    public function setOperationSequenceNumber($operationSequenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($operationSequenceNumber) && !(is_int($operationSequenceNumber) || ctype_digit($operationSequenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($operationSequenceNumber, true), gettype($operationSequenceNumber)), __LINE__);
        }
        $this->operationSequenceNumber = $operationSequenceNumber;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\WorkOrderIssueComponent
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get componentInventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getComponentInventoryDetail()
    {
        return $this->componentInventoryDetail;
    }
    /**
     * Set componentInventoryDetail value
     * @param \StructType\InventoryDetail $componentInventoryDetail
     * @return \StructType\WorkOrderIssueComponent
     */
    public function setComponentInventoryDetail(\StructType\InventoryDetail $componentInventoryDetail = null)
    {
        $this->componentInventoryDetail = $componentInventoryDetail;
        return $this;
    }
    /**
     * Get lineNumber value
     * @return int|null
     */
    public function getLineNumber()
    {
        return $this->lineNumber;
    }
    /**
     * Set lineNumber value
     * @param int $lineNumber
     * @return \StructType\WorkOrderIssueComponent
     */
    public function setLineNumber($lineNumber = null)
    {
        // validation for constraint: int
        if (!is_null($lineNumber) && !(is_int($lineNumber) || ctype_digit($lineNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineNumber, true), gettype($lineNumber)), __LINE__);
        }
        $this->lineNumber = $lineNumber;
        return $this;
    }
}
