<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WorkOrderCompletionComponent StructType
 * @subpackage Structs
 */
class WorkOrderCompletionComponent extends AbstractStructBase
{
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The operationSequenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $operationSequenceNumber;
    /**
     * The quantityPer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityPer;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The componentInventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $componentInventoryDetail;
    /**
     * The lineNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $lineNumber;
    /**
     * Constructor method for WorkOrderCompletionComponent
     * @uses WorkOrderCompletionComponent::setItem()
     * @uses WorkOrderCompletionComponent::setOperationSequenceNumber()
     * @uses WorkOrderCompletionComponent::setQuantityPer()
     * @uses WorkOrderCompletionComponent::setQuantity()
     * @uses WorkOrderCompletionComponent::setComponentInventoryDetail()
     * @uses WorkOrderCompletionComponent::setLineNumber()
     * @param \StructType\RecordRef $item
     * @param int $operationSequenceNumber
     * @param float $quantityPer
     * @param float $quantity
     * @param \StructType\InventoryDetail $componentInventoryDetail
     * @param int $lineNumber
     */
    public function __construct(\StructType\RecordRef $item = null, $operationSequenceNumber = null, $quantityPer = null, $quantity = null, \StructType\InventoryDetail $componentInventoryDetail = null, $lineNumber = null)
    {
        $this
            ->setItem($item)
            ->setOperationSequenceNumber($operationSequenceNumber)
            ->setQuantityPer($quantityPer)
            ->setQuantity($quantity)
            ->setComponentInventoryDetail($componentInventoryDetail)
            ->setLineNumber($lineNumber);
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\WorkOrderCompletionComponent
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get operationSequenceNumber value
     * @return int|null
     */
    public function getOperationSequenceNumber()
    {
        return $this->operationSequenceNumber;
    }
    /**
     * Set operationSequenceNumber value
     * @param int $operationSequenceNumber
     * @return \StructType\WorkOrderCompletionComponent
     */
    public function setOperationSequenceNumber($operationSequenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($operationSequenceNumber) && !(is_int($operationSequenceNumber) || ctype_digit($operationSequenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($operationSequenceNumber, true), gettype($operationSequenceNumber)), __LINE__);
        }
        $this->operationSequenceNumber = $operationSequenceNumber;
        return $this;
    }
    /**
     * Get quantityPer value
     * @return float|null
     */
    public function getQuantityPer()
    {
        return $this->quantityPer;
    }
    /**
     * Set quantityPer value
     * @param float $quantityPer
     * @return \StructType\WorkOrderCompletionComponent
     */
    public function setQuantityPer($quantityPer = null)
    {
        // validation for constraint: float
        if (!is_null($quantityPer) && !(is_float($quantityPer) || is_numeric($quantityPer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityPer, true), gettype($quantityPer)), __LINE__);
        }
        $this->quantityPer = $quantityPer;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\WorkOrderCompletionComponent
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get componentInventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getComponentInventoryDetail()
    {
        return $this->componentInventoryDetail;
    }
    /**
     * Set componentInventoryDetail value
     * @param \StructType\InventoryDetail $componentInventoryDetail
     * @return \StructType\WorkOrderCompletionComponent
     */
    public function setComponentInventoryDetail(\StructType\InventoryDetail $componentInventoryDetail = null)
    {
        $this->componentInventoryDetail = $componentInventoryDetail;
        return $this;
    }
    /**
     * Get lineNumber value
     * @return int|null
     */
    public function getLineNumber()
    {
        return $this->lineNumber;
    }
    /**
     * Set lineNumber value
     * @param int $lineNumber
     * @return \StructType\WorkOrderCompletionComponent
     */
    public function setLineNumber($lineNumber = null)
    {
        // validation for constraint: int
        if (!is_null($lineNumber) && !(is_int($lineNumber) || ctype_digit($lineNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineNumber, true), gettype($lineNumber)), __LINE__);
        }
        $this->lineNumber = $lineNumber;
        return $this;
    }
}
