<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WorkOrderCompletion StructType
 * @subpackage Structs
 */
class WorkOrderCompletion extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The scrapQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $scrapQuantity;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The isBackflush
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isBackflush;
    /**
     * The orderQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $orderQuantity;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $total;
    /**
     * The createdFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $createdFrom;
    /**
     * The inventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $inventoryDetail;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $postingPeriod;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The revision
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revision;
    /**
     * The startOperation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $startOperation;
    /**
     * The endOperation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $endOperation;
    /**
     * The completedQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $completedQuantity;
    /**
     * The manufacturingRouting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $manufacturingRouting;
    /**
     * The componentList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\WorkOrderCompletionComponentList
     */
    public $componentList;
    /**
     * The operationList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\WorkOrderCompletionOperationList
     */
    public $operationList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for WorkOrderCompletion
     * @uses WorkOrderCompletion::setCreatedDate()
     * @uses WorkOrderCompletion::setLastModifiedDate()
     * @uses WorkOrderCompletion::setCustomForm()
     * @uses WorkOrderCompletion::setTranId()
     * @uses WorkOrderCompletion::setItem()
     * @uses WorkOrderCompletion::setQuantity()
     * @uses WorkOrderCompletion::setScrapQuantity()
     * @uses WorkOrderCompletion::setUnits()
     * @uses WorkOrderCompletion::setIsBackflush()
     * @uses WorkOrderCompletion::setOrderQuantity()
     * @uses WorkOrderCompletion::setTotal()
     * @uses WorkOrderCompletion::setCreatedFrom()
     * @uses WorkOrderCompletion::setInventoryDetail()
     * @uses WorkOrderCompletion::setTranDate()
     * @uses WorkOrderCompletion::setPostingPeriod()
     * @uses WorkOrderCompletion::setMemo()
     * @uses WorkOrderCompletion::setSubsidiary()
     * @uses WorkOrderCompletion::setDepartment()
     * @uses WorkOrderCompletion::setClass()
     * @uses WorkOrderCompletion::setLocation()
     * @uses WorkOrderCompletion::setRevision()
     * @uses WorkOrderCompletion::setStartOperation()
     * @uses WorkOrderCompletion::setEndOperation()
     * @uses WorkOrderCompletion::setCompletedQuantity()
     * @uses WorkOrderCompletion::setManufacturingRouting()
     * @uses WorkOrderCompletion::setComponentList()
     * @uses WorkOrderCompletion::setOperationList()
     * @uses WorkOrderCompletion::setCustomFieldList()
     * @uses WorkOrderCompletion::setInternalId()
     * @uses WorkOrderCompletion::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $customForm
     * @param string $tranId
     * @param \StructType\RecordRef $item
     * @param float $quantity
     * @param float $scrapQuantity
     * @param \StructType\RecordRef $units
     * @param bool $isBackflush
     * @param float $orderQuantity
     * @param float $total
     * @param \StructType\RecordRef $createdFrom
     * @param \StructType\InventoryDetail $inventoryDetail
     * @param string $tranDate
     * @param \StructType\RecordRef $postingPeriod
     * @param string $memo
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $revision
     * @param \StructType\RecordRef $startOperation
     * @param \StructType\RecordRef $endOperation
     * @param float $completedQuantity
     * @param \StructType\RecordRef $manufacturingRouting
     * @param \StructType\WorkOrderCompletionComponentList $componentList
     * @param \StructType\WorkOrderCompletionOperationList $operationList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $customForm = null, $tranId = null, \StructType\RecordRef $item = null, $quantity = null, $scrapQuantity = null, \StructType\RecordRef $units = null, $isBackflush = null, $orderQuantity = null, $total = null, \StructType\RecordRef $createdFrom = null, \StructType\InventoryDetail $inventoryDetail = null, $tranDate = null, \StructType\RecordRef $postingPeriod = null, $memo = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $revision = null, \StructType\RecordRef $startOperation = null, \StructType\RecordRef $endOperation = null, $completedQuantity = null, \StructType\RecordRef $manufacturingRouting = null, \StructType\WorkOrderCompletionComponentList $componentList = null, \StructType\WorkOrderCompletionOperationList $operationList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setCustomForm($customForm)
            ->setTranId($tranId)
            ->setItem($item)
            ->setQuantity($quantity)
            ->setScrapQuantity($scrapQuantity)
            ->setUnits($units)
            ->setIsBackflush($isBackflush)
            ->setOrderQuantity($orderQuantity)
            ->setTotal($total)
            ->setCreatedFrom($createdFrom)
            ->setInventoryDetail($inventoryDetail)
            ->setTranDate($tranDate)
            ->setPostingPeriod($postingPeriod)
            ->setMemo($memo)
            ->setSubsidiary($subsidiary)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setRevision($revision)
            ->setStartOperation($startOperation)
            ->setEndOperation($endOperation)
            ->setCompletedQuantity($completedQuantity)
            ->setManufacturingRouting($manufacturingRouting)
            ->setComponentList($componentList)
            ->setOperationList($operationList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\WorkOrderCompletion
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\WorkOrderCompletion
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\WorkOrderCompletion
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\WorkOrderCompletion
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\WorkOrderCompletion
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\WorkOrderCompletion
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get scrapQuantity value
     * @return float|null
     */
    public function getScrapQuantity()
    {
        return $this->scrapQuantity;
    }
    /**
     * Set scrapQuantity value
     * @param float $scrapQuantity
     * @return \StructType\WorkOrderCompletion
     */
    public function setScrapQuantity($scrapQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($scrapQuantity) && !(is_float($scrapQuantity) || is_numeric($scrapQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($scrapQuantity, true), gettype($scrapQuantity)), __LINE__);
        }
        $this->scrapQuantity = $scrapQuantity;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\WorkOrderCompletion
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get isBackflush value
     * @return bool|null
     */
    public function getIsBackflush()
    {
        return $this->isBackflush;
    }
    /**
     * Set isBackflush value
     * @param bool $isBackflush
     * @return \StructType\WorkOrderCompletion
     */
    public function setIsBackflush($isBackflush = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBackflush) && !is_bool($isBackflush)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBackflush, true), gettype($isBackflush)), __LINE__);
        }
        $this->isBackflush = $isBackflush;
        return $this;
    }
    /**
     * Get orderQuantity value
     * @return float|null
     */
    public function getOrderQuantity()
    {
        return $this->orderQuantity;
    }
    /**
     * Set orderQuantity value
     * @param float $orderQuantity
     * @return \StructType\WorkOrderCompletion
     */
    public function setOrderQuantity($orderQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($orderQuantity) && !(is_float($orderQuantity) || is_numeric($orderQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderQuantity, true), gettype($orderQuantity)), __LINE__);
        }
        $this->orderQuantity = $orderQuantity;
        return $this;
    }
    /**
     * Get total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param float $total
     * @return \StructType\WorkOrderCompletion
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get createdFrom value
     * @return \StructType\RecordRef|null
     */
    public function getCreatedFrom()
    {
        return $this->createdFrom;
    }
    /**
     * Set createdFrom value
     * @param \StructType\RecordRef $createdFrom
     * @return \StructType\WorkOrderCompletion
     */
    public function setCreatedFrom(\StructType\RecordRef $createdFrom = null)
    {
        $this->createdFrom = $createdFrom;
        return $this;
    }
    /**
     * Get inventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getInventoryDetail()
    {
        return $this->inventoryDetail;
    }
    /**
     * Set inventoryDetail value
     * @param \StructType\InventoryDetail $inventoryDetail
     * @return \StructType\WorkOrderCompletion
     */
    public function setInventoryDetail(\StructType\InventoryDetail $inventoryDetail = null)
    {
        $this->inventoryDetail = $inventoryDetail;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\WorkOrderCompletion
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get postingPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * Set postingPeriod value
     * @param \StructType\RecordRef $postingPeriod
     * @return \StructType\WorkOrderCompletion
     */
    public function setPostingPeriod(\StructType\RecordRef $postingPeriod = null)
    {
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\WorkOrderCompletion
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\WorkOrderCompletion
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\WorkOrderCompletion
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\WorkOrderCompletion
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\WorkOrderCompletion
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get revision value
     * @return \StructType\RecordRef|null
     */
    public function getRevision()
    {
        return $this->revision;
    }
    /**
     * Set revision value
     * @param \StructType\RecordRef $revision
     * @return \StructType\WorkOrderCompletion
     */
    public function setRevision(\StructType\RecordRef $revision = null)
    {
        $this->revision = $revision;
        return $this;
    }
    /**
     * Get startOperation value
     * @return \StructType\RecordRef|null
     */
    public function getStartOperation()
    {
        return $this->startOperation;
    }
    /**
     * Set startOperation value
     * @param \StructType\RecordRef $startOperation
     * @return \StructType\WorkOrderCompletion
     */
    public function setStartOperation(\StructType\RecordRef $startOperation = null)
    {
        $this->startOperation = $startOperation;
        return $this;
    }
    /**
     * Get endOperation value
     * @return \StructType\RecordRef|null
     */
    public function getEndOperation()
    {
        return $this->endOperation;
    }
    /**
     * Set endOperation value
     * @param \StructType\RecordRef $endOperation
     * @return \StructType\WorkOrderCompletion
     */
    public function setEndOperation(\StructType\RecordRef $endOperation = null)
    {
        $this->endOperation = $endOperation;
        return $this;
    }
    /**
     * Get completedQuantity value
     * @return float|null
     */
    public function getCompletedQuantity()
    {
        return $this->completedQuantity;
    }
    /**
     * Set completedQuantity value
     * @param float $completedQuantity
     * @return \StructType\WorkOrderCompletion
     */
    public function setCompletedQuantity($completedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($completedQuantity) && !(is_float($completedQuantity) || is_numeric($completedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($completedQuantity, true), gettype($completedQuantity)), __LINE__);
        }
        $this->completedQuantity = $completedQuantity;
        return $this;
    }
    /**
     * Get manufacturingRouting value
     * @return \StructType\RecordRef|null
     */
    public function getManufacturingRouting()
    {
        return $this->manufacturingRouting;
    }
    /**
     * Set manufacturingRouting value
     * @param \StructType\RecordRef $manufacturingRouting
     * @return \StructType\WorkOrderCompletion
     */
    public function setManufacturingRouting(\StructType\RecordRef $manufacturingRouting = null)
    {
        $this->manufacturingRouting = $manufacturingRouting;
        return $this;
    }
    /**
     * Get componentList value
     * @return \StructType\WorkOrderCompletionComponentList|null
     */
    public function getComponentList()
    {
        return $this->componentList;
    }
    /**
     * Set componentList value
     * @param \StructType\WorkOrderCompletionComponentList $componentList
     * @return \StructType\WorkOrderCompletion
     */
    public function setComponentList(\StructType\WorkOrderCompletionComponentList $componentList = null)
    {
        $this->componentList = $componentList;
        return $this;
    }
    /**
     * Get operationList value
     * @return \StructType\WorkOrderCompletionOperationList|null
     */
    public function getOperationList()
    {
        return $this->operationList;
    }
    /**
     * Set operationList value
     * @param \StructType\WorkOrderCompletionOperationList $operationList
     * @return \StructType\WorkOrderCompletion
     */
    public function setOperationList(\StructType\WorkOrderCompletionOperationList $operationList = null)
    {
        $this->operationList = $operationList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\WorkOrderCompletion
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\WorkOrderCompletion
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\WorkOrderCompletion
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
