<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WorkOrder StructType
 * @subpackage Structs
 */
class WorkOrder extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The manufacturingRouting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $manufacturingRouting;
    /**
     * The autoCalculateLag
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $autoCalculateLag;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The job
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $job;
    /**
     * The assemblyItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $assemblyItem;
    /**
     * The expandAssembly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $expandAssembly;
    /**
     * The isWip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isWip;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The billOfMaterials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billOfMaterials;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The orderStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderStatus;
    /**
     * The firmed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $firmed;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The itemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\WorkOrderItemList
     */
    public $itemList;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The schedulingMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $schedulingMethod;
    /**
     * The salesTeamList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SalesTeamList
     */
    public $salesTeamList;
    /**
     * The partnersList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PartnersList
     */
    public $partnersList;
    /**
     * The createdFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $createdFrom;
    /**
     * The sourceTransactionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sourceTransactionId;
    /**
     * The sourceTransactionLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sourceTransactionLine;
    /**
     * The specialOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $specialOrder;
    /**
     * The buildable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $buildable;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $options;
    /**
     * The built
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $built;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The revision
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revision;
    /**
     * The billOfMaterialsRevision
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billOfMaterialsRevision;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The requestedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $requestedDate;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for WorkOrder
     * @uses WorkOrder::setCreatedDate()
     * @uses WorkOrder::setLastModifiedDate()
     * @uses WorkOrder::setCustomForm()
     * @uses WorkOrder::setManufacturingRouting()
     * @uses WorkOrder::setAutoCalculateLag()
     * @uses WorkOrder::setStatus()
     * @uses WorkOrder::setTranId()
     * @uses WorkOrder::setEntity()
     * @uses WorkOrder::setJob()
     * @uses WorkOrder::setAssemblyItem()
     * @uses WorkOrder::setExpandAssembly()
     * @uses WorkOrder::setIsWip()
     * @uses WorkOrder::setQuantity()
     * @uses WorkOrder::setBillOfMaterials()
     * @uses WorkOrder::setUnits()
     * @uses WorkOrder::setTranDate()
     * @uses WorkOrder::setOrderStatus()
     * @uses WorkOrder::setFirmed()
     * @uses WorkOrder::setMemo()
     * @uses WorkOrder::setDepartment()
     * @uses WorkOrder::setClass()
     * @uses WorkOrder::setItemList()
     * @uses WorkOrder::setLocation()
     * @uses WorkOrder::setSchedulingMethod()
     * @uses WorkOrder::setSalesTeamList()
     * @uses WorkOrder::setPartnersList()
     * @uses WorkOrder::setCreatedFrom()
     * @uses WorkOrder::setSourceTransactionId()
     * @uses WorkOrder::setSourceTransactionLine()
     * @uses WorkOrder::setSpecialOrder()
     * @uses WorkOrder::setBuildable()
     * @uses WorkOrder::setOptions()
     * @uses WorkOrder::setBuilt()
     * @uses WorkOrder::setStartDate()
     * @uses WorkOrder::setEndDate()
     * @uses WorkOrder::setRevision()
     * @uses WorkOrder::setBillOfMaterialsRevision()
     * @uses WorkOrder::setSubsidiary()
     * @uses WorkOrder::setAccountingBookDetailList()
     * @uses WorkOrder::setRequestedDate()
     * @uses WorkOrder::setCustomFieldList()
     * @uses WorkOrder::setInternalId()
     * @uses WorkOrder::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $manufacturingRouting
     * @param bool $autoCalculateLag
     * @param string $status
     * @param string $tranId
     * @param \StructType\RecordRef $entity
     * @param \StructType\RecordRef $job
     * @param \StructType\RecordRef $assemblyItem
     * @param bool $expandAssembly
     * @param bool $isWip
     * @param float $quantity
     * @param \StructType\RecordRef $billOfMaterials
     * @param \StructType\RecordRef $units
     * @param string $tranDate
     * @param string $orderStatus
     * @param bool $firmed
     * @param string $memo
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\WorkOrderItemList $itemList
     * @param \StructType\RecordRef $location
     * @param string $schedulingMethod
     * @param \StructType\SalesTeamList $salesTeamList
     * @param \StructType\PartnersList $partnersList
     * @param \StructType\RecordRef $createdFrom
     * @param string $sourceTransactionId
     * @param int $sourceTransactionLine
     * @param bool $specialOrder
     * @param float $buildable
     * @param \StructType\CustomFieldList $options
     * @param float $built
     * @param string $startDate
     * @param string $endDate
     * @param \StructType\RecordRef $revision
     * @param \StructType\RecordRef $billOfMaterialsRevision
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param string $requestedDate
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $customForm = null, \StructType\RecordRef $manufacturingRouting = null, $autoCalculateLag = null, $status = null, $tranId = null, \StructType\RecordRef $entity = null, \StructType\RecordRef $job = null, \StructType\RecordRef $assemblyItem = null, $expandAssembly = null, $isWip = null, $quantity = null, \StructType\RecordRef $billOfMaterials = null, \StructType\RecordRef $units = null, $tranDate = null, $orderStatus = null, $firmed = null, $memo = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\WorkOrderItemList $itemList = null, \StructType\RecordRef $location = null, $schedulingMethod = null, \StructType\SalesTeamList $salesTeamList = null, \StructType\PartnersList $partnersList = null, \StructType\RecordRef $createdFrom = null, $sourceTransactionId = null, $sourceTransactionLine = null, $specialOrder = null, $buildable = null, \StructType\CustomFieldList $options = null, $built = null, $startDate = null, $endDate = null, \StructType\RecordRef $revision = null, \StructType\RecordRef $billOfMaterialsRevision = null, \StructType\RecordRef $subsidiary = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, $requestedDate = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setCustomForm($customForm)
            ->setManufacturingRouting($manufacturingRouting)
            ->setAutoCalculateLag($autoCalculateLag)
            ->setStatus($status)
            ->setTranId($tranId)
            ->setEntity($entity)
            ->setJob($job)
            ->setAssemblyItem($assemblyItem)
            ->setExpandAssembly($expandAssembly)
            ->setIsWip($isWip)
            ->setQuantity($quantity)
            ->setBillOfMaterials($billOfMaterials)
            ->setUnits($units)
            ->setTranDate($tranDate)
            ->setOrderStatus($orderStatus)
            ->setFirmed($firmed)
            ->setMemo($memo)
            ->setDepartment($department)
            ->setClass($class)
            ->setItemList($itemList)
            ->setLocation($location)
            ->setSchedulingMethod($schedulingMethod)
            ->setSalesTeamList($salesTeamList)
            ->setPartnersList($partnersList)
            ->setCreatedFrom($createdFrom)
            ->setSourceTransactionId($sourceTransactionId)
            ->setSourceTransactionLine($sourceTransactionLine)
            ->setSpecialOrder($specialOrder)
            ->setBuildable($buildable)
            ->setOptions($options)
            ->setBuilt($built)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setRevision($revision)
            ->setBillOfMaterialsRevision($billOfMaterialsRevision)
            ->setSubsidiary($subsidiary)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setRequestedDate($requestedDate)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\WorkOrder
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\WorkOrder
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\WorkOrder
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get manufacturingRouting value
     * @return \StructType\RecordRef|null
     */
    public function getManufacturingRouting()
    {
        return $this->manufacturingRouting;
    }
    /**
     * Set manufacturingRouting value
     * @param \StructType\RecordRef $manufacturingRouting
     * @return \StructType\WorkOrder
     */
    public function setManufacturingRouting(\StructType\RecordRef $manufacturingRouting = null)
    {
        $this->manufacturingRouting = $manufacturingRouting;
        return $this;
    }
    /**
     * Get autoCalculateLag value
     * @return bool|null
     */
    public function getAutoCalculateLag()
    {
        return $this->autoCalculateLag;
    }
    /**
     * Set autoCalculateLag value
     * @param bool $autoCalculateLag
     * @return \StructType\WorkOrder
     */
    public function setAutoCalculateLag($autoCalculateLag = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoCalculateLag) && !is_bool($autoCalculateLag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoCalculateLag, true), gettype($autoCalculateLag)), __LINE__);
        }
        $this->autoCalculateLag = $autoCalculateLag;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\WorkOrder
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\WorkOrder
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\WorkOrder
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get job value
     * @return \StructType\RecordRef|null
     */
    public function getJob()
    {
        return $this->job;
    }
    /**
     * Set job value
     * @param \StructType\RecordRef $job
     * @return \StructType\WorkOrder
     */
    public function setJob(\StructType\RecordRef $job = null)
    {
        $this->job = $job;
        return $this;
    }
    /**
     * Get assemblyItem value
     * @return \StructType\RecordRef|null
     */
    public function getAssemblyItem()
    {
        return $this->assemblyItem;
    }
    /**
     * Set assemblyItem value
     * @param \StructType\RecordRef $assemblyItem
     * @return \StructType\WorkOrder
     */
    public function setAssemblyItem(\StructType\RecordRef $assemblyItem = null)
    {
        $this->assemblyItem = $assemblyItem;
        return $this;
    }
    /**
     * Get expandAssembly value
     * @return bool|null
     */
    public function getExpandAssembly()
    {
        return $this->expandAssembly;
    }
    /**
     * Set expandAssembly value
     * @param bool $expandAssembly
     * @return \StructType\WorkOrder
     */
    public function setExpandAssembly($expandAssembly = null)
    {
        // validation for constraint: boolean
        if (!is_null($expandAssembly) && !is_bool($expandAssembly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expandAssembly, true), gettype($expandAssembly)), __LINE__);
        }
        $this->expandAssembly = $expandAssembly;
        return $this;
    }
    /**
     * Get isWip value
     * @return bool|null
     */
    public function getIsWip()
    {
        return $this->isWip;
    }
    /**
     * Set isWip value
     * @param bool $isWip
     * @return \StructType\WorkOrder
     */
    public function setIsWip($isWip = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWip) && !is_bool($isWip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isWip, true), gettype($isWip)), __LINE__);
        }
        $this->isWip = $isWip;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\WorkOrder
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get billOfMaterials value
     * @return \StructType\RecordRef|null
     */
    public function getBillOfMaterials()
    {
        return $this->billOfMaterials;
    }
    /**
     * Set billOfMaterials value
     * @param \StructType\RecordRef $billOfMaterials
     * @return \StructType\WorkOrder
     */
    public function setBillOfMaterials(\StructType\RecordRef $billOfMaterials = null)
    {
        $this->billOfMaterials = $billOfMaterials;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\WorkOrder
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\WorkOrder
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get orderStatus value
     * @return string|null
     */
    public function getOrderStatus()
    {
        return $this->orderStatus;
    }
    /**
     * Set orderStatus value
     * @uses \EnumType\WorkOrderOrderStatus::valueIsValid()
     * @uses \EnumType\WorkOrderOrderStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderStatus
     * @return \StructType\WorkOrder
     */
    public function setOrderStatus($orderStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WorkOrderOrderStatus::valueIsValid($orderStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WorkOrderOrderStatus', is_array($orderStatus) ? implode(', ', $orderStatus) : var_export($orderStatus, true), implode(', ', \EnumType\WorkOrderOrderStatus::getValidValues())), __LINE__);
        }
        $this->orderStatus = $orderStatus;
        return $this;
    }
    /**
     * Get firmed value
     * @return bool|null
     */
    public function getFirmed()
    {
        return $this->firmed;
    }
    /**
     * Set firmed value
     * @param bool $firmed
     * @return \StructType\WorkOrder
     */
    public function setFirmed($firmed = null)
    {
        // validation for constraint: boolean
        if (!is_null($firmed) && !is_bool($firmed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($firmed, true), gettype($firmed)), __LINE__);
        }
        $this->firmed = $firmed;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\WorkOrder
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\WorkOrder
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\WorkOrder
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get itemList value
     * @return \StructType\WorkOrderItemList|null
     */
    public function getItemList()
    {
        return $this->itemList;
    }
    /**
     * Set itemList value
     * @param \StructType\WorkOrderItemList $itemList
     * @return \StructType\WorkOrder
     */
    public function setItemList(\StructType\WorkOrderItemList $itemList = null)
    {
        $this->itemList = $itemList;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\WorkOrder
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get schedulingMethod value
     * @return string|null
     */
    public function getSchedulingMethod()
    {
        return $this->schedulingMethod;
    }
    /**
     * Set schedulingMethod value
     * @uses \EnumType\WorkOrderSchedulingMethod::valueIsValid()
     * @uses \EnumType\WorkOrderSchedulingMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $schedulingMethod
     * @return \StructType\WorkOrder
     */
    public function setSchedulingMethod($schedulingMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WorkOrderSchedulingMethod::valueIsValid($schedulingMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WorkOrderSchedulingMethod', is_array($schedulingMethod) ? implode(', ', $schedulingMethod) : var_export($schedulingMethod, true), implode(', ', \EnumType\WorkOrderSchedulingMethod::getValidValues())), __LINE__);
        }
        $this->schedulingMethod = $schedulingMethod;
        return $this;
    }
    /**
     * Get salesTeamList value
     * @return \StructType\SalesTeamList|null
     */
    public function getSalesTeamList()
    {
        return $this->salesTeamList;
    }
    /**
     * Set salesTeamList value
     * @param \StructType\SalesTeamList $salesTeamList
     * @return \StructType\WorkOrder
     */
    public function setSalesTeamList(\StructType\SalesTeamList $salesTeamList = null)
    {
        $this->salesTeamList = $salesTeamList;
        return $this;
    }
    /**
     * Get partnersList value
     * @return \StructType\PartnersList|null
     */
    public function getPartnersList()
    {
        return $this->partnersList;
    }
    /**
     * Set partnersList value
     * @param \StructType\PartnersList $partnersList
     * @return \StructType\WorkOrder
     */
    public function setPartnersList(\StructType\PartnersList $partnersList = null)
    {
        $this->partnersList = $partnersList;
        return $this;
    }
    /**
     * Get createdFrom value
     * @return \StructType\RecordRef|null
     */
    public function getCreatedFrom()
    {
        return $this->createdFrom;
    }
    /**
     * Set createdFrom value
     * @param \StructType\RecordRef $createdFrom
     * @return \StructType\WorkOrder
     */
    public function setCreatedFrom(\StructType\RecordRef $createdFrom = null)
    {
        $this->createdFrom = $createdFrom;
        return $this;
    }
    /**
     * Get sourceTransactionId value
     * @return string|null
     */
    public function getSourceTransactionId()
    {
        return $this->sourceTransactionId;
    }
    /**
     * Set sourceTransactionId value
     * @param string $sourceTransactionId
     * @return \StructType\WorkOrder
     */
    public function setSourceTransactionId($sourceTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceTransactionId) && !is_string($sourceTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceTransactionId, true), gettype($sourceTransactionId)), __LINE__);
        }
        $this->sourceTransactionId = $sourceTransactionId;
        return $this;
    }
    /**
     * Get sourceTransactionLine value
     * @return int|null
     */
    public function getSourceTransactionLine()
    {
        return $this->sourceTransactionLine;
    }
    /**
     * Set sourceTransactionLine value
     * @param int $sourceTransactionLine
     * @return \StructType\WorkOrder
     */
    public function setSourceTransactionLine($sourceTransactionLine = null)
    {
        // validation for constraint: int
        if (!is_null($sourceTransactionLine) && !(is_int($sourceTransactionLine) || ctype_digit($sourceTransactionLine))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceTransactionLine, true), gettype($sourceTransactionLine)), __LINE__);
        }
        $this->sourceTransactionLine = $sourceTransactionLine;
        return $this;
    }
    /**
     * Get specialOrder value
     * @return bool|null
     */
    public function getSpecialOrder()
    {
        return $this->specialOrder;
    }
    /**
     * Set specialOrder value
     * @param bool $specialOrder
     * @return \StructType\WorkOrder
     */
    public function setSpecialOrder($specialOrder = null)
    {
        // validation for constraint: boolean
        if (!is_null($specialOrder) && !is_bool($specialOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($specialOrder, true), gettype($specialOrder)), __LINE__);
        }
        $this->specialOrder = $specialOrder;
        return $this;
    }
    /**
     * Get buildable value
     * @return float|null
     */
    public function getBuildable()
    {
        return $this->buildable;
    }
    /**
     * Set buildable value
     * @param float $buildable
     * @return \StructType\WorkOrder
     */
    public function setBuildable($buildable = null)
    {
        // validation for constraint: float
        if (!is_null($buildable) && !(is_float($buildable) || is_numeric($buildable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($buildable, true), gettype($buildable)), __LINE__);
        }
        $this->buildable = $buildable;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\CustomFieldList|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \StructType\CustomFieldList $options
     * @return \StructType\WorkOrder
     */
    public function setOptions(\StructType\CustomFieldList $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get built value
     * @return float|null
     */
    public function getBuilt()
    {
        return $this->built;
    }
    /**
     * Set built value
     * @param float $built
     * @return \StructType\WorkOrder
     */
    public function setBuilt($built = null)
    {
        // validation for constraint: float
        if (!is_null($built) && !(is_float($built) || is_numeric($built))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($built, true), gettype($built)), __LINE__);
        }
        $this->built = $built;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\WorkOrder
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\WorkOrder
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get revision value
     * @return \StructType\RecordRef|null
     */
    public function getRevision()
    {
        return $this->revision;
    }
    /**
     * Set revision value
     * @param \StructType\RecordRef $revision
     * @return \StructType\WorkOrder
     */
    public function setRevision(\StructType\RecordRef $revision = null)
    {
        $this->revision = $revision;
        return $this;
    }
    /**
     * Get billOfMaterialsRevision value
     * @return \StructType\RecordRef|null
     */
    public function getBillOfMaterialsRevision()
    {
        return $this->billOfMaterialsRevision;
    }
    /**
     * Set billOfMaterialsRevision value
     * @param \StructType\RecordRef $billOfMaterialsRevision
     * @return \StructType\WorkOrder
     */
    public function setBillOfMaterialsRevision(\StructType\RecordRef $billOfMaterialsRevision = null)
    {
        $this->billOfMaterialsRevision = $billOfMaterialsRevision;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\WorkOrder
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\WorkOrder
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get requestedDate value
     * @return string|null
     */
    public function getRequestedDate()
    {
        return $this->requestedDate;
    }
    /**
     * Set requestedDate value
     * @param string $requestedDate
     * @return \StructType\WorkOrder
     */
    public function setRequestedDate($requestedDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestedDate) && !is_string($requestedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestedDate, true), gettype($requestedDate)), __LINE__);
        }
        $this->requestedDate = $requestedDate;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\WorkOrder
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\WorkOrder
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\WorkOrder
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
