<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorTaxRegistrationList StructType
 * @subpackage Structs
 */
class VendorTaxRegistrationList extends AbstractStructBase
{
    /**
     * The vendorTaxRegistration
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VendorTaxRegistration[]
     */
    public $vendorTaxRegistration;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for VendorTaxRegistrationList
     * @uses VendorTaxRegistrationList::setVendorTaxRegistration()
     * @uses VendorTaxRegistrationList::setReplaceAll()
     * @param \StructType\VendorTaxRegistration[] $vendorTaxRegistration
     * @param bool $replaceAll
     */
    public function __construct(array $vendorTaxRegistration = array(), $replaceAll = true)
    {
        $this
            ->setVendorTaxRegistration($vendorTaxRegistration)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get vendorTaxRegistration value
     * @return \StructType\VendorTaxRegistration[]|null
     */
    public function getVendorTaxRegistration()
    {
        return $this->vendorTaxRegistration;
    }
    /**
     * This method is responsible for validating the values passed to the setVendorTaxRegistration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendorTaxRegistration method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorTaxRegistrationForArrayConstraintsFromSetVendorTaxRegistration(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vendorTaxRegistrationListVendorTaxRegistrationItem) {
            // validation for constraint: itemType
            if (!$vendorTaxRegistrationListVendorTaxRegistrationItem instanceof \StructType\VendorTaxRegistration) {
                $invalidValues[] = is_object($vendorTaxRegistrationListVendorTaxRegistrationItem) ? get_class($vendorTaxRegistrationListVendorTaxRegistrationItem) : sprintf('%s(%s)', gettype($vendorTaxRegistrationListVendorTaxRegistrationItem), var_export($vendorTaxRegistrationListVendorTaxRegistrationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The vendorTaxRegistration property can only contain items of type \StructType\VendorTaxRegistration, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set vendorTaxRegistration value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorTaxRegistration[] $vendorTaxRegistration
     * @return \StructType\VendorTaxRegistrationList
     */
    public function setVendorTaxRegistration(array $vendorTaxRegistration = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorTaxRegistrationArrayErrorMessage = self::validateVendorTaxRegistrationForArrayConstraintsFromSetVendorTaxRegistration($vendorTaxRegistration))) {
            throw new \InvalidArgumentException($vendorTaxRegistrationArrayErrorMessage, __LINE__);
        }
        $this->vendorTaxRegistration = $vendorTaxRegistration;
        return $this;
    }
    /**
     * Add item to vendorTaxRegistration value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorTaxRegistration $item
     * @return \StructType\VendorTaxRegistrationList
     */
    public function addToVendorTaxRegistration(\StructType\VendorTaxRegistration $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VendorTaxRegistration) {
            throw new \InvalidArgumentException(sprintf('The vendorTaxRegistration property can only contain items of type \StructType\VendorTaxRegistration, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->vendorTaxRegistration[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\VendorTaxRegistrationList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
