<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorSubsidiaryRelationship StructType
 * @subpackage Structs
 */
class VendorSubsidiaryRelationship extends Record
{
    /**
     * The baseCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $baseCurrency;
    /**
     * The creditLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $creditLimit;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The isPrimarySub
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isPrimarySub;
    /**
     * The primaryCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $primaryCurrency;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The taxItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxItem;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for VendorSubsidiaryRelationship
     * @uses VendorSubsidiaryRelationship::setBaseCurrency()
     * @uses VendorSubsidiaryRelationship::setCreditLimit()
     * @uses VendorSubsidiaryRelationship::setEntity()
     * @uses VendorSubsidiaryRelationship::setIsPrimarySub()
     * @uses VendorSubsidiaryRelationship::setPrimaryCurrency()
     * @uses VendorSubsidiaryRelationship::setSubsidiary()
     * @uses VendorSubsidiaryRelationship::setTaxItem()
     * @uses VendorSubsidiaryRelationship::setCustomFieldList()
     * @uses VendorSubsidiaryRelationship::setInternalId()
     * @uses VendorSubsidiaryRelationship::setExternalId()
     * @param \StructType\RecordRef $baseCurrency
     * @param float $creditLimit
     * @param \StructType\RecordRef $entity
     * @param bool $isPrimarySub
     * @param \StructType\RecordRef $primaryCurrency
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $taxItem
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $baseCurrency = null, $creditLimit = null, \StructType\RecordRef $entity = null, $isPrimarySub = null, \StructType\RecordRef $primaryCurrency = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $taxItem = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setBaseCurrency($baseCurrency)
            ->setCreditLimit($creditLimit)
            ->setEntity($entity)
            ->setIsPrimarySub($isPrimarySub)
            ->setPrimaryCurrency($primaryCurrency)
            ->setSubsidiary($subsidiary)
            ->setTaxItem($taxItem)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get baseCurrency value
     * @return \StructType\RecordRef|null
     */
    public function getBaseCurrency()
    {
        return $this->baseCurrency;
    }
    /**
     * Set baseCurrency value
     * @param \StructType\RecordRef $baseCurrency
     * @return \StructType\VendorSubsidiaryRelationship
     */
    public function setBaseCurrency(\StructType\RecordRef $baseCurrency = null)
    {
        $this->baseCurrency = $baseCurrency;
        return $this;
    }
    /**
     * Get creditLimit value
     * @return float|null
     */
    public function getCreditLimit()
    {
        return $this->creditLimit;
    }
    /**
     * Set creditLimit value
     * @param float $creditLimit
     * @return \StructType\VendorSubsidiaryRelationship
     */
    public function setCreditLimit($creditLimit = null)
    {
        // validation for constraint: float
        if (!is_null($creditLimit) && !(is_float($creditLimit) || is_numeric($creditLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($creditLimit, true), gettype($creditLimit)), __LINE__);
        }
        $this->creditLimit = $creditLimit;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\VendorSubsidiaryRelationship
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get isPrimarySub value
     * @return bool|null
     */
    public function getIsPrimarySub()
    {
        return $this->isPrimarySub;
    }
    /**
     * Set isPrimarySub value
     * @param bool $isPrimarySub
     * @return \StructType\VendorSubsidiaryRelationship
     */
    public function setIsPrimarySub($isPrimarySub = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrimarySub) && !is_bool($isPrimarySub)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrimarySub, true), gettype($isPrimarySub)), __LINE__);
        }
        $this->isPrimarySub = $isPrimarySub;
        return $this;
    }
    /**
     * Get primaryCurrency value
     * @return \StructType\RecordRef|null
     */
    public function getPrimaryCurrency()
    {
        return $this->primaryCurrency;
    }
    /**
     * Set primaryCurrency value
     * @param \StructType\RecordRef $primaryCurrency
     * @return \StructType\VendorSubsidiaryRelationship
     */
    public function setPrimaryCurrency(\StructType\RecordRef $primaryCurrency = null)
    {
        $this->primaryCurrency = $primaryCurrency;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\VendorSubsidiaryRelationship
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get taxItem value
     * @return \StructType\RecordRef|null
     */
    public function getTaxItem()
    {
        return $this->taxItem;
    }
    /**
     * Set taxItem value
     * @param \StructType\RecordRef $taxItem
     * @return \StructType\VendorSubsidiaryRelationship
     */
    public function setTaxItem(\StructType\RecordRef $taxItem = null)
    {
        $this->taxItem = $taxItem;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\VendorSubsidiaryRelationship
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\VendorSubsidiaryRelationship
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\VendorSubsidiaryRelationship
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
