<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorReturnAuthorizationExpense StructType
 * @subpackage Structs
 */
class VendorReturnAuthorizationExpense extends AbstractStructBase
{
    /**
     * The orderLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $orderLine;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $category;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The taxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxAmount;
    /**
     * The taxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxCode;
    /**
     * The taxRate1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate1;
    /**
     * The taxRate2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate2;
    /**
     * The tax1Amt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax1Amt;
    /**
     * The grossAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $grossAmt;
    /**
     * The taxDetailsReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxDetailsReference;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customer;
    /**
     * The isBillable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isBillable;
    /**
     * The amortizationSched
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $amortizationSched;
    /**
     * The amortizStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $amortizStartDate;
    /**
     * The amortizationEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $amortizationEndDate;
    /**
     * The amortizationResidual
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $amortizationResidual;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for VendorReturnAuthorizationExpense
     * @uses VendorReturnAuthorizationExpense::setOrderLine()
     * @uses VendorReturnAuthorizationExpense::setLine()
     * @uses VendorReturnAuthorizationExpense::setCategory()
     * @uses VendorReturnAuthorizationExpense::setAccount()
     * @uses VendorReturnAuthorizationExpense::setAmount()
     * @uses VendorReturnAuthorizationExpense::setTaxAmount()
     * @uses VendorReturnAuthorizationExpense::setTaxCode()
     * @uses VendorReturnAuthorizationExpense::setTaxRate1()
     * @uses VendorReturnAuthorizationExpense::setTaxRate2()
     * @uses VendorReturnAuthorizationExpense::setTax1Amt()
     * @uses VendorReturnAuthorizationExpense::setGrossAmt()
     * @uses VendorReturnAuthorizationExpense::setTaxDetailsReference()
     * @uses VendorReturnAuthorizationExpense::setMemo()
     * @uses VendorReturnAuthorizationExpense::setDepartment()
     * @uses VendorReturnAuthorizationExpense::setClass()
     * @uses VendorReturnAuthorizationExpense::setLocation()
     * @uses VendorReturnAuthorizationExpense::setCustomer()
     * @uses VendorReturnAuthorizationExpense::setIsBillable()
     * @uses VendorReturnAuthorizationExpense::setAmortizationSched()
     * @uses VendorReturnAuthorizationExpense::setAmortizStartDate()
     * @uses VendorReturnAuthorizationExpense::setAmortizationEndDate()
     * @uses VendorReturnAuthorizationExpense::setAmortizationResidual()
     * @uses VendorReturnAuthorizationExpense::setCustomFieldList()
     * @param int $orderLine
     * @param int $line
     * @param \StructType\RecordRef $category
     * @param \StructType\RecordRef $account
     * @param float $amount
     * @param float $taxAmount
     * @param \StructType\RecordRef $taxCode
     * @param float $taxRate1
     * @param float $taxRate2
     * @param float $tax1Amt
     * @param float $grossAmt
     * @param string $taxDetailsReference
     * @param string $memo
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $customer
     * @param bool $isBillable
     * @param \StructType\RecordRef $amortizationSched
     * @param string $amortizStartDate
     * @param string $amortizationEndDate
     * @param string $amortizationResidual
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct($orderLine = null, $line = null, \StructType\RecordRef $category = null, \StructType\RecordRef $account = null, $amount = null, $taxAmount = null, \StructType\RecordRef $taxCode = null, $taxRate1 = null, $taxRate2 = null, $tax1Amt = null, $grossAmt = null, $taxDetailsReference = null, $memo = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $customer = null, $isBillable = null, \StructType\RecordRef $amortizationSched = null, $amortizStartDate = null, $amortizationEndDate = null, $amortizationResidual = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setOrderLine($orderLine)
            ->setLine($line)
            ->setCategory($category)
            ->setAccount($account)
            ->setAmount($amount)
            ->setTaxAmount($taxAmount)
            ->setTaxCode($taxCode)
            ->setTaxRate1($taxRate1)
            ->setTaxRate2($taxRate2)
            ->setTax1Amt($tax1Amt)
            ->setGrossAmt($grossAmt)
            ->setTaxDetailsReference($taxDetailsReference)
            ->setMemo($memo)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setCustomer($customer)
            ->setIsBillable($isBillable)
            ->setAmortizationSched($amortizationSched)
            ->setAmortizStartDate($amortizStartDate)
            ->setAmortizationEndDate($amortizationEndDate)
            ->setAmortizationResidual($amortizationResidual)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get orderLine value
     * @return int|null
     */
    public function getOrderLine()
    {
        return $this->orderLine;
    }
    /**
     * Set orderLine value
     * @param int $orderLine
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setOrderLine($orderLine = null)
    {
        // validation for constraint: int
        if (!is_null($orderLine) && !(is_int($orderLine) || ctype_digit($orderLine))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderLine, true), gettype($orderLine)), __LINE__);
        }
        $this->orderLine = $orderLine;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get category value
     * @return \StructType\RecordRef|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param \StructType\RecordRef $category
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setCategory(\StructType\RecordRef $category = null)
    {
        $this->category = $category;
        return $this;
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param float $taxAmount
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get taxCode value
     * @return \StructType\RecordRef|null
     */
    public function getTaxCode()
    {
        return $this->taxCode;
    }
    /**
     * Set taxCode value
     * @param \StructType\RecordRef $taxCode
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setTaxCode(\StructType\RecordRef $taxCode = null)
    {
        $this->taxCode = $taxCode;
        return $this;
    }
    /**
     * Get taxRate1 value
     * @return float|null
     */
    public function getTaxRate1()
    {
        return $this->taxRate1;
    }
    /**
     * Set taxRate1 value
     * @param float $taxRate1
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setTaxRate1($taxRate1 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate1) && !(is_float($taxRate1) || is_numeric($taxRate1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate1, true), gettype($taxRate1)), __LINE__);
        }
        $this->taxRate1 = $taxRate1;
        return $this;
    }
    /**
     * Get taxRate2 value
     * @return float|null
     */
    public function getTaxRate2()
    {
        return $this->taxRate2;
    }
    /**
     * Set taxRate2 value
     * @param float $taxRate2
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setTaxRate2($taxRate2 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate2) && !(is_float($taxRate2) || is_numeric($taxRate2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate2, true), gettype($taxRate2)), __LINE__);
        }
        $this->taxRate2 = $taxRate2;
        return $this;
    }
    /**
     * Get tax1Amt value
     * @return float|null
     */
    public function getTax1Amt()
    {
        return $this->tax1Amt;
    }
    /**
     * Set tax1Amt value
     * @param float $tax1Amt
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setTax1Amt($tax1Amt = null)
    {
        // validation for constraint: float
        if (!is_null($tax1Amt) && !(is_float($tax1Amt) || is_numeric($tax1Amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax1Amt, true), gettype($tax1Amt)), __LINE__);
        }
        $this->tax1Amt = $tax1Amt;
        return $this;
    }
    /**
     * Get grossAmt value
     * @return float|null
     */
    public function getGrossAmt()
    {
        return $this->grossAmt;
    }
    /**
     * Set grossAmt value
     * @param float $grossAmt
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setGrossAmt($grossAmt = null)
    {
        // validation for constraint: float
        if (!is_null($grossAmt) && !(is_float($grossAmt) || is_numeric($grossAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossAmt, true), gettype($grossAmt)), __LINE__);
        }
        $this->grossAmt = $grossAmt;
        return $this;
    }
    /**
     * Get taxDetailsReference value
     * @return string|null
     */
    public function getTaxDetailsReference()
    {
        return $this->taxDetailsReference;
    }
    /**
     * Set taxDetailsReference value
     * @param string $taxDetailsReference
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setTaxDetailsReference($taxDetailsReference = null)
    {
        // validation for constraint: string
        if (!is_null($taxDetailsReference) && !is_string($taxDetailsReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxDetailsReference, true), gettype($taxDetailsReference)), __LINE__);
        }
        $this->taxDetailsReference = $taxDetailsReference;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\RecordRef|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\RecordRef $customer
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setCustomer(\StructType\RecordRef $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get isBillable value
     * @return bool|null
     */
    public function getIsBillable()
    {
        return $this->isBillable;
    }
    /**
     * Set isBillable value
     * @param bool $isBillable
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setIsBillable($isBillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBillable) && !is_bool($isBillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBillable, true), gettype($isBillable)), __LINE__);
        }
        $this->isBillable = $isBillable;
        return $this;
    }
    /**
     * Get amortizationSched value
     * @return \StructType\RecordRef|null
     */
    public function getAmortizationSched()
    {
        return $this->amortizationSched;
    }
    /**
     * Set amortizationSched value
     * @param \StructType\RecordRef $amortizationSched
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setAmortizationSched(\StructType\RecordRef $amortizationSched = null)
    {
        $this->amortizationSched = $amortizationSched;
        return $this;
    }
    /**
     * Get amortizStartDate value
     * @return string|null
     */
    public function getAmortizStartDate()
    {
        return $this->amortizStartDate;
    }
    /**
     * Set amortizStartDate value
     * @param string $amortizStartDate
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setAmortizStartDate($amortizStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($amortizStartDate) && !is_string($amortizStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amortizStartDate, true), gettype($amortizStartDate)), __LINE__);
        }
        $this->amortizStartDate = $amortizStartDate;
        return $this;
    }
    /**
     * Get amortizationEndDate value
     * @return string|null
     */
    public function getAmortizationEndDate()
    {
        return $this->amortizationEndDate;
    }
    /**
     * Set amortizationEndDate value
     * @param string $amortizationEndDate
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setAmortizationEndDate($amortizationEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($amortizationEndDate) && !is_string($amortizationEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amortizationEndDate, true), gettype($amortizationEndDate)), __LINE__);
        }
        $this->amortizationEndDate = $amortizationEndDate;
        return $this;
    }
    /**
     * Get amortizationResidual value
     * @return string|null
     */
    public function getAmortizationResidual()
    {
        return $this->amortizationResidual;
    }
    /**
     * Set amortizationResidual value
     * @param string $amortizationResidual
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setAmortizationResidual($amortizationResidual = null)
    {
        // validation for constraint: string
        if (!is_null($amortizationResidual) && !is_string($amortizationResidual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amortizationResidual, true), gettype($amortizationResidual)), __LINE__);
        }
        $this->amortizationResidual = $amortizationResidual;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\VendorReturnAuthorizationExpense
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
