<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorReturnAuthorization StructType
 * @subpackage Structs
 */
class VendorReturnAuthorization extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The nexus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nexus;
    /**
     * The subsidiaryTaxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiaryTaxRegNum;
    /**
     * The taxRegOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxRegOverride;
    /**
     * The taxDetailsOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxDetailsOverride;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The createdFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $createdFrom;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The orderStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderStatus;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The userTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $userTotal;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The currencyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currencyName;
    /**
     * The billingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $billingAddress;
    /**
     * The billAddressList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billAddressList;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The entityTaxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entityTaxRegNum;
    /**
     * The taxPointDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxPointDate;
    /**
     * The userTaxTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $userTaxTotal;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The intercoTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $intercoTransaction;
    /**
     * The intercoStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $intercoStatus;
    /**
     * The expenseList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorReturnAuthorizationExpenseList
     */
    public $expenseList;
    /**
     * The itemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorReturnAuthorizationItemList
     */
    public $itemList;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The taxDetailsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxDetailsList
     */
    public $taxDetailsList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for VendorReturnAuthorization
     * @uses VendorReturnAuthorization::setCreatedDate()
     * @uses VendorReturnAuthorization::setLastModifiedDate()
     * @uses VendorReturnAuthorization::setNexus()
     * @uses VendorReturnAuthorization::setSubsidiaryTaxRegNum()
     * @uses VendorReturnAuthorization::setTaxRegOverride()
     * @uses VendorReturnAuthorization::setTaxDetailsOverride()
     * @uses VendorReturnAuthorization::setCustomForm()
     * @uses VendorReturnAuthorization::setTranId()
     * @uses VendorReturnAuthorization::setCreatedFrom()
     * @uses VendorReturnAuthorization::setEntity()
     * @uses VendorReturnAuthorization::setOrderStatus()
     * @uses VendorReturnAuthorization::setTranDate()
     * @uses VendorReturnAuthorization::setUserTotal()
     * @uses VendorReturnAuthorization::setCurrency()
     * @uses VendorReturnAuthorization::setCurrencyName()
     * @uses VendorReturnAuthorization::setBillingAddress()
     * @uses VendorReturnAuthorization::setBillAddressList()
     * @uses VendorReturnAuthorization::setMemo()
     * @uses VendorReturnAuthorization::setExchangeRate()
     * @uses VendorReturnAuthorization::setEntityTaxRegNum()
     * @uses VendorReturnAuthorization::setTaxPointDate()
     * @uses VendorReturnAuthorization::setUserTaxTotal()
     * @uses VendorReturnAuthorization::setDepartment()
     * @uses VendorReturnAuthorization::setClass()
     * @uses VendorReturnAuthorization::setLocation()
     * @uses VendorReturnAuthorization::setSubsidiary()
     * @uses VendorReturnAuthorization::setIntercoTransaction()
     * @uses VendorReturnAuthorization::setIntercoStatus()
     * @uses VendorReturnAuthorization::setExpenseList()
     * @uses VendorReturnAuthorization::setItemList()
     * @uses VendorReturnAuthorization::setAccountingBookDetailList()
     * @uses VendorReturnAuthorization::setTaxDetailsList()
     * @uses VendorReturnAuthorization::setCustomFieldList()
     * @uses VendorReturnAuthorization::setInternalId()
     * @uses VendorReturnAuthorization::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $nexus
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @param bool $taxRegOverride
     * @param bool $taxDetailsOverride
     * @param \StructType\RecordRef $customForm
     * @param string $tranId
     * @param \StructType\RecordRef $createdFrom
     * @param \StructType\RecordRef $entity
     * @param string $orderStatus
     * @param string $tranDate
     * @param float $userTotal
     * @param \StructType\RecordRef $currency
     * @param string $currencyName
     * @param \StructType\Address $billingAddress
     * @param \StructType\RecordRef $billAddressList
     * @param string $memo
     * @param float $exchangeRate
     * @param \StructType\RecordRef $entityTaxRegNum
     * @param string $taxPointDate
     * @param float $userTaxTotal
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $intercoTransaction
     * @param string $intercoStatus
     * @param \StructType\VendorReturnAuthorizationExpenseList $expenseList
     * @param \StructType\VendorReturnAuthorizationItemList $itemList
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $nexus = null, \StructType\RecordRef $subsidiaryTaxRegNum = null, $taxRegOverride = null, $taxDetailsOverride = null, \StructType\RecordRef $customForm = null, $tranId = null, \StructType\RecordRef $createdFrom = null, \StructType\RecordRef $entity = null, $orderStatus = null, $tranDate = null, $userTotal = null, \StructType\RecordRef $currency = null, $currencyName = null, \StructType\Address $billingAddress = null, \StructType\RecordRef $billAddressList = null, $memo = null, $exchangeRate = null, \StructType\RecordRef $entityTaxRegNum = null, $taxPointDate = null, $userTaxTotal = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $intercoTransaction = null, $intercoStatus = null, \StructType\VendorReturnAuthorizationExpenseList $expenseList = null, \StructType\VendorReturnAuthorizationItemList $itemList = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, \StructType\TaxDetailsList $taxDetailsList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setNexus($nexus)
            ->setSubsidiaryTaxRegNum($subsidiaryTaxRegNum)
            ->setTaxRegOverride($taxRegOverride)
            ->setTaxDetailsOverride($taxDetailsOverride)
            ->setCustomForm($customForm)
            ->setTranId($tranId)
            ->setCreatedFrom($createdFrom)
            ->setEntity($entity)
            ->setOrderStatus($orderStatus)
            ->setTranDate($tranDate)
            ->setUserTotal($userTotal)
            ->setCurrency($currency)
            ->setCurrencyName($currencyName)
            ->setBillingAddress($billingAddress)
            ->setBillAddressList($billAddressList)
            ->setMemo($memo)
            ->setExchangeRate($exchangeRate)
            ->setEntityTaxRegNum($entityTaxRegNum)
            ->setTaxPointDate($taxPointDate)
            ->setUserTaxTotal($userTaxTotal)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setSubsidiary($subsidiary)
            ->setIntercoTransaction($intercoTransaction)
            ->setIntercoStatus($intercoStatus)
            ->setExpenseList($expenseList)
            ->setItemList($itemList)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setTaxDetailsList($taxDetailsList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\VendorReturnAuthorization
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\VendorReturnAuthorization
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get nexus value
     * @return \StructType\RecordRef|null
     */
    public function getNexus()
    {
        return $this->nexus;
    }
    /**
     * Set nexus value
     * @param \StructType\RecordRef $nexus
     * @return \StructType\VendorReturnAuthorization
     */
    public function setNexus(\StructType\RecordRef $nexus = null)
    {
        $this->nexus = $nexus;
        return $this;
    }
    /**
     * Get subsidiaryTaxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiaryTaxRegNum()
    {
        return $this->subsidiaryTaxRegNum;
    }
    /**
     * Set subsidiaryTaxRegNum value
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @return \StructType\VendorReturnAuthorization
     */
    public function setSubsidiaryTaxRegNum(\StructType\RecordRef $subsidiaryTaxRegNum = null)
    {
        $this->subsidiaryTaxRegNum = $subsidiaryTaxRegNum;
        return $this;
    }
    /**
     * Get taxRegOverride value
     * @return bool|null
     */
    public function getTaxRegOverride()
    {
        return $this->taxRegOverride;
    }
    /**
     * Set taxRegOverride value
     * @param bool $taxRegOverride
     * @return \StructType\VendorReturnAuthorization
     */
    public function setTaxRegOverride($taxRegOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxRegOverride) && !is_bool($taxRegOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxRegOverride, true), gettype($taxRegOverride)), __LINE__);
        }
        $this->taxRegOverride = $taxRegOverride;
        return $this;
    }
    /**
     * Get taxDetailsOverride value
     * @return bool|null
     */
    public function getTaxDetailsOverride()
    {
        return $this->taxDetailsOverride;
    }
    /**
     * Set taxDetailsOverride value
     * @param bool $taxDetailsOverride
     * @return \StructType\VendorReturnAuthorization
     */
    public function setTaxDetailsOverride($taxDetailsOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxDetailsOverride) && !is_bool($taxDetailsOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxDetailsOverride, true), gettype($taxDetailsOverride)), __LINE__);
        }
        $this->taxDetailsOverride = $taxDetailsOverride;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\VendorReturnAuthorization
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\VendorReturnAuthorization
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get createdFrom value
     * @return \StructType\RecordRef|null
     */
    public function getCreatedFrom()
    {
        return $this->createdFrom;
    }
    /**
     * Set createdFrom value
     * @param \StructType\RecordRef $createdFrom
     * @return \StructType\VendorReturnAuthorization
     */
    public function setCreatedFrom(\StructType\RecordRef $createdFrom = null)
    {
        $this->createdFrom = $createdFrom;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\VendorReturnAuthorization
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get orderStatus value
     * @return string|null
     */
    public function getOrderStatus()
    {
        return $this->orderStatus;
    }
    /**
     * Set orderStatus value
     * @uses \EnumType\VendorReturnAuthorizationOrderStatus::valueIsValid()
     * @uses \EnumType\VendorReturnAuthorizationOrderStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderStatus
     * @return \StructType\VendorReturnAuthorization
     */
    public function setOrderStatus($orderStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VendorReturnAuthorizationOrderStatus::valueIsValid($orderStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VendorReturnAuthorizationOrderStatus', is_array($orderStatus) ? implode(', ', $orderStatus) : var_export($orderStatus, true), implode(', ', \EnumType\VendorReturnAuthorizationOrderStatus::getValidValues())), __LINE__);
        }
        $this->orderStatus = $orderStatus;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\VendorReturnAuthorization
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get userTotal value
     * @return float|null
     */
    public function getUserTotal()
    {
        return $this->userTotal;
    }
    /**
     * Set userTotal value
     * @param float $userTotal
     * @return \StructType\VendorReturnAuthorization
     */
    public function setUserTotal($userTotal = null)
    {
        // validation for constraint: float
        if (!is_null($userTotal) && !(is_float($userTotal) || is_numeric($userTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($userTotal, true), gettype($userTotal)), __LINE__);
        }
        $this->userTotal = $userTotal;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\VendorReturnAuthorization
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get currencyName value
     * @return string|null
     */
    public function getCurrencyName()
    {
        return $this->currencyName;
    }
    /**
     * Set currencyName value
     * @param string $currencyName
     * @return \StructType\VendorReturnAuthorization
     */
    public function setCurrencyName($currencyName = null)
    {
        // validation for constraint: string
        if (!is_null($currencyName) && !is_string($currencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyName, true), gettype($currencyName)), __LINE__);
        }
        $this->currencyName = $currencyName;
        return $this;
    }
    /**
     * Get billingAddress value
     * @return \StructType\Address|null
     */
    public function getBillingAddress()
    {
        return $this->billingAddress;
    }
    /**
     * Set billingAddress value
     * @param \StructType\Address $billingAddress
     * @return \StructType\VendorReturnAuthorization
     */
    public function setBillingAddress(\StructType\Address $billingAddress = null)
    {
        $this->billingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get billAddressList value
     * @return \StructType\RecordRef|null
     */
    public function getBillAddressList()
    {
        return $this->billAddressList;
    }
    /**
     * Set billAddressList value
     * @param \StructType\RecordRef $billAddressList
     * @return \StructType\VendorReturnAuthorization
     */
    public function setBillAddressList(\StructType\RecordRef $billAddressList = null)
    {
        $this->billAddressList = $billAddressList;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\VendorReturnAuthorization
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\VendorReturnAuthorization
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get entityTaxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getEntityTaxRegNum()
    {
        return $this->entityTaxRegNum;
    }
    /**
     * Set entityTaxRegNum value
     * @param \StructType\RecordRef $entityTaxRegNum
     * @return \StructType\VendorReturnAuthorization
     */
    public function setEntityTaxRegNum(\StructType\RecordRef $entityTaxRegNum = null)
    {
        $this->entityTaxRegNum = $entityTaxRegNum;
        return $this;
    }
    /**
     * Get taxPointDate value
     * @return string|null
     */
    public function getTaxPointDate()
    {
        return $this->taxPointDate;
    }
    /**
     * Set taxPointDate value
     * @param string $taxPointDate
     * @return \StructType\VendorReturnAuthorization
     */
    public function setTaxPointDate($taxPointDate = null)
    {
        // validation for constraint: string
        if (!is_null($taxPointDate) && !is_string($taxPointDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxPointDate, true), gettype($taxPointDate)), __LINE__);
        }
        $this->taxPointDate = $taxPointDate;
        return $this;
    }
    /**
     * Get userTaxTotal value
     * @return float|null
     */
    public function getUserTaxTotal()
    {
        return $this->userTaxTotal;
    }
    /**
     * Set userTaxTotal value
     * @param float $userTaxTotal
     * @return \StructType\VendorReturnAuthorization
     */
    public function setUserTaxTotal($userTaxTotal = null)
    {
        // validation for constraint: float
        if (!is_null($userTaxTotal) && !(is_float($userTaxTotal) || is_numeric($userTaxTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($userTaxTotal, true), gettype($userTaxTotal)), __LINE__);
        }
        $this->userTaxTotal = $userTaxTotal;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\VendorReturnAuthorization
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\VendorReturnAuthorization
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\VendorReturnAuthorization
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\VendorReturnAuthorization
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get intercoTransaction value
     * @return \StructType\RecordRef|null
     */
    public function getIntercoTransaction()
    {
        return $this->intercoTransaction;
    }
    /**
     * Set intercoTransaction value
     * @param \StructType\RecordRef $intercoTransaction
     * @return \StructType\VendorReturnAuthorization
     */
    public function setIntercoTransaction(\StructType\RecordRef $intercoTransaction = null)
    {
        $this->intercoTransaction = $intercoTransaction;
        return $this;
    }
    /**
     * Get intercoStatus value
     * @return string|null
     */
    public function getIntercoStatus()
    {
        return $this->intercoStatus;
    }
    /**
     * Set intercoStatus value
     * @uses \EnumType\IntercoStatus::valueIsValid()
     * @uses \EnumType\IntercoStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $intercoStatus
     * @return \StructType\VendorReturnAuthorization
     */
    public function setIntercoStatus($intercoStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IntercoStatus::valueIsValid($intercoStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IntercoStatus', is_array($intercoStatus) ? implode(', ', $intercoStatus) : var_export($intercoStatus, true), implode(', ', \EnumType\IntercoStatus::getValidValues())), __LINE__);
        }
        $this->intercoStatus = $intercoStatus;
        return $this;
    }
    /**
     * Get expenseList value
     * @return \StructType\VendorReturnAuthorizationExpenseList|null
     */
    public function getExpenseList()
    {
        return $this->expenseList;
    }
    /**
     * Set expenseList value
     * @param \StructType\VendorReturnAuthorizationExpenseList $expenseList
     * @return \StructType\VendorReturnAuthorization
     */
    public function setExpenseList(\StructType\VendorReturnAuthorizationExpenseList $expenseList = null)
    {
        $this->expenseList = $expenseList;
        return $this;
    }
    /**
     * Get itemList value
     * @return \StructType\VendorReturnAuthorizationItemList|null
     */
    public function getItemList()
    {
        return $this->itemList;
    }
    /**
     * Set itemList value
     * @param \StructType\VendorReturnAuthorizationItemList $itemList
     * @return \StructType\VendorReturnAuthorization
     */
    public function setItemList(\StructType\VendorReturnAuthorizationItemList $itemList = null)
    {
        $this->itemList = $itemList;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\VendorReturnAuthorization
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get taxDetailsList value
     * @return \StructType\TaxDetailsList|null
     */
    public function getTaxDetailsList()
    {
        return $this->taxDetailsList;
    }
    /**
     * Set taxDetailsList value
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @return \StructType\VendorReturnAuthorization
     */
    public function setTaxDetailsList(\StructType\TaxDetailsList $taxDetailsList = null)
    {
        $this->taxDetailsList = $taxDetailsList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\VendorReturnAuthorization
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\VendorReturnAuthorization
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\VendorReturnAuthorization
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
