<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorPayment StructType
 * @subpackage Structs
 */
class VendorPayment extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $balance;
    /**
     * The apAcct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $apAcct;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The voidJournal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $voidJournal;
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $postingPeriod;
    /**
     * The currencyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currencyName;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The toAch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toAch;
    /**
     * The toBePrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toBePrinted;
    /**
     * The printVoucher
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $printVoucher;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $total;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The transactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transactionNumber;
    /**
     * The applyList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorPaymentApplyList
     */
    public $applyList;
    /**
     * The creditList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorPaymentCreditList
     */
    public $creditList;
    /**
     * The billPay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $billPay;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The availableBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $availableBalance;
    /**
     * The isInTransitPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInTransitPayment;
    /**
     * The approvalStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $approvalStatus;
    /**
     * The nextApprover
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nextApprover;
    /**
     * The payeeAddressList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $payeeAddressList;
    /**
     * The payeeAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $payeeAddress;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for VendorPayment
     * @uses VendorPayment::setCreatedDate()
     * @uses VendorPayment::setLastModifiedDate()
     * @uses VendorPayment::setCustomForm()
     * @uses VendorPayment::setAccount()
     * @uses VendorPayment::setBalance()
     * @uses VendorPayment::setApAcct()
     * @uses VendorPayment::setEntity()
     * @uses VendorPayment::setTranDate()
     * @uses VendorPayment::setVoidJournal()
     * @uses VendorPayment::setPostingPeriod()
     * @uses VendorPayment::setCurrencyName()
     * @uses VendorPayment::setExchangeRate()
     * @uses VendorPayment::setToAch()
     * @uses VendorPayment::setToBePrinted()
     * @uses VendorPayment::setPrintVoucher()
     * @uses VendorPayment::setTranId()
     * @uses VendorPayment::setTotal()
     * @uses VendorPayment::setCurrency()
     * @uses VendorPayment::setDepartment()
     * @uses VendorPayment::setMemo()
     * @uses VendorPayment::setSubsidiary()
     * @uses VendorPayment::setClass()
     * @uses VendorPayment::setLocation()
     * @uses VendorPayment::setStatus()
     * @uses VendorPayment::setTransactionNumber()
     * @uses VendorPayment::setApplyList()
     * @uses VendorPayment::setCreditList()
     * @uses VendorPayment::setBillPay()
     * @uses VendorPayment::setAccountingBookDetailList()
     * @uses VendorPayment::setAvailableBalance()
     * @uses VendorPayment::setIsInTransitPayment()
     * @uses VendorPayment::setApprovalStatus()
     * @uses VendorPayment::setNextApprover()
     * @uses VendorPayment::setPayeeAddressList()
     * @uses VendorPayment::setPayeeAddress()
     * @uses VendorPayment::setCustomFieldList()
     * @uses VendorPayment::setInternalId()
     * @uses VendorPayment::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $account
     * @param float $balance
     * @param \StructType\RecordRef $apAcct
     * @param \StructType\RecordRef $entity
     * @param string $tranDate
     * @param \StructType\RecordRef $voidJournal
     * @param \StructType\RecordRef $postingPeriod
     * @param string $currencyName
     * @param float $exchangeRate
     * @param bool $toAch
     * @param bool $toBePrinted
     * @param bool $printVoucher
     * @param string $tranId
     * @param float $total
     * @param \StructType\RecordRef $currency
     * @param \StructType\RecordRef $department
     * @param string $memo
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param string $status
     * @param string $transactionNumber
     * @param \StructType\VendorPaymentApplyList $applyList
     * @param \StructType\VendorPaymentCreditList $creditList
     * @param bool $billPay
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param float $availableBalance
     * @param bool $isInTransitPayment
     * @param \StructType\RecordRef $approvalStatus
     * @param \StructType\RecordRef $nextApprover
     * @param \StructType\RecordRef $payeeAddressList
     * @param \StructType\Address $payeeAddress
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $customForm = null, \StructType\RecordRef $account = null, $balance = null, \StructType\RecordRef $apAcct = null, \StructType\RecordRef $entity = null, $tranDate = null, \StructType\RecordRef $voidJournal = null, \StructType\RecordRef $postingPeriod = null, $currencyName = null, $exchangeRate = null, $toAch = null, $toBePrinted = null, $printVoucher = null, $tranId = null, $total = null, \StructType\RecordRef $currency = null, \StructType\RecordRef $department = null, $memo = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, $status = null, $transactionNumber = null, \StructType\VendorPaymentApplyList $applyList = null, \StructType\VendorPaymentCreditList $creditList = null, $billPay = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, $availableBalance = null, $isInTransitPayment = null, \StructType\RecordRef $approvalStatus = null, \StructType\RecordRef $nextApprover = null, \StructType\RecordRef $payeeAddressList = null, \StructType\Address $payeeAddress = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setCustomForm($customForm)
            ->setAccount($account)
            ->setBalance($balance)
            ->setApAcct($apAcct)
            ->setEntity($entity)
            ->setTranDate($tranDate)
            ->setVoidJournal($voidJournal)
            ->setPostingPeriod($postingPeriod)
            ->setCurrencyName($currencyName)
            ->setExchangeRate($exchangeRate)
            ->setToAch($toAch)
            ->setToBePrinted($toBePrinted)
            ->setPrintVoucher($printVoucher)
            ->setTranId($tranId)
            ->setTotal($total)
            ->setCurrency($currency)
            ->setDepartment($department)
            ->setMemo($memo)
            ->setSubsidiary($subsidiary)
            ->setClass($class)
            ->setLocation($location)
            ->setStatus($status)
            ->setTransactionNumber($transactionNumber)
            ->setApplyList($applyList)
            ->setCreditList($creditList)
            ->setBillPay($billPay)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setAvailableBalance($availableBalance)
            ->setIsInTransitPayment($isInTransitPayment)
            ->setApprovalStatus($approvalStatus)
            ->setNextApprover($nextApprover)
            ->setPayeeAddressList($payeeAddressList)
            ->setPayeeAddress($payeeAddress)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\VendorPayment
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\VendorPayment
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\VendorPayment
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\VendorPayment
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * Set balance value
     * @param float $balance
     * @return \StructType\VendorPayment
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        $this->balance = $balance;
        return $this;
    }
    /**
     * Get apAcct value
     * @return \StructType\RecordRef|null
     */
    public function getApAcct()
    {
        return $this->apAcct;
    }
    /**
     * Set apAcct value
     * @param \StructType\RecordRef $apAcct
     * @return \StructType\VendorPayment
     */
    public function setApAcct(\StructType\RecordRef $apAcct = null)
    {
        $this->apAcct = $apAcct;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\VendorPayment
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\VendorPayment
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get voidJournal value
     * @return \StructType\RecordRef|null
     */
    public function getVoidJournal()
    {
        return $this->voidJournal;
    }
    /**
     * Set voidJournal value
     * @param \StructType\RecordRef $voidJournal
     * @return \StructType\VendorPayment
     */
    public function setVoidJournal(\StructType\RecordRef $voidJournal = null)
    {
        $this->voidJournal = $voidJournal;
        return $this;
    }
    /**
     * Get postingPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * Set postingPeriod value
     * @param \StructType\RecordRef $postingPeriod
     * @return \StructType\VendorPayment
     */
    public function setPostingPeriod(\StructType\RecordRef $postingPeriod = null)
    {
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Get currencyName value
     * @return string|null
     */
    public function getCurrencyName()
    {
        return $this->currencyName;
    }
    /**
     * Set currencyName value
     * @param string $currencyName
     * @return \StructType\VendorPayment
     */
    public function setCurrencyName($currencyName = null)
    {
        // validation for constraint: string
        if (!is_null($currencyName) && !is_string($currencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyName, true), gettype($currencyName)), __LINE__);
        }
        $this->currencyName = $currencyName;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\VendorPayment
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get toAch value
     * @return bool|null
     */
    public function getToAch()
    {
        return $this->toAch;
    }
    /**
     * Set toAch value
     * @param bool $toAch
     * @return \StructType\VendorPayment
     */
    public function setToAch($toAch = null)
    {
        // validation for constraint: boolean
        if (!is_null($toAch) && !is_bool($toAch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toAch, true), gettype($toAch)), __LINE__);
        }
        $this->toAch = $toAch;
        return $this;
    }
    /**
     * Get toBePrinted value
     * @return bool|null
     */
    public function getToBePrinted()
    {
        return $this->toBePrinted;
    }
    /**
     * Set toBePrinted value
     * @param bool $toBePrinted
     * @return \StructType\VendorPayment
     */
    public function setToBePrinted($toBePrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($toBePrinted) && !is_bool($toBePrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toBePrinted, true), gettype($toBePrinted)), __LINE__);
        }
        $this->toBePrinted = $toBePrinted;
        return $this;
    }
    /**
     * Get printVoucher value
     * @return bool|null
     */
    public function getPrintVoucher()
    {
        return $this->printVoucher;
    }
    /**
     * Set printVoucher value
     * @param bool $printVoucher
     * @return \StructType\VendorPayment
     */
    public function setPrintVoucher($printVoucher = null)
    {
        // validation for constraint: boolean
        if (!is_null($printVoucher) && !is_bool($printVoucher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printVoucher, true), gettype($printVoucher)), __LINE__);
        }
        $this->printVoucher = $printVoucher;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\VendorPayment
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param float $total
     * @return \StructType\VendorPayment
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\VendorPayment
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\VendorPayment
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\VendorPayment
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\VendorPayment
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\VendorPayment
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\VendorPayment
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\VendorPayment
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get transactionNumber value
     * @return string|null
     */
    public function getTransactionNumber()
    {
        return $this->transactionNumber;
    }
    /**
     * Set transactionNumber value
     * @param string $transactionNumber
     * @return \StructType\VendorPayment
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNumber) && !is_string($transactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        $this->transactionNumber = $transactionNumber;
        return $this;
    }
    /**
     * Get applyList value
     * @return \StructType\VendorPaymentApplyList|null
     */
    public function getApplyList()
    {
        return $this->applyList;
    }
    /**
     * Set applyList value
     * @param \StructType\VendorPaymentApplyList $applyList
     * @return \StructType\VendorPayment
     */
    public function setApplyList(\StructType\VendorPaymentApplyList $applyList = null)
    {
        $this->applyList = $applyList;
        return $this;
    }
    /**
     * Get creditList value
     * @return \StructType\VendorPaymentCreditList|null
     */
    public function getCreditList()
    {
        return $this->creditList;
    }
    /**
     * Set creditList value
     * @param \StructType\VendorPaymentCreditList $creditList
     * @return \StructType\VendorPayment
     */
    public function setCreditList(\StructType\VendorPaymentCreditList $creditList = null)
    {
        $this->creditList = $creditList;
        return $this;
    }
    /**
     * Get billPay value
     * @return bool|null
     */
    public function getBillPay()
    {
        return $this->billPay;
    }
    /**
     * Set billPay value
     * @param bool $billPay
     * @return \StructType\VendorPayment
     */
    public function setBillPay($billPay = null)
    {
        // validation for constraint: boolean
        if (!is_null($billPay) && !is_bool($billPay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($billPay, true), gettype($billPay)), __LINE__);
        }
        $this->billPay = $billPay;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\VendorPayment
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get availableBalance value
     * @return float|null
     */
    public function getAvailableBalance()
    {
        return $this->availableBalance;
    }
    /**
     * Set availableBalance value
     * @param float $availableBalance
     * @return \StructType\VendorPayment
     */
    public function setAvailableBalance($availableBalance = null)
    {
        // validation for constraint: float
        if (!is_null($availableBalance) && !(is_float($availableBalance) || is_numeric($availableBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($availableBalance, true), gettype($availableBalance)), __LINE__);
        }
        $this->availableBalance = $availableBalance;
        return $this;
    }
    /**
     * Get isInTransitPayment value
     * @return bool|null
     */
    public function getIsInTransitPayment()
    {
        return $this->isInTransitPayment;
    }
    /**
     * Set isInTransitPayment value
     * @param bool $isInTransitPayment
     * @return \StructType\VendorPayment
     */
    public function setIsInTransitPayment($isInTransitPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInTransitPayment) && !is_bool($isInTransitPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInTransitPayment, true), gettype($isInTransitPayment)), __LINE__);
        }
        $this->isInTransitPayment = $isInTransitPayment;
        return $this;
    }
    /**
     * Get approvalStatus value
     * @return \StructType\RecordRef|null
     */
    public function getApprovalStatus()
    {
        return $this->approvalStatus;
    }
    /**
     * Set approvalStatus value
     * @param \StructType\RecordRef $approvalStatus
     * @return \StructType\VendorPayment
     */
    public function setApprovalStatus(\StructType\RecordRef $approvalStatus = null)
    {
        $this->approvalStatus = $approvalStatus;
        return $this;
    }
    /**
     * Get nextApprover value
     * @return \StructType\RecordRef|null
     */
    public function getNextApprover()
    {
        return $this->nextApprover;
    }
    /**
     * Set nextApprover value
     * @param \StructType\RecordRef $nextApprover
     * @return \StructType\VendorPayment
     */
    public function setNextApprover(\StructType\RecordRef $nextApprover = null)
    {
        $this->nextApprover = $nextApprover;
        return $this;
    }
    /**
     * Get payeeAddressList value
     * @return \StructType\RecordRef|null
     */
    public function getPayeeAddressList()
    {
        return $this->payeeAddressList;
    }
    /**
     * Set payeeAddressList value
     * @param \StructType\RecordRef $payeeAddressList
     * @return \StructType\VendorPayment
     */
    public function setPayeeAddressList(\StructType\RecordRef $payeeAddressList = null)
    {
        $this->payeeAddressList = $payeeAddressList;
        return $this;
    }
    /**
     * Get payeeAddress value
     * @return \StructType\Address|null
     */
    public function getPayeeAddress()
    {
        return $this->payeeAddress;
    }
    /**
     * Set payeeAddress value
     * @param \StructType\Address $payeeAddress
     * @return \StructType\VendorPayment
     */
    public function setPayeeAddress(\StructType\Address $payeeAddress = null)
    {
        $this->payeeAddress = $payeeAddress;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\VendorPayment
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\VendorPayment
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\VendorPayment
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
