<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorCurrencyList StructType
 * @subpackage Structs
 */
class VendorCurrencyList extends AbstractStructBase
{
    /**
     * The vendorCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VendorCurrency[]
     */
    public $vendorCurrency;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for VendorCurrencyList
     * @uses VendorCurrencyList::setVendorCurrency()
     * @uses VendorCurrencyList::setReplaceAll()
     * @param \StructType\VendorCurrency[] $vendorCurrency
     * @param bool $replaceAll
     */
    public function __construct(array $vendorCurrency = array(), $replaceAll = true)
    {
        $this
            ->setVendorCurrency($vendorCurrency)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get vendorCurrency value
     * @return \StructType\VendorCurrency[]|null
     */
    public function getVendorCurrency()
    {
        return $this->vendorCurrency;
    }
    /**
     * This method is responsible for validating the values passed to the setVendorCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendorCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorCurrencyForArrayConstraintsFromSetVendorCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vendorCurrencyListVendorCurrencyItem) {
            // validation for constraint: itemType
            if (!$vendorCurrencyListVendorCurrencyItem instanceof \StructType\VendorCurrency) {
                $invalidValues[] = is_object($vendorCurrencyListVendorCurrencyItem) ? get_class($vendorCurrencyListVendorCurrencyItem) : sprintf('%s(%s)', gettype($vendorCurrencyListVendorCurrencyItem), var_export($vendorCurrencyListVendorCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The vendorCurrency property can only contain items of type \StructType\VendorCurrency, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set vendorCurrency value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorCurrency[] $vendorCurrency
     * @return \StructType\VendorCurrencyList
     */
    public function setVendorCurrency(array $vendorCurrency = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorCurrencyArrayErrorMessage = self::validateVendorCurrencyForArrayConstraintsFromSetVendorCurrency($vendorCurrency))) {
            throw new \InvalidArgumentException($vendorCurrencyArrayErrorMessage, __LINE__);
        }
        $this->vendorCurrency = $vendorCurrency;
        return $this;
    }
    /**
     * Add item to vendorCurrency value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorCurrency $item
     * @return \StructType\VendorCurrencyList
     */
    public function addToVendorCurrency(\StructType\VendorCurrency $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VendorCurrency) {
            throw new \InvalidArgumentException(sprintf('The vendorCurrency property can only contain items of type \StructType\VendorCurrency, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->vendorCurrency[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\VendorCurrencyList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
