<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorCurrency StructType
 * @subpackage Structs
 */
class VendorCurrency extends AbstractStructBase
{
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $balance;
    /**
     * The unbilledOrders
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $unbilledOrders;
    /**
     * Constructor method for VendorCurrency
     * @uses VendorCurrency::setCurrency()
     * @uses VendorCurrency::setBalance()
     * @uses VendorCurrency::setUnbilledOrders()
     * @param \StructType\RecordRef $currency
     * @param float $balance
     * @param float $unbilledOrders
     */
    public function __construct(\StructType\RecordRef $currency = null, $balance = null, $unbilledOrders = null)
    {
        $this
            ->setCurrency($currency)
            ->setBalance($balance)
            ->setUnbilledOrders($unbilledOrders);
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\VendorCurrency
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * Set balance value
     * @param float $balance
     * @return \StructType\VendorCurrency
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        $this->balance = $balance;
        return $this;
    }
    /**
     * Get unbilledOrders value
     * @return float|null
     */
    public function getUnbilledOrders()
    {
        return $this->unbilledOrders;
    }
    /**
     * Set unbilledOrders value
     * @param float $unbilledOrders
     * @return \StructType\VendorCurrency
     */
    public function setUnbilledOrders($unbilledOrders = null)
    {
        // validation for constraint: float
        if (!is_null($unbilledOrders) && !(is_float($unbilledOrders) || is_numeric($unbilledOrders))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unbilledOrders, true), gettype($unbilledOrders)), __LINE__);
        }
        $this->unbilledOrders = $unbilledOrders;
        return $this;
    }
}
