<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorCreditApply StructType
 * @subpackage Structs
 */
class VendorCreditApply extends AbstractStructBase
{
    /**
     * The apply
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $apply;
    /**
     * The applyDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $applyDate;
    /**
     * The doc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $doc;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The refNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $refNum;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $total;
    /**
     * The due
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $due;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * Constructor method for VendorCreditApply
     * @uses VendorCreditApply::setApply()
     * @uses VendorCreditApply::setApplyDate()
     * @uses VendorCreditApply::setDoc()
     * @uses VendorCreditApply::setLine()
     * @uses VendorCreditApply::setType()
     * @uses VendorCreditApply::setRefNum()
     * @uses VendorCreditApply::setTotal()
     * @uses VendorCreditApply::setDue()
     * @uses VendorCreditApply::setCurrency()
     * @uses VendorCreditApply::setAmount()
     * @param bool $apply
     * @param string $applyDate
     * @param int $doc
     * @param int $line
     * @param string $type
     * @param string $refNum
     * @param float $total
     * @param float $due
     * @param string $currency
     * @param float $amount
     */
    public function __construct($apply = null, $applyDate = null, $doc = null, $line = null, $type = null, $refNum = null, $total = null, $due = null, $currency = null, $amount = null)
    {
        $this
            ->setApply($apply)
            ->setApplyDate($applyDate)
            ->setDoc($doc)
            ->setLine($line)
            ->setType($type)
            ->setRefNum($refNum)
            ->setTotal($total)
            ->setDue($due)
            ->setCurrency($currency)
            ->setAmount($amount);
    }
    /**
     * Get apply value
     * @return bool|null
     */
    public function getApply()
    {
        return $this->apply;
    }
    /**
     * Set apply value
     * @param bool $apply
     * @return \StructType\VendorCreditApply
     */
    public function setApply($apply = null)
    {
        // validation for constraint: boolean
        if (!is_null($apply) && !is_bool($apply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($apply, true), gettype($apply)), __LINE__);
        }
        $this->apply = $apply;
        return $this;
    }
    /**
     * Get applyDate value
     * @return string|null
     */
    public function getApplyDate()
    {
        return $this->applyDate;
    }
    /**
     * Set applyDate value
     * @param string $applyDate
     * @return \StructType\VendorCreditApply
     */
    public function setApplyDate($applyDate = null)
    {
        // validation for constraint: string
        if (!is_null($applyDate) && !is_string($applyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applyDate, true), gettype($applyDate)), __LINE__);
        }
        $this->applyDate = $applyDate;
        return $this;
    }
    /**
     * Get doc value
     * @return int|null
     */
    public function getDoc()
    {
        return $this->doc;
    }
    /**
     * Set doc value
     * @param int $doc
     * @return \StructType\VendorCreditApply
     */
    public function setDoc($doc = null)
    {
        // validation for constraint: int
        if (!is_null($doc) && !(is_int($doc) || ctype_digit($doc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($doc, true), gettype($doc)), __LINE__);
        }
        $this->doc = $doc;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\VendorCreditApply
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\VendorCreditApply
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get refNum value
     * @return string|null
     */
    public function getRefNum()
    {
        return $this->refNum;
    }
    /**
     * Set refNum value
     * @param string $refNum
     * @return \StructType\VendorCreditApply
     */
    public function setRefNum($refNum = null)
    {
        // validation for constraint: string
        if (!is_null($refNum) && !is_string($refNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refNum, true), gettype($refNum)), __LINE__);
        }
        $this->refNum = $refNum;
        return $this;
    }
    /**
     * Get total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param float $total
     * @return \StructType\VendorCreditApply
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get due value
     * @return float|null
     */
    public function getDue()
    {
        return $this->due;
    }
    /**
     * Set due value
     * @param float $due
     * @return \StructType\VendorCreditApply
     */
    public function setDue($due = null)
    {
        // validation for constraint: float
        if (!is_null($due) && !(is_float($due) || is_numeric($due))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($due, true), gettype($due)), __LINE__);
        }
        $this->due = $due;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\VendorCreditApply
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\VendorCreditApply
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
}
