<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorBillExpenseList StructType
 * @subpackage Structs
 */
class VendorBillExpenseList extends AbstractStructBase
{
    /**
     * The expense
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VendorBillExpense[]
     */
    public $expense;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for VendorBillExpenseList
     * @uses VendorBillExpenseList::setExpense()
     * @uses VendorBillExpenseList::setReplaceAll()
     * @param \StructType\VendorBillExpense[] $expense
     * @param bool $replaceAll
     */
    public function __construct(array $expense = array(), $replaceAll = true)
    {
        $this
            ->setExpense($expense)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get expense value
     * @return \StructType\VendorBillExpense[]|null
     */
    public function getExpense()
    {
        return $this->expense;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpenseForArrayConstraintsFromSetExpense(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vendorBillExpenseListExpenseItem) {
            // validation for constraint: itemType
            if (!$vendorBillExpenseListExpenseItem instanceof \StructType\VendorBillExpense) {
                $invalidValues[] = is_object($vendorBillExpenseListExpenseItem) ? get_class($vendorBillExpenseListExpenseItem) : sprintf('%s(%s)', gettype($vendorBillExpenseListExpenseItem), var_export($vendorBillExpenseListExpenseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The expense property can only contain items of type \StructType\VendorBillExpense, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set expense value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorBillExpense[] $expense
     * @return \StructType\VendorBillExpenseList
     */
    public function setExpense(array $expense = array())
    {
        // validation for constraint: array
        if ('' !== ($expenseArrayErrorMessage = self::validateExpenseForArrayConstraintsFromSetExpense($expense))) {
            throw new \InvalidArgumentException($expenseArrayErrorMessage, __LINE__);
        }
        $this->expense = $expense;
        return $this;
    }
    /**
     * Add item to expense value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorBillExpense $item
     * @return \StructType\VendorBillExpenseList
     */
    public function addToExpense(\StructType\VendorBillExpense $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VendorBillExpense) {
            throw new \InvalidArgumentException(sprintf('The expense property can only contain items of type \StructType\VendorBillExpense, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->expense[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\VendorBillExpenseList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
