<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vendor StructType
 * Meta information extracted from the WSDL
 * - type: listRel:Vendor
 * @subpackage Structs
 */
class Vendor extends Record
{
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The entityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $entityId;
    /**
     * The altName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $altName;
    /**
     * The isPerson
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isPerson;
    /**
     * The phoneticName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phoneticName;
    /**
     * The salutation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $salutation;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The middleName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $middleName;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The companyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $companyName;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $url;
    /**
     * The defaultAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $defaultAddress;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The dateCreated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateCreated;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $category;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The printOnCheckAs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $printOnCheckAs;
    /**
     * The altPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $altPhone;
    /**
     * The homePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $homePhone;
    /**
     * The mobilePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mobilePhone;
    /**
     * The altEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $altEmail;
    /**
     * The comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comments;
    /**
     * The globalSubscriptionStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $globalSubscriptionStatus;
    /**
     * The image
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $image;
    /**
     * The emailPreference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $emailPreference;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The representingSubsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $representingSubsidiary;
    /**
     * The accountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accountNumber;
    /**
     * The legalName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $legalName;
    /**
     * The vatRegNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vatRegNumber;
    /**
     * The expenseAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $expenseAccount;
    /**
     * The payablesAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $payablesAccount;
    /**
     * The terms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $terms;
    /**
     * The incoterm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $incoterm;
    /**
     * The creditLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $creditLimit;
    /**
     * The balancePrimary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $balancePrimary;
    /**
     * The openingBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $openingBalance;
    /**
     * The openingBalanceDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $openingBalanceDate;
    /**
     * The openingBalanceAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $openingBalanceAccount;
    /**
     * The balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $balance;
    /**
     * The unbilledOrdersPrimary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $unbilledOrdersPrimary;
    /**
     * The bcn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bcn;
    /**
     * The unbilledOrders
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $unbilledOrders;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The is1099Eligible
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $is1099Eligible;
    /**
     * The isJobResourceVend
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isJobResourceVend;
    /**
     * The laborCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $laborCost;
    /**
     * The purchaseOrderQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $purchaseOrderQuantity;
    /**
     * The purchaseOrderAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $purchaseOrderAmount;
    /**
     * The purchaseOrderQuantityDiff
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $purchaseOrderQuantityDiff;
    /**
     * The receiptQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $receiptQuantity;
    /**
     * The receiptAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $receiptAmount;
    /**
     * The receiptQuantityDiff
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $receiptQuantityDiff;
    /**
     * The workCalendar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $workCalendar;
    /**
     * The taxIdNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxIdNum;
    /**
     * The taxItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxItem;
    /**
     * The giveAccess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $giveAccess;
    /**
     * The sendEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $sendEmail;
    /**
     * The billPay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $billPay;
    /**
     * The isAccountant
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isAccountant;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The password2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password2;
    /**
     * The requirePwdChange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $requirePwdChange;
    /**
     * The eligibleForCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $eligibleForCommission;
    /**
     * The emailTransactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $emailTransactions;
    /**
     * The printTransactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $printTransactions;
    /**
     * The faxTransactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $faxTransactions;
    /**
     * The defaultTaxReg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $defaultTaxReg;
    /**
     * The pricingScheduleList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorPricingScheduleList
     */
    public $pricingScheduleList;
    /**
     * The subscriptionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SubscriptionsList
     */
    public $subscriptionsList;
    /**
     * The addressbookList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorAddressbookList
     */
    public $addressbookList;
    /**
     * The currencyList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorCurrencyList
     */
    public $currencyList;
    /**
     * The rolesList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorRolesList
     */
    public $rolesList;
    /**
     * The taxRegistrationList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorTaxRegistrationList
     */
    public $taxRegistrationList;
    /**
     * The predictedDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $predictedDays;
    /**
     * The predConfidence
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $predConfidence;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Vendor
     * @uses Vendor::setCustomForm()
     * @uses Vendor::setEntityId()
     * @uses Vendor::setAltName()
     * @uses Vendor::setIsPerson()
     * @uses Vendor::setPhoneticName()
     * @uses Vendor::setSalutation()
     * @uses Vendor::setFirstName()
     * @uses Vendor::setMiddleName()
     * @uses Vendor::setLastName()
     * @uses Vendor::setCompanyName()
     * @uses Vendor::setPhone()
     * @uses Vendor::setFax()
     * @uses Vendor::setEmail()
     * @uses Vendor::setUrl()
     * @uses Vendor::setDefaultAddress()
     * @uses Vendor::setIsInactive()
     * @uses Vendor::setLastModifiedDate()
     * @uses Vendor::setDateCreated()
     * @uses Vendor::setCategory()
     * @uses Vendor::setTitle()
     * @uses Vendor::setPrintOnCheckAs()
     * @uses Vendor::setAltPhone()
     * @uses Vendor::setHomePhone()
     * @uses Vendor::setMobilePhone()
     * @uses Vendor::setAltEmail()
     * @uses Vendor::setComments()
     * @uses Vendor::setGlobalSubscriptionStatus()
     * @uses Vendor::setImage()
     * @uses Vendor::setEmailPreference()
     * @uses Vendor::setSubsidiary()
     * @uses Vendor::setRepresentingSubsidiary()
     * @uses Vendor::setAccountNumber()
     * @uses Vendor::setLegalName()
     * @uses Vendor::setVatRegNumber()
     * @uses Vendor::setExpenseAccount()
     * @uses Vendor::setPayablesAccount()
     * @uses Vendor::setTerms()
     * @uses Vendor::setIncoterm()
     * @uses Vendor::setCreditLimit()
     * @uses Vendor::setBalancePrimary()
     * @uses Vendor::setOpeningBalance()
     * @uses Vendor::setOpeningBalanceDate()
     * @uses Vendor::setOpeningBalanceAccount()
     * @uses Vendor::setBalance()
     * @uses Vendor::setUnbilledOrdersPrimary()
     * @uses Vendor::setBcn()
     * @uses Vendor::setUnbilledOrders()
     * @uses Vendor::setCurrency()
     * @uses Vendor::setIs1099Eligible()
     * @uses Vendor::setIsJobResourceVend()
     * @uses Vendor::setLaborCost()
     * @uses Vendor::setPurchaseOrderQuantity()
     * @uses Vendor::setPurchaseOrderAmount()
     * @uses Vendor::setPurchaseOrderQuantityDiff()
     * @uses Vendor::setReceiptQuantity()
     * @uses Vendor::setReceiptAmount()
     * @uses Vendor::setReceiptQuantityDiff()
     * @uses Vendor::setWorkCalendar()
     * @uses Vendor::setTaxIdNum()
     * @uses Vendor::setTaxItem()
     * @uses Vendor::setGiveAccess()
     * @uses Vendor::setSendEmail()
     * @uses Vendor::setBillPay()
     * @uses Vendor::setIsAccountant()
     * @uses Vendor::setPassword()
     * @uses Vendor::setPassword2()
     * @uses Vendor::setRequirePwdChange()
     * @uses Vendor::setEligibleForCommission()
     * @uses Vendor::setEmailTransactions()
     * @uses Vendor::setPrintTransactions()
     * @uses Vendor::setFaxTransactions()
     * @uses Vendor::setDefaultTaxReg()
     * @uses Vendor::setPricingScheduleList()
     * @uses Vendor::setSubscriptionsList()
     * @uses Vendor::setAddressbookList()
     * @uses Vendor::setCurrencyList()
     * @uses Vendor::setRolesList()
     * @uses Vendor::setTaxRegistrationList()
     * @uses Vendor::setPredictedDays()
     * @uses Vendor::setPredConfidence()
     * @uses Vendor::setCustomFieldList()
     * @uses Vendor::setInternalId()
     * @uses Vendor::setExternalId()
     * @param \StructType\RecordRef $customForm
     * @param string $entityId
     * @param string $altName
     * @param bool $isPerson
     * @param string $phoneticName
     * @param string $salutation
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     * @param string $companyName
     * @param string $phone
     * @param string $fax
     * @param string $email
     * @param string $url
     * @param string $defaultAddress
     * @param bool $isInactive
     * @param string $lastModifiedDate
     * @param string $dateCreated
     * @param \StructType\RecordRef $category
     * @param string $title
     * @param string $printOnCheckAs
     * @param string $altPhone
     * @param string $homePhone
     * @param string $mobilePhone
     * @param string $altEmail
     * @param string $comments
     * @param string $globalSubscriptionStatus
     * @param \StructType\RecordRef $image
     * @param string $emailPreference
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $representingSubsidiary
     * @param string $accountNumber
     * @param string $legalName
     * @param string $vatRegNumber
     * @param \StructType\RecordRef $expenseAccount
     * @param \StructType\RecordRef $payablesAccount
     * @param \StructType\RecordRef $terms
     * @param \StructType\RecordRef $incoterm
     * @param float $creditLimit
     * @param float $balancePrimary
     * @param float $openingBalance
     * @param string $openingBalanceDate
     * @param \StructType\RecordRef $openingBalanceAccount
     * @param float $balance
     * @param float $unbilledOrdersPrimary
     * @param string $bcn
     * @param float $unbilledOrders
     * @param \StructType\RecordRef $currency
     * @param bool $is1099Eligible
     * @param bool $isJobResourceVend
     * @param float $laborCost
     * @param float $purchaseOrderQuantity
     * @param float $purchaseOrderAmount
     * @param float $purchaseOrderQuantityDiff
     * @param float $receiptQuantity
     * @param float $receiptAmount
     * @param float $receiptQuantityDiff
     * @param \StructType\RecordRef $workCalendar
     * @param string $taxIdNum
     * @param \StructType\RecordRef $taxItem
     * @param bool $giveAccess
     * @param bool $sendEmail
     * @param bool $billPay
     * @param bool $isAccountant
     * @param string $password
     * @param string $password2
     * @param bool $requirePwdChange
     * @param bool $eligibleForCommission
     * @param bool $emailTransactions
     * @param bool $printTransactions
     * @param bool $faxTransactions
     * @param \StructType\RecordRef $defaultTaxReg
     * @param \StructType\VendorPricingScheduleList $pricingScheduleList
     * @param \StructType\SubscriptionsList $subscriptionsList
     * @param \StructType\VendorAddressbookList $addressbookList
     * @param \StructType\VendorCurrencyList $currencyList
     * @param \StructType\VendorRolesList $rolesList
     * @param \StructType\VendorTaxRegistrationList $taxRegistrationList
     * @param int $predictedDays
     * @param float $predConfidence
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $customForm = null, $entityId = null, $altName = null, $isPerson = null, $phoneticName = null, $salutation = null, $firstName = null, $middleName = null, $lastName = null, $companyName = null, $phone = null, $fax = null, $email = null, $url = null, $defaultAddress = null, $isInactive = null, $lastModifiedDate = null, $dateCreated = null, \StructType\RecordRef $category = null, $title = null, $printOnCheckAs = null, $altPhone = null, $homePhone = null, $mobilePhone = null, $altEmail = null, $comments = null, $globalSubscriptionStatus = null, \StructType\RecordRef $image = null, $emailPreference = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $representingSubsidiary = null, $accountNumber = null, $legalName = null, $vatRegNumber = null, \StructType\RecordRef $expenseAccount = null, \StructType\RecordRef $payablesAccount = null, \StructType\RecordRef $terms = null, \StructType\RecordRef $incoterm = null, $creditLimit = null, $balancePrimary = null, $openingBalance = null, $openingBalanceDate = null, \StructType\RecordRef $openingBalanceAccount = null, $balance = null, $unbilledOrdersPrimary = null, $bcn = null, $unbilledOrders = null, \StructType\RecordRef $currency = null, $is1099Eligible = null, $isJobResourceVend = null, $laborCost = null, $purchaseOrderQuantity = null, $purchaseOrderAmount = null, $purchaseOrderQuantityDiff = null, $receiptQuantity = null, $receiptAmount = null, $receiptQuantityDiff = null, \StructType\RecordRef $workCalendar = null, $taxIdNum = null, \StructType\RecordRef $taxItem = null, $giveAccess = null, $sendEmail = null, $billPay = null, $isAccountant = null, $password = null, $password2 = null, $requirePwdChange = null, $eligibleForCommission = null, $emailTransactions = null, $printTransactions = null, $faxTransactions = null, \StructType\RecordRef $defaultTaxReg = null, \StructType\VendorPricingScheduleList $pricingScheduleList = null, \StructType\SubscriptionsList $subscriptionsList = null, \StructType\VendorAddressbookList $addressbookList = null, \StructType\VendorCurrencyList $currencyList = null, \StructType\VendorRolesList $rolesList = null, \StructType\VendorTaxRegistrationList $taxRegistrationList = null, $predictedDays = null, $predConfidence = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomForm($customForm)
            ->setEntityId($entityId)
            ->setAltName($altName)
            ->setIsPerson($isPerson)
            ->setPhoneticName($phoneticName)
            ->setSalutation($salutation)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setLastName($lastName)
            ->setCompanyName($companyName)
            ->setPhone($phone)
            ->setFax($fax)
            ->setEmail($email)
            ->setUrl($url)
            ->setDefaultAddress($defaultAddress)
            ->setIsInactive($isInactive)
            ->setLastModifiedDate($lastModifiedDate)
            ->setDateCreated($dateCreated)
            ->setCategory($category)
            ->setTitle($title)
            ->setPrintOnCheckAs($printOnCheckAs)
            ->setAltPhone($altPhone)
            ->setHomePhone($homePhone)
            ->setMobilePhone($mobilePhone)
            ->setAltEmail($altEmail)
            ->setComments($comments)
            ->setGlobalSubscriptionStatus($globalSubscriptionStatus)
            ->setImage($image)
            ->setEmailPreference($emailPreference)
            ->setSubsidiary($subsidiary)
            ->setRepresentingSubsidiary($representingSubsidiary)
            ->setAccountNumber($accountNumber)
            ->setLegalName($legalName)
            ->setVatRegNumber($vatRegNumber)
            ->setExpenseAccount($expenseAccount)
            ->setPayablesAccount($payablesAccount)
            ->setTerms($terms)
            ->setIncoterm($incoterm)
            ->setCreditLimit($creditLimit)
            ->setBalancePrimary($balancePrimary)
            ->setOpeningBalance($openingBalance)
            ->setOpeningBalanceDate($openingBalanceDate)
            ->setOpeningBalanceAccount($openingBalanceAccount)
            ->setBalance($balance)
            ->setUnbilledOrdersPrimary($unbilledOrdersPrimary)
            ->setBcn($bcn)
            ->setUnbilledOrders($unbilledOrders)
            ->setCurrency($currency)
            ->setIs1099Eligible($is1099Eligible)
            ->setIsJobResourceVend($isJobResourceVend)
            ->setLaborCost($laborCost)
            ->setPurchaseOrderQuantity($purchaseOrderQuantity)
            ->setPurchaseOrderAmount($purchaseOrderAmount)
            ->setPurchaseOrderQuantityDiff($purchaseOrderQuantityDiff)
            ->setReceiptQuantity($receiptQuantity)
            ->setReceiptAmount($receiptAmount)
            ->setReceiptQuantityDiff($receiptQuantityDiff)
            ->setWorkCalendar($workCalendar)
            ->setTaxIdNum($taxIdNum)
            ->setTaxItem($taxItem)
            ->setGiveAccess($giveAccess)
            ->setSendEmail($sendEmail)
            ->setBillPay($billPay)
            ->setIsAccountant($isAccountant)
            ->setPassword($password)
            ->setPassword2($password2)
            ->setRequirePwdChange($requirePwdChange)
            ->setEligibleForCommission($eligibleForCommission)
            ->setEmailTransactions($emailTransactions)
            ->setPrintTransactions($printTransactions)
            ->setFaxTransactions($faxTransactions)
            ->setDefaultTaxReg($defaultTaxReg)
            ->setPricingScheduleList($pricingScheduleList)
            ->setSubscriptionsList($subscriptionsList)
            ->setAddressbookList($addressbookList)
            ->setCurrencyList($currencyList)
            ->setRolesList($rolesList)
            ->setTaxRegistrationList($taxRegistrationList)
            ->setPredictedDays($predictedDays)
            ->setPredConfidence($predConfidence)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\Vendor
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get entityId value
     * @return string|null
     */
    public function getEntityId()
    {
        return $this->entityId;
    }
    /**
     * Set entityId value
     * @param string $entityId
     * @return \StructType\Vendor
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->entityId = $entityId;
        return $this;
    }
    /**
     * Get altName value
     * @return string|null
     */
    public function getAltName()
    {
        return $this->altName;
    }
    /**
     * Set altName value
     * @param string $altName
     * @return \StructType\Vendor
     */
    public function setAltName($altName = null)
    {
        // validation for constraint: string
        if (!is_null($altName) && !is_string($altName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altName, true), gettype($altName)), __LINE__);
        }
        $this->altName = $altName;
        return $this;
    }
    /**
     * Get isPerson value
     * @return bool|null
     */
    public function getIsPerson()
    {
        return $this->isPerson;
    }
    /**
     * Set isPerson value
     * @param bool $isPerson
     * @return \StructType\Vendor
     */
    public function setIsPerson($isPerson = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPerson) && !is_bool($isPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPerson, true), gettype($isPerson)), __LINE__);
        }
        $this->isPerson = $isPerson;
        return $this;
    }
    /**
     * Get phoneticName value
     * @return string|null
     */
    public function getPhoneticName()
    {
        return $this->phoneticName;
    }
    /**
     * Set phoneticName value
     * @param string $phoneticName
     * @return \StructType\Vendor
     */
    public function setPhoneticName($phoneticName = null)
    {
        // validation for constraint: string
        if (!is_null($phoneticName) && !is_string($phoneticName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneticName, true), gettype($phoneticName)), __LINE__);
        }
        $this->phoneticName = $phoneticName;
        return $this;
    }
    /**
     * Get salutation value
     * @return string|null
     */
    public function getSalutation()
    {
        return $this->salutation;
    }
    /**
     * Set salutation value
     * @param string $salutation
     * @return \StructType\Vendor
     */
    public function setSalutation($salutation = null)
    {
        // validation for constraint: string
        if (!is_null($salutation) && !is_string($salutation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salutation, true), gettype($salutation)), __LINE__);
        }
        $this->salutation = $salutation;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\Vendor
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return \StructType\Vendor
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\Vendor
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get companyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->companyName;
    }
    /**
     * Set companyName value
     * @param string $companyName
     * @return \StructType\Vendor
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->companyName = $companyName;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\Vendor
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\Vendor
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Vendor
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \StructType\Vendor
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get defaultAddress value
     * @return string|null
     */
    public function getDefaultAddress()
    {
        return $this->defaultAddress;
    }
    /**
     * Set defaultAddress value
     * @param string $defaultAddress
     * @return \StructType\Vendor
     */
    public function setDefaultAddress($defaultAddress = null)
    {
        // validation for constraint: string
        if (!is_null($defaultAddress) && !is_string($defaultAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultAddress, true), gettype($defaultAddress)), __LINE__);
        }
        $this->defaultAddress = $defaultAddress;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\Vendor
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Vendor
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get dateCreated value
     * @return string|null
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }
    /**
     * Set dateCreated value
     * @param string $dateCreated
     * @return \StructType\Vendor
     */
    public function setDateCreated($dateCreated = null)
    {
        // validation for constraint: string
        if (!is_null($dateCreated) && !is_string($dateCreated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateCreated, true), gettype($dateCreated)), __LINE__);
        }
        $this->dateCreated = $dateCreated;
        return $this;
    }
    /**
     * Get category value
     * @return \StructType\RecordRef|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param \StructType\RecordRef $category
     * @return \StructType\Vendor
     */
    public function setCategory(\StructType\RecordRef $category = null)
    {
        $this->category = $category;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\Vendor
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get printOnCheckAs value
     * @return string|null
     */
    public function getPrintOnCheckAs()
    {
        return $this->printOnCheckAs;
    }
    /**
     * Set printOnCheckAs value
     * @param string $printOnCheckAs
     * @return \StructType\Vendor
     */
    public function setPrintOnCheckAs($printOnCheckAs = null)
    {
        // validation for constraint: string
        if (!is_null($printOnCheckAs) && !is_string($printOnCheckAs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printOnCheckAs, true), gettype($printOnCheckAs)), __LINE__);
        }
        $this->printOnCheckAs = $printOnCheckAs;
        return $this;
    }
    /**
     * Get altPhone value
     * @return string|null
     */
    public function getAltPhone()
    {
        return $this->altPhone;
    }
    /**
     * Set altPhone value
     * @param string $altPhone
     * @return \StructType\Vendor
     */
    public function setAltPhone($altPhone = null)
    {
        // validation for constraint: string
        if (!is_null($altPhone) && !is_string($altPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altPhone, true), gettype($altPhone)), __LINE__);
        }
        $this->altPhone = $altPhone;
        return $this;
    }
    /**
     * Get homePhone value
     * @return string|null
     */
    public function getHomePhone()
    {
        return $this->homePhone;
    }
    /**
     * Set homePhone value
     * @param string $homePhone
     * @return \StructType\Vendor
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homePhone, true), gettype($homePhone)), __LINE__);
        }
        $this->homePhone = $homePhone;
        return $this;
    }
    /**
     * Get mobilePhone value
     * @return string|null
     */
    public function getMobilePhone()
    {
        return $this->mobilePhone;
    }
    /**
     * Set mobilePhone value
     * @param string $mobilePhone
     * @return \StructType\Vendor
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        $this->mobilePhone = $mobilePhone;
        return $this;
    }
    /**
     * Get altEmail value
     * @return string|null
     */
    public function getAltEmail()
    {
        return $this->altEmail;
    }
    /**
     * Set altEmail value
     * @param string $altEmail
     * @return \StructType\Vendor
     */
    public function setAltEmail($altEmail = null)
    {
        // validation for constraint: string
        if (!is_null($altEmail) && !is_string($altEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altEmail, true), gettype($altEmail)), __LINE__);
        }
        $this->altEmail = $altEmail;
        return $this;
    }
    /**
     * Get comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->comments;
    }
    /**
     * Set comments value
     * @param string $comments
     * @return \StructType\Vendor
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->comments = $comments;
        return $this;
    }
    /**
     * Get globalSubscriptionStatus value
     * @return string|null
     */
    public function getGlobalSubscriptionStatus()
    {
        return $this->globalSubscriptionStatus;
    }
    /**
     * Set globalSubscriptionStatus value
     * @uses \EnumType\GlobalSubscriptionStatus::valueIsValid()
     * @uses \EnumType\GlobalSubscriptionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $globalSubscriptionStatus
     * @return \StructType\Vendor
     */
    public function setGlobalSubscriptionStatus($globalSubscriptionStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GlobalSubscriptionStatus::valueIsValid($globalSubscriptionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GlobalSubscriptionStatus', is_array($globalSubscriptionStatus) ? implode(', ', $globalSubscriptionStatus) : var_export($globalSubscriptionStatus, true), implode(', ', \EnumType\GlobalSubscriptionStatus::getValidValues())), __LINE__);
        }
        $this->globalSubscriptionStatus = $globalSubscriptionStatus;
        return $this;
    }
    /**
     * Get image value
     * @return \StructType\RecordRef|null
     */
    public function getImage()
    {
        return $this->image;
    }
    /**
     * Set image value
     * @param \StructType\RecordRef $image
     * @return \StructType\Vendor
     */
    public function setImage(\StructType\RecordRef $image = null)
    {
        $this->image = $image;
        return $this;
    }
    /**
     * Get emailPreference value
     * @return string|null
     */
    public function getEmailPreference()
    {
        return $this->emailPreference;
    }
    /**
     * Set emailPreference value
     * @uses \EnumType\EmailPreference::valueIsValid()
     * @uses \EnumType\EmailPreference::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $emailPreference
     * @return \StructType\Vendor
     */
    public function setEmailPreference($emailPreference = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmailPreference::valueIsValid($emailPreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EmailPreference', is_array($emailPreference) ? implode(', ', $emailPreference) : var_export($emailPreference, true), implode(', ', \EnumType\EmailPreference::getValidValues())), __LINE__);
        }
        $this->emailPreference = $emailPreference;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\Vendor
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get representingSubsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getRepresentingSubsidiary()
    {
        return $this->representingSubsidiary;
    }
    /**
     * Set representingSubsidiary value
     * @param \StructType\RecordRef $representingSubsidiary
     * @return \StructType\Vendor
     */
    public function setRepresentingSubsidiary(\StructType\RecordRef $representingSubsidiary = null)
    {
        $this->representingSubsidiary = $representingSubsidiary;
        return $this;
    }
    /**
     * Get accountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \StructType\Vendor
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get legalName value
     * @return string|null
     */
    public function getLegalName()
    {
        return $this->legalName;
    }
    /**
     * Set legalName value
     * @param string $legalName
     * @return \StructType\Vendor
     */
    public function setLegalName($legalName = null)
    {
        // validation for constraint: string
        if (!is_null($legalName) && !is_string($legalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($legalName, true), gettype($legalName)), __LINE__);
        }
        $this->legalName = $legalName;
        return $this;
    }
    /**
     * Get vatRegNumber value
     * @return string|null
     */
    public function getVatRegNumber()
    {
        return $this->vatRegNumber;
    }
    /**
     * Set vatRegNumber value
     * @param string $vatRegNumber
     * @return \StructType\Vendor
     */
    public function setVatRegNumber($vatRegNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegNumber) && !is_string($vatRegNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegNumber, true), gettype($vatRegNumber)), __LINE__);
        }
        $this->vatRegNumber = $vatRegNumber;
        return $this;
    }
    /**
     * Get expenseAccount value
     * @return \StructType\RecordRef|null
     */
    public function getExpenseAccount()
    {
        return $this->expenseAccount;
    }
    /**
     * Set expenseAccount value
     * @param \StructType\RecordRef $expenseAccount
     * @return \StructType\Vendor
     */
    public function setExpenseAccount(\StructType\RecordRef $expenseAccount = null)
    {
        $this->expenseAccount = $expenseAccount;
        return $this;
    }
    /**
     * Get payablesAccount value
     * @return \StructType\RecordRef|null
     */
    public function getPayablesAccount()
    {
        return $this->payablesAccount;
    }
    /**
     * Set payablesAccount value
     * @param \StructType\RecordRef $payablesAccount
     * @return \StructType\Vendor
     */
    public function setPayablesAccount(\StructType\RecordRef $payablesAccount = null)
    {
        $this->payablesAccount = $payablesAccount;
        return $this;
    }
    /**
     * Get terms value
     * @return \StructType\RecordRef|null
     */
    public function getTerms()
    {
        return $this->terms;
    }
    /**
     * Set terms value
     * @param \StructType\RecordRef $terms
     * @return \StructType\Vendor
     */
    public function setTerms(\StructType\RecordRef $terms = null)
    {
        $this->terms = $terms;
        return $this;
    }
    /**
     * Get incoterm value
     * @return \StructType\RecordRef|null
     */
    public function getIncoterm()
    {
        return $this->incoterm;
    }
    /**
     * Set incoterm value
     * @param \StructType\RecordRef $incoterm
     * @return \StructType\Vendor
     */
    public function setIncoterm(\StructType\RecordRef $incoterm = null)
    {
        $this->incoterm = $incoterm;
        return $this;
    }
    /**
     * Get creditLimit value
     * @return float|null
     */
    public function getCreditLimit()
    {
        return $this->creditLimit;
    }
    /**
     * Set creditLimit value
     * @param float $creditLimit
     * @return \StructType\Vendor
     */
    public function setCreditLimit($creditLimit = null)
    {
        // validation for constraint: float
        if (!is_null($creditLimit) && !(is_float($creditLimit) || is_numeric($creditLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($creditLimit, true), gettype($creditLimit)), __LINE__);
        }
        $this->creditLimit = $creditLimit;
        return $this;
    }
    /**
     * Get balancePrimary value
     * @return float|null
     */
    public function getBalancePrimary()
    {
        return $this->balancePrimary;
    }
    /**
     * Set balancePrimary value
     * @param float $balancePrimary
     * @return \StructType\Vendor
     */
    public function setBalancePrimary($balancePrimary = null)
    {
        // validation for constraint: float
        if (!is_null($balancePrimary) && !(is_float($balancePrimary) || is_numeric($balancePrimary))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balancePrimary, true), gettype($balancePrimary)), __LINE__);
        }
        $this->balancePrimary = $balancePrimary;
        return $this;
    }
    /**
     * Get openingBalance value
     * @return float|null
     */
    public function getOpeningBalance()
    {
        return $this->openingBalance;
    }
    /**
     * Set openingBalance value
     * @param float $openingBalance
     * @return \StructType\Vendor
     */
    public function setOpeningBalance($openingBalance = null)
    {
        // validation for constraint: float
        if (!is_null($openingBalance) && !(is_float($openingBalance) || is_numeric($openingBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($openingBalance, true), gettype($openingBalance)), __LINE__);
        }
        $this->openingBalance = $openingBalance;
        return $this;
    }
    /**
     * Get openingBalanceDate value
     * @return string|null
     */
    public function getOpeningBalanceDate()
    {
        return $this->openingBalanceDate;
    }
    /**
     * Set openingBalanceDate value
     * @param string $openingBalanceDate
     * @return \StructType\Vendor
     */
    public function setOpeningBalanceDate($openingBalanceDate = null)
    {
        // validation for constraint: string
        if (!is_null($openingBalanceDate) && !is_string($openingBalanceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openingBalanceDate, true), gettype($openingBalanceDate)), __LINE__);
        }
        $this->openingBalanceDate = $openingBalanceDate;
        return $this;
    }
    /**
     * Get openingBalanceAccount value
     * @return \StructType\RecordRef|null
     */
    public function getOpeningBalanceAccount()
    {
        return $this->openingBalanceAccount;
    }
    /**
     * Set openingBalanceAccount value
     * @param \StructType\RecordRef $openingBalanceAccount
     * @return \StructType\Vendor
     */
    public function setOpeningBalanceAccount(\StructType\RecordRef $openingBalanceAccount = null)
    {
        $this->openingBalanceAccount = $openingBalanceAccount;
        return $this;
    }
    /**
     * Get balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * Set balance value
     * @param float $balance
     * @return \StructType\Vendor
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        $this->balance = $balance;
        return $this;
    }
    /**
     * Get unbilledOrdersPrimary value
     * @return float|null
     */
    public function getUnbilledOrdersPrimary()
    {
        return $this->unbilledOrdersPrimary;
    }
    /**
     * Set unbilledOrdersPrimary value
     * @param float $unbilledOrdersPrimary
     * @return \StructType\Vendor
     */
    public function setUnbilledOrdersPrimary($unbilledOrdersPrimary = null)
    {
        // validation for constraint: float
        if (!is_null($unbilledOrdersPrimary) && !(is_float($unbilledOrdersPrimary) || is_numeric($unbilledOrdersPrimary))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unbilledOrdersPrimary, true), gettype($unbilledOrdersPrimary)), __LINE__);
        }
        $this->unbilledOrdersPrimary = $unbilledOrdersPrimary;
        return $this;
    }
    /**
     * Get bcn value
     * @return string|null
     */
    public function getBcn()
    {
        return $this->bcn;
    }
    /**
     * Set bcn value
     * @param string $bcn
     * @return \StructType\Vendor
     */
    public function setBcn($bcn = null)
    {
        // validation for constraint: string
        if (!is_null($bcn) && !is_string($bcn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bcn, true), gettype($bcn)), __LINE__);
        }
        $this->bcn = $bcn;
        return $this;
    }
    /**
     * Get unbilledOrders value
     * @return float|null
     */
    public function getUnbilledOrders()
    {
        return $this->unbilledOrders;
    }
    /**
     * Set unbilledOrders value
     * @param float $unbilledOrders
     * @return \StructType\Vendor
     */
    public function setUnbilledOrders($unbilledOrders = null)
    {
        // validation for constraint: float
        if (!is_null($unbilledOrders) && !(is_float($unbilledOrders) || is_numeric($unbilledOrders))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unbilledOrders, true), gettype($unbilledOrders)), __LINE__);
        }
        $this->unbilledOrders = $unbilledOrders;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\Vendor
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get is1099Eligible value
     * @return bool|null
     */
    public function getIs1099Eligible()
    {
        return $this->is1099Eligible;
    }
    /**
     * Set is1099Eligible value
     * @param bool $is1099Eligible
     * @return \StructType\Vendor
     */
    public function setIs1099Eligible($is1099Eligible = null)
    {
        // validation for constraint: boolean
        if (!is_null($is1099Eligible) && !is_bool($is1099Eligible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($is1099Eligible, true), gettype($is1099Eligible)), __LINE__);
        }
        $this->is1099Eligible = $is1099Eligible;
        return $this;
    }
    /**
     * Get isJobResourceVend value
     * @return bool|null
     */
    public function getIsJobResourceVend()
    {
        return $this->isJobResourceVend;
    }
    /**
     * Set isJobResourceVend value
     * @param bool $isJobResourceVend
     * @return \StructType\Vendor
     */
    public function setIsJobResourceVend($isJobResourceVend = null)
    {
        // validation for constraint: boolean
        if (!is_null($isJobResourceVend) && !is_bool($isJobResourceVend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isJobResourceVend, true), gettype($isJobResourceVend)), __LINE__);
        }
        $this->isJobResourceVend = $isJobResourceVend;
        return $this;
    }
    /**
     * Get laborCost value
     * @return float|null
     */
    public function getLaborCost()
    {
        return $this->laborCost;
    }
    /**
     * Set laborCost value
     * @param float $laborCost
     * @return \StructType\Vendor
     */
    public function setLaborCost($laborCost = null)
    {
        // validation for constraint: float
        if (!is_null($laborCost) && !(is_float($laborCost) || is_numeric($laborCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($laborCost, true), gettype($laborCost)), __LINE__);
        }
        $this->laborCost = $laborCost;
        return $this;
    }
    /**
     * Get purchaseOrderQuantity value
     * @return float|null
     */
    public function getPurchaseOrderQuantity()
    {
        return $this->purchaseOrderQuantity;
    }
    /**
     * Set purchaseOrderQuantity value
     * @param float $purchaseOrderQuantity
     * @return \StructType\Vendor
     */
    public function setPurchaseOrderQuantity($purchaseOrderQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseOrderQuantity) && !(is_float($purchaseOrderQuantity) || is_numeric($purchaseOrderQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseOrderQuantity, true), gettype($purchaseOrderQuantity)), __LINE__);
        }
        $this->purchaseOrderQuantity = $purchaseOrderQuantity;
        return $this;
    }
    /**
     * Get purchaseOrderAmount value
     * @return float|null
     */
    public function getPurchaseOrderAmount()
    {
        return $this->purchaseOrderAmount;
    }
    /**
     * Set purchaseOrderAmount value
     * @param float $purchaseOrderAmount
     * @return \StructType\Vendor
     */
    public function setPurchaseOrderAmount($purchaseOrderAmount = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseOrderAmount) && !(is_float($purchaseOrderAmount) || is_numeric($purchaseOrderAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseOrderAmount, true), gettype($purchaseOrderAmount)), __LINE__);
        }
        $this->purchaseOrderAmount = $purchaseOrderAmount;
        return $this;
    }
    /**
     * Get purchaseOrderQuantityDiff value
     * @return float|null
     */
    public function getPurchaseOrderQuantityDiff()
    {
        return $this->purchaseOrderQuantityDiff;
    }
    /**
     * Set purchaseOrderQuantityDiff value
     * @param float $purchaseOrderQuantityDiff
     * @return \StructType\Vendor
     */
    public function setPurchaseOrderQuantityDiff($purchaseOrderQuantityDiff = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseOrderQuantityDiff) && !(is_float($purchaseOrderQuantityDiff) || is_numeric($purchaseOrderQuantityDiff))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseOrderQuantityDiff, true), gettype($purchaseOrderQuantityDiff)), __LINE__);
        }
        $this->purchaseOrderQuantityDiff = $purchaseOrderQuantityDiff;
        return $this;
    }
    /**
     * Get receiptQuantity value
     * @return float|null
     */
    public function getReceiptQuantity()
    {
        return $this->receiptQuantity;
    }
    /**
     * Set receiptQuantity value
     * @param float $receiptQuantity
     * @return \StructType\Vendor
     */
    public function setReceiptQuantity($receiptQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($receiptQuantity) && !(is_float($receiptQuantity) || is_numeric($receiptQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($receiptQuantity, true), gettype($receiptQuantity)), __LINE__);
        }
        $this->receiptQuantity = $receiptQuantity;
        return $this;
    }
    /**
     * Get receiptAmount value
     * @return float|null
     */
    public function getReceiptAmount()
    {
        return $this->receiptAmount;
    }
    /**
     * Set receiptAmount value
     * @param float $receiptAmount
     * @return \StructType\Vendor
     */
    public function setReceiptAmount($receiptAmount = null)
    {
        // validation for constraint: float
        if (!is_null($receiptAmount) && !(is_float($receiptAmount) || is_numeric($receiptAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($receiptAmount, true), gettype($receiptAmount)), __LINE__);
        }
        $this->receiptAmount = $receiptAmount;
        return $this;
    }
    /**
     * Get receiptQuantityDiff value
     * @return float|null
     */
    public function getReceiptQuantityDiff()
    {
        return $this->receiptQuantityDiff;
    }
    /**
     * Set receiptQuantityDiff value
     * @param float $receiptQuantityDiff
     * @return \StructType\Vendor
     */
    public function setReceiptQuantityDiff($receiptQuantityDiff = null)
    {
        // validation for constraint: float
        if (!is_null($receiptQuantityDiff) && !(is_float($receiptQuantityDiff) || is_numeric($receiptQuantityDiff))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($receiptQuantityDiff, true), gettype($receiptQuantityDiff)), __LINE__);
        }
        $this->receiptQuantityDiff = $receiptQuantityDiff;
        return $this;
    }
    /**
     * Get workCalendar value
     * @return \StructType\RecordRef|null
     */
    public function getWorkCalendar()
    {
        return $this->workCalendar;
    }
    /**
     * Set workCalendar value
     * @param \StructType\RecordRef $workCalendar
     * @return \StructType\Vendor
     */
    public function setWorkCalendar(\StructType\RecordRef $workCalendar = null)
    {
        $this->workCalendar = $workCalendar;
        return $this;
    }
    /**
     * Get taxIdNum value
     * @return string|null
     */
    public function getTaxIdNum()
    {
        return $this->taxIdNum;
    }
    /**
     * Set taxIdNum value
     * @param string $taxIdNum
     * @return \StructType\Vendor
     */
    public function setTaxIdNum($taxIdNum = null)
    {
        // validation for constraint: string
        if (!is_null($taxIdNum) && !is_string($taxIdNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxIdNum, true), gettype($taxIdNum)), __LINE__);
        }
        $this->taxIdNum = $taxIdNum;
        return $this;
    }
    /**
     * Get taxItem value
     * @return \StructType\RecordRef|null
     */
    public function getTaxItem()
    {
        return $this->taxItem;
    }
    /**
     * Set taxItem value
     * @param \StructType\RecordRef $taxItem
     * @return \StructType\Vendor
     */
    public function setTaxItem(\StructType\RecordRef $taxItem = null)
    {
        $this->taxItem = $taxItem;
        return $this;
    }
    /**
     * Get giveAccess value
     * @return bool|null
     */
    public function getGiveAccess()
    {
        return $this->giveAccess;
    }
    /**
     * Set giveAccess value
     * @param bool $giveAccess
     * @return \StructType\Vendor
     */
    public function setGiveAccess($giveAccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($giveAccess) && !is_bool($giveAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($giveAccess, true), gettype($giveAccess)), __LINE__);
        }
        $this->giveAccess = $giveAccess;
        return $this;
    }
    /**
     * Get sendEmail value
     * @return bool|null
     */
    public function getSendEmail()
    {
        return $this->sendEmail;
    }
    /**
     * Set sendEmail value
     * @param bool $sendEmail
     * @return \StructType\Vendor
     */
    public function setSendEmail($sendEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendEmail) && !is_bool($sendEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendEmail, true), gettype($sendEmail)), __LINE__);
        }
        $this->sendEmail = $sendEmail;
        return $this;
    }
    /**
     * Get billPay value
     * @return bool|null
     */
    public function getBillPay()
    {
        return $this->billPay;
    }
    /**
     * Set billPay value
     * @param bool $billPay
     * @return \StructType\Vendor
     */
    public function setBillPay($billPay = null)
    {
        // validation for constraint: boolean
        if (!is_null($billPay) && !is_bool($billPay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($billPay, true), gettype($billPay)), __LINE__);
        }
        $this->billPay = $billPay;
        return $this;
    }
    /**
     * Get isAccountant value
     * @return bool|null
     */
    public function getIsAccountant()
    {
        return $this->isAccountant;
    }
    /**
     * Set isAccountant value
     * @param bool $isAccountant
     * @return \StructType\Vendor
     */
    public function setIsAccountant($isAccountant = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAccountant) && !is_bool($isAccountant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAccountant, true), gettype($isAccountant)), __LINE__);
        }
        $this->isAccountant = $isAccountant;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\Vendor
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get password2 value
     * @return string|null
     */
    public function getPassword2()
    {
        return $this->password2;
    }
    /**
     * Set password2 value
     * @param string $password2
     * @return \StructType\Vendor
     */
    public function setPassword2($password2 = null)
    {
        // validation for constraint: string
        if (!is_null($password2) && !is_string($password2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password2, true), gettype($password2)), __LINE__);
        }
        $this->password2 = $password2;
        return $this;
    }
    /**
     * Get requirePwdChange value
     * @return bool|null
     */
    public function getRequirePwdChange()
    {
        return $this->requirePwdChange;
    }
    /**
     * Set requirePwdChange value
     * @param bool $requirePwdChange
     * @return \StructType\Vendor
     */
    public function setRequirePwdChange($requirePwdChange = null)
    {
        // validation for constraint: boolean
        if (!is_null($requirePwdChange) && !is_bool($requirePwdChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requirePwdChange, true), gettype($requirePwdChange)), __LINE__);
        }
        $this->requirePwdChange = $requirePwdChange;
        return $this;
    }
    /**
     * Get eligibleForCommission value
     * @return bool|null
     */
    public function getEligibleForCommission()
    {
        return $this->eligibleForCommission;
    }
    /**
     * Set eligibleForCommission value
     * @param bool $eligibleForCommission
     * @return \StructType\Vendor
     */
    public function setEligibleForCommission($eligibleForCommission = null)
    {
        // validation for constraint: boolean
        if (!is_null($eligibleForCommission) && !is_bool($eligibleForCommission)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eligibleForCommission, true), gettype($eligibleForCommission)), __LINE__);
        }
        $this->eligibleForCommission = $eligibleForCommission;
        return $this;
    }
    /**
     * Get emailTransactions value
     * @return bool|null
     */
    public function getEmailTransactions()
    {
        return $this->emailTransactions;
    }
    /**
     * Set emailTransactions value
     * @param bool $emailTransactions
     * @return \StructType\Vendor
     */
    public function setEmailTransactions($emailTransactions = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailTransactions) && !is_bool($emailTransactions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emailTransactions, true), gettype($emailTransactions)), __LINE__);
        }
        $this->emailTransactions = $emailTransactions;
        return $this;
    }
    /**
     * Get printTransactions value
     * @return bool|null
     */
    public function getPrintTransactions()
    {
        return $this->printTransactions;
    }
    /**
     * Set printTransactions value
     * @param bool $printTransactions
     * @return \StructType\Vendor
     */
    public function setPrintTransactions($printTransactions = null)
    {
        // validation for constraint: boolean
        if (!is_null($printTransactions) && !is_bool($printTransactions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printTransactions, true), gettype($printTransactions)), __LINE__);
        }
        $this->printTransactions = $printTransactions;
        return $this;
    }
    /**
     * Get faxTransactions value
     * @return bool|null
     */
    public function getFaxTransactions()
    {
        return $this->faxTransactions;
    }
    /**
     * Set faxTransactions value
     * @param bool $faxTransactions
     * @return \StructType\Vendor
     */
    public function setFaxTransactions($faxTransactions = null)
    {
        // validation for constraint: boolean
        if (!is_null($faxTransactions) && !is_bool($faxTransactions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($faxTransactions, true), gettype($faxTransactions)), __LINE__);
        }
        $this->faxTransactions = $faxTransactions;
        return $this;
    }
    /**
     * Get defaultTaxReg value
     * @return \StructType\RecordRef|null
     */
    public function getDefaultTaxReg()
    {
        return $this->defaultTaxReg;
    }
    /**
     * Set defaultTaxReg value
     * @param \StructType\RecordRef $defaultTaxReg
     * @return \StructType\Vendor
     */
    public function setDefaultTaxReg(\StructType\RecordRef $defaultTaxReg = null)
    {
        $this->defaultTaxReg = $defaultTaxReg;
        return $this;
    }
    /**
     * Get pricingScheduleList value
     * @return \StructType\VendorPricingScheduleList|null
     */
    public function getPricingScheduleList()
    {
        return $this->pricingScheduleList;
    }
    /**
     * Set pricingScheduleList value
     * @param \StructType\VendorPricingScheduleList $pricingScheduleList
     * @return \StructType\Vendor
     */
    public function setPricingScheduleList(\StructType\VendorPricingScheduleList $pricingScheduleList = null)
    {
        $this->pricingScheduleList = $pricingScheduleList;
        return $this;
    }
    /**
     * Get subscriptionsList value
     * @return \StructType\SubscriptionsList|null
     */
    public function getSubscriptionsList()
    {
        return $this->subscriptionsList;
    }
    /**
     * Set subscriptionsList value
     * @param \StructType\SubscriptionsList $subscriptionsList
     * @return \StructType\Vendor
     */
    public function setSubscriptionsList(\StructType\SubscriptionsList $subscriptionsList = null)
    {
        $this->subscriptionsList = $subscriptionsList;
        return $this;
    }
    /**
     * Get addressbookList value
     * @return \StructType\VendorAddressbookList|null
     */
    public function getAddressbookList()
    {
        return $this->addressbookList;
    }
    /**
     * Set addressbookList value
     * @param \StructType\VendorAddressbookList $addressbookList
     * @return \StructType\Vendor
     */
    public function setAddressbookList(\StructType\VendorAddressbookList $addressbookList = null)
    {
        $this->addressbookList = $addressbookList;
        return $this;
    }
    /**
     * Get currencyList value
     * @return \StructType\VendorCurrencyList|null
     */
    public function getCurrencyList()
    {
        return $this->currencyList;
    }
    /**
     * Set currencyList value
     * @param \StructType\VendorCurrencyList $currencyList
     * @return \StructType\Vendor
     */
    public function setCurrencyList(\StructType\VendorCurrencyList $currencyList = null)
    {
        $this->currencyList = $currencyList;
        return $this;
    }
    /**
     * Get rolesList value
     * @return \StructType\VendorRolesList|null
     */
    public function getRolesList()
    {
        return $this->rolesList;
    }
    /**
     * Set rolesList value
     * @param \StructType\VendorRolesList $rolesList
     * @return \StructType\Vendor
     */
    public function setRolesList(\StructType\VendorRolesList $rolesList = null)
    {
        $this->rolesList = $rolesList;
        return $this;
    }
    /**
     * Get taxRegistrationList value
     * @return \StructType\VendorTaxRegistrationList|null
     */
    public function getTaxRegistrationList()
    {
        return $this->taxRegistrationList;
    }
    /**
     * Set taxRegistrationList value
     * @param \StructType\VendorTaxRegistrationList $taxRegistrationList
     * @return \StructType\Vendor
     */
    public function setTaxRegistrationList(\StructType\VendorTaxRegistrationList $taxRegistrationList = null)
    {
        $this->taxRegistrationList = $taxRegistrationList;
        return $this;
    }
    /**
     * Get predictedDays value
     * @return int|null
     */
    public function getPredictedDays()
    {
        return $this->predictedDays;
    }
    /**
     * Set predictedDays value
     * @param int $predictedDays
     * @return \StructType\Vendor
     */
    public function setPredictedDays($predictedDays = null)
    {
        // validation for constraint: int
        if (!is_null($predictedDays) && !(is_int($predictedDays) || ctype_digit($predictedDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($predictedDays, true), gettype($predictedDays)), __LINE__);
        }
        $this->predictedDays = $predictedDays;
        return $this;
    }
    /**
     * Get predConfidence value
     * @return float|null
     */
    public function getPredConfidence()
    {
        return $this->predConfidence;
    }
    /**
     * Set predConfidence value
     * @param float $predConfidence
     * @return \StructType\Vendor
     */
    public function setPredConfidence($predConfidence = null)
    {
        // validation for constraint: float
        if (!is_null($predConfidence) && !(is_float($predConfidence) || is_numeric($predConfidence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($predConfidence, true), gettype($predConfidence)), __LINE__);
        }
        $this->predConfidence = $predConfidence;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\Vendor
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Vendor
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Vendor
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
