<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitsTypeUom StructType
 * @subpackage Structs
 */
class UnitsTypeUom extends AbstractStructBase
{
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $internalId;
    /**
     * The unitName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $unitName;
    /**
     * The pluralName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pluralName;
    /**
     * The abbreviation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $abbreviation;
    /**
     * The pluralAbbreviation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pluralAbbreviation;
    /**
     * The conversionRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $conversionRate;
    /**
     * The baseUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $baseUnit;
    /**
     * Constructor method for UnitsTypeUom
     * @uses UnitsTypeUom::setInternalId()
     * @uses UnitsTypeUom::setUnitName()
     * @uses UnitsTypeUom::setPluralName()
     * @uses UnitsTypeUom::setAbbreviation()
     * @uses UnitsTypeUom::setPluralAbbreviation()
     * @uses UnitsTypeUom::setConversionRate()
     * @uses UnitsTypeUom::setBaseUnit()
     * @param string $internalId
     * @param string $unitName
     * @param string $pluralName
     * @param string $abbreviation
     * @param string $pluralAbbreviation
     * @param float $conversionRate
     * @param bool $baseUnit
     */
    public function __construct($internalId = null, $unitName = null, $pluralName = null, $abbreviation = null, $pluralAbbreviation = null, $conversionRate = null, $baseUnit = null)
    {
        $this
            ->setInternalId($internalId)
            ->setUnitName($unitName)
            ->setPluralName($pluralName)
            ->setAbbreviation($abbreviation)
            ->setPluralAbbreviation($pluralAbbreviation)
            ->setConversionRate($conversionRate)
            ->setBaseUnit($baseUnit);
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\UnitsTypeUom
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get unitName value
     * @return string|null
     */
    public function getUnitName()
    {
        return $this->unitName;
    }
    /**
     * Set unitName value
     * @param string $unitName
     * @return \StructType\UnitsTypeUom
     */
    public function setUnitName($unitName = null)
    {
        // validation for constraint: string
        if (!is_null($unitName) && !is_string($unitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitName, true), gettype($unitName)), __LINE__);
        }
        $this->unitName = $unitName;
        return $this;
    }
    /**
     * Get pluralName value
     * @return string|null
     */
    public function getPluralName()
    {
        return $this->pluralName;
    }
    /**
     * Set pluralName value
     * @param string $pluralName
     * @return \StructType\UnitsTypeUom
     */
    public function setPluralName($pluralName = null)
    {
        // validation for constraint: string
        if (!is_null($pluralName) && !is_string($pluralName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pluralName, true), gettype($pluralName)), __LINE__);
        }
        $this->pluralName = $pluralName;
        return $this;
    }
    /**
     * Get abbreviation value
     * @return string|null
     */
    public function getAbbreviation()
    {
        return $this->abbreviation;
    }
    /**
     * Set abbreviation value
     * @param string $abbreviation
     * @return \StructType\UnitsTypeUom
     */
    public function setAbbreviation($abbreviation = null)
    {
        // validation for constraint: string
        if (!is_null($abbreviation) && !is_string($abbreviation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abbreviation, true), gettype($abbreviation)), __LINE__);
        }
        $this->abbreviation = $abbreviation;
        return $this;
    }
    /**
     * Get pluralAbbreviation value
     * @return string|null
     */
    public function getPluralAbbreviation()
    {
        return $this->pluralAbbreviation;
    }
    /**
     * Set pluralAbbreviation value
     * @param string $pluralAbbreviation
     * @return \StructType\UnitsTypeUom
     */
    public function setPluralAbbreviation($pluralAbbreviation = null)
    {
        // validation for constraint: string
        if (!is_null($pluralAbbreviation) && !is_string($pluralAbbreviation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pluralAbbreviation, true), gettype($pluralAbbreviation)), __LINE__);
        }
        $this->pluralAbbreviation = $pluralAbbreviation;
        return $this;
    }
    /**
     * Get conversionRate value
     * @return float|null
     */
    public function getConversionRate()
    {
        return $this->conversionRate;
    }
    /**
     * Set conversionRate value
     * @param float $conversionRate
     * @return \StructType\UnitsTypeUom
     */
    public function setConversionRate($conversionRate = null)
    {
        // validation for constraint: float
        if (!is_null($conversionRate) && !(is_float($conversionRate) || is_numeric($conversionRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($conversionRate, true), gettype($conversionRate)), __LINE__);
        }
        $this->conversionRate = $conversionRate;
        return $this;
    }
    /**
     * Get baseUnit value
     * @return bool|null
     */
    public function getBaseUnit()
    {
        return $this->baseUnit;
    }
    /**
     * Set baseUnit value
     * @param bool $baseUnit
     * @return \StructType\UnitsTypeUom
     */
    public function setBaseUnit($baseUnit = null)
    {
        // validation for constraint: boolean
        if (!is_null($baseUnit) && !is_bool($baseUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($baseUnit, true), gettype($baseUnit)), __LINE__);
        }
        $this->baseUnit = $baseUnit;
        return $this;
    }
}
