<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Translation StructType
 * @subpackage Structs
 */
class Translation extends AbstractStructBase
{
    /**
     * The locale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $locale;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $language;
    /**
     * The displayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $displayName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The salesDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $salesDescription;
    /**
     * The storeDisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $storeDisplayName;
    /**
     * The storeDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $storeDescription;
    /**
     * The storeDetailedDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $storeDetailedDescription;
    /**
     * The featuredDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $featuredDescription;
    /**
     * The specialsDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $specialsDescription;
    /**
     * The pageTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pageTitle;
    /**
     * The noPriceMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $noPriceMessage;
    /**
     * The outOfStockMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outOfStockMessage;
    /**
     * Constructor method for Translation
     * @uses Translation::setLocale()
     * @uses Translation::setLanguage()
     * @uses Translation::setDisplayName()
     * @uses Translation::setDescription()
     * @uses Translation::setSalesDescription()
     * @uses Translation::setStoreDisplayName()
     * @uses Translation::setStoreDescription()
     * @uses Translation::setStoreDetailedDescription()
     * @uses Translation::setFeaturedDescription()
     * @uses Translation::setSpecialsDescription()
     * @uses Translation::setPageTitle()
     * @uses Translation::setNoPriceMessage()
     * @uses Translation::setOutOfStockMessage()
     * @param string $locale
     * @param string $language
     * @param string $displayName
     * @param string $description
     * @param string $salesDescription
     * @param string $storeDisplayName
     * @param string $storeDescription
     * @param string $storeDetailedDescription
     * @param string $featuredDescription
     * @param string $specialsDescription
     * @param string $pageTitle
     * @param string $noPriceMessage
     * @param string $outOfStockMessage
     */
    public function __construct($locale = null, $language = null, $displayName = null, $description = null, $salesDescription = null, $storeDisplayName = null, $storeDescription = null, $storeDetailedDescription = null, $featuredDescription = null, $specialsDescription = null, $pageTitle = null, $noPriceMessage = null, $outOfStockMessage = null)
    {
        $this
            ->setLocale($locale)
            ->setLanguage($language)
            ->setDisplayName($displayName)
            ->setDescription($description)
            ->setSalesDescription($salesDescription)
            ->setStoreDisplayName($storeDisplayName)
            ->setStoreDescription($storeDescription)
            ->setStoreDetailedDescription($storeDetailedDescription)
            ->setFeaturedDescription($featuredDescription)
            ->setSpecialsDescription($specialsDescription)
            ->setPageTitle($pageTitle)
            ->setNoPriceMessage($noPriceMessage)
            ->setOutOfStockMessage($outOfStockMessage);
    }
    /**
     * Get locale value
     * @return string|null
     */
    public function getLocale()
    {
        return $this->locale;
    }
    /**
     * Set locale value
     * @uses \EnumType\Language::valueIsValid()
     * @uses \EnumType\Language::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $locale
     * @return \StructType\Translation
     */
    public function setLocale($locale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Language::valueIsValid($locale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Language', is_array($locale) ? implode(', ', $locale) : var_export($locale, true), implode(', ', \EnumType\Language::getValidValues())), __LINE__);
        }
        $this->locale = $locale;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\Translation
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get displayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * Set displayName value
     * @param string $displayName
     * @return \StructType\Translation
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->displayName = $displayName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Translation
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get salesDescription value
     * @return string|null
     */
    public function getSalesDescription()
    {
        return $this->salesDescription;
    }
    /**
     * Set salesDescription value
     * @param string $salesDescription
     * @return \StructType\Translation
     */
    public function setSalesDescription($salesDescription = null)
    {
        // validation for constraint: string
        if (!is_null($salesDescription) && !is_string($salesDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesDescription, true), gettype($salesDescription)), __LINE__);
        }
        $this->salesDescription = $salesDescription;
        return $this;
    }
    /**
     * Get storeDisplayName value
     * @return string|null
     */
    public function getStoreDisplayName()
    {
        return $this->storeDisplayName;
    }
    /**
     * Set storeDisplayName value
     * @param string $storeDisplayName
     * @return \StructType\Translation
     */
    public function setStoreDisplayName($storeDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($storeDisplayName) && !is_string($storeDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeDisplayName, true), gettype($storeDisplayName)), __LINE__);
        }
        $this->storeDisplayName = $storeDisplayName;
        return $this;
    }
    /**
     * Get storeDescription value
     * @return string|null
     */
    public function getStoreDescription()
    {
        return $this->storeDescription;
    }
    /**
     * Set storeDescription value
     * @param string $storeDescription
     * @return \StructType\Translation
     */
    public function setStoreDescription($storeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($storeDescription) && !is_string($storeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeDescription, true), gettype($storeDescription)), __LINE__);
        }
        $this->storeDescription = $storeDescription;
        return $this;
    }
    /**
     * Get storeDetailedDescription value
     * @return string|null
     */
    public function getStoreDetailedDescription()
    {
        return $this->storeDetailedDescription;
    }
    /**
     * Set storeDetailedDescription value
     * @param string $storeDetailedDescription
     * @return \StructType\Translation
     */
    public function setStoreDetailedDescription($storeDetailedDescription = null)
    {
        // validation for constraint: string
        if (!is_null($storeDetailedDescription) && !is_string($storeDetailedDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeDetailedDescription, true), gettype($storeDetailedDescription)), __LINE__);
        }
        $this->storeDetailedDescription = $storeDetailedDescription;
        return $this;
    }
    /**
     * Get featuredDescription value
     * @return string|null
     */
    public function getFeaturedDescription()
    {
        return $this->featuredDescription;
    }
    /**
     * Set featuredDescription value
     * @param string $featuredDescription
     * @return \StructType\Translation
     */
    public function setFeaturedDescription($featuredDescription = null)
    {
        // validation for constraint: string
        if (!is_null($featuredDescription) && !is_string($featuredDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($featuredDescription, true), gettype($featuredDescription)), __LINE__);
        }
        $this->featuredDescription = $featuredDescription;
        return $this;
    }
    /**
     * Get specialsDescription value
     * @return string|null
     */
    public function getSpecialsDescription()
    {
        return $this->specialsDescription;
    }
    /**
     * Set specialsDescription value
     * @param string $specialsDescription
     * @return \StructType\Translation
     */
    public function setSpecialsDescription($specialsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($specialsDescription) && !is_string($specialsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialsDescription, true), gettype($specialsDescription)), __LINE__);
        }
        $this->specialsDescription = $specialsDescription;
        return $this;
    }
    /**
     * Get pageTitle value
     * @return string|null
     */
    public function getPageTitle()
    {
        return $this->pageTitle;
    }
    /**
     * Set pageTitle value
     * @param string $pageTitle
     * @return \StructType\Translation
     */
    public function setPageTitle($pageTitle = null)
    {
        // validation for constraint: string
        if (!is_null($pageTitle) && !is_string($pageTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pageTitle, true), gettype($pageTitle)), __LINE__);
        }
        $this->pageTitle = $pageTitle;
        return $this;
    }
    /**
     * Get noPriceMessage value
     * @return string|null
     */
    public function getNoPriceMessage()
    {
        return $this->noPriceMessage;
    }
    /**
     * Set noPriceMessage value
     * @param string $noPriceMessage
     * @return \StructType\Translation
     */
    public function setNoPriceMessage($noPriceMessage = null)
    {
        // validation for constraint: string
        if (!is_null($noPriceMessage) && !is_string($noPriceMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noPriceMessage, true), gettype($noPriceMessage)), __LINE__);
        }
        $this->noPriceMessage = $noPriceMessage;
        return $this;
    }
    /**
     * Get outOfStockMessage value
     * @return string|null
     */
    public function getOutOfStockMessage()
    {
        return $this->outOfStockMessage;
    }
    /**
     * Set outOfStockMessage value
     * @param string $outOfStockMessage
     * @return \StructType\Translation
     */
    public function setOutOfStockMessage($outOfStockMessage = null)
    {
        // validation for constraint: string
        if (!is_null($outOfStockMessage) && !is_string($outOfStockMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outOfStockMessage, true), gettype($outOfStockMessage)), __LINE__);
        }
        $this->outOfStockMessage = $outOfStockMessage;
        return $this;
    }
}
