<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionShipGroup StructType
 * @subpackage Structs
 */
class TransactionShipGroup extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The isFulfilled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isFulfilled;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $weight;
    /**
     * The sourceAddressRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $sourceAddressRef;
    /**
     * The sourceAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sourceAddress;
    /**
     * The destinationAddressRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $destinationAddressRef;
    /**
     * The destinationAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $destinationAddress;
    /**
     * The shippingMethodRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shippingMethodRef;
    /**
     * The shippingMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shippingMethod;
    /**
     * The isHandlingTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isHandlingTaxable;
    /**
     * The handlingTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $handlingTaxCode;
    /**
     * The handlingTaxRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $handlingTaxRate;
    /**
     * The handlingTax2Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $handlingTax2Rate;
    /**
     * The handlingRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $handlingRate;
    /**
     * The handlingTaxAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $handlingTaxAmt;
    /**
     * The handlingTax2Amt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $handlingTax2Amt;
    /**
     * The isShippingTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isShippingTaxable;
    /**
     * The shippingTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shippingTaxCode;
    /**
     * The shippingTaxRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shippingTaxRate;
    /**
     * The shippingTax2Rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shippingTax2Rate;
    /**
     * The shippingRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shippingRate;
    /**
     * The shippingTaxAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shippingTaxAmt;
    /**
     * The shippingTax2Amt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shippingTax2Amt;
    /**
     * Constructor method for TransactionShipGroup
     * @uses TransactionShipGroup::setId()
     * @uses TransactionShipGroup::setIsFulfilled()
     * @uses TransactionShipGroup::setWeight()
     * @uses TransactionShipGroup::setSourceAddressRef()
     * @uses TransactionShipGroup::setSourceAddress()
     * @uses TransactionShipGroup::setDestinationAddressRef()
     * @uses TransactionShipGroup::setDestinationAddress()
     * @uses TransactionShipGroup::setShippingMethodRef()
     * @uses TransactionShipGroup::setShippingMethod()
     * @uses TransactionShipGroup::setIsHandlingTaxable()
     * @uses TransactionShipGroup::setHandlingTaxCode()
     * @uses TransactionShipGroup::setHandlingTaxRate()
     * @uses TransactionShipGroup::setHandlingTax2Rate()
     * @uses TransactionShipGroup::setHandlingRate()
     * @uses TransactionShipGroup::setHandlingTaxAmt()
     * @uses TransactionShipGroup::setHandlingTax2Amt()
     * @uses TransactionShipGroup::setIsShippingTaxable()
     * @uses TransactionShipGroup::setShippingTaxCode()
     * @uses TransactionShipGroup::setShippingTaxRate()
     * @uses TransactionShipGroup::setShippingTax2Rate()
     * @uses TransactionShipGroup::setShippingRate()
     * @uses TransactionShipGroup::setShippingTaxAmt()
     * @uses TransactionShipGroup::setShippingTax2Amt()
     * @param int $id
     * @param bool $isFulfilled
     * @param float $weight
     * @param \StructType\RecordRef $sourceAddressRef
     * @param string $sourceAddress
     * @param \StructType\RecordRef $destinationAddressRef
     * @param string $destinationAddress
     * @param \StructType\RecordRef $shippingMethodRef
     * @param string $shippingMethod
     * @param bool $isHandlingTaxable
     * @param \StructType\RecordRef $handlingTaxCode
     * @param string $handlingTaxRate
     * @param string $handlingTax2Rate
     * @param float $handlingRate
     * @param float $handlingTaxAmt
     * @param float $handlingTax2Amt
     * @param bool $isShippingTaxable
     * @param \StructType\RecordRef $shippingTaxCode
     * @param string $shippingTaxRate
     * @param string $shippingTax2Rate
     * @param float $shippingRate
     * @param float $shippingTaxAmt
     * @param float $shippingTax2Amt
     */
    public function __construct($id = null, $isFulfilled = null, $weight = null, \StructType\RecordRef $sourceAddressRef = null, $sourceAddress = null, \StructType\RecordRef $destinationAddressRef = null, $destinationAddress = null, \StructType\RecordRef $shippingMethodRef = null, $shippingMethod = null, $isHandlingTaxable = null, \StructType\RecordRef $handlingTaxCode = null, $handlingTaxRate = null, $handlingTax2Rate = null, $handlingRate = null, $handlingTaxAmt = null, $handlingTax2Amt = null, $isShippingTaxable = null, \StructType\RecordRef $shippingTaxCode = null, $shippingTaxRate = null, $shippingTax2Rate = null, $shippingRate = null, $shippingTaxAmt = null, $shippingTax2Amt = null)
    {
        $this
            ->setId($id)
            ->setIsFulfilled($isFulfilled)
            ->setWeight($weight)
            ->setSourceAddressRef($sourceAddressRef)
            ->setSourceAddress($sourceAddress)
            ->setDestinationAddressRef($destinationAddressRef)
            ->setDestinationAddress($destinationAddress)
            ->setShippingMethodRef($shippingMethodRef)
            ->setShippingMethod($shippingMethod)
            ->setIsHandlingTaxable($isHandlingTaxable)
            ->setHandlingTaxCode($handlingTaxCode)
            ->setHandlingTaxRate($handlingTaxRate)
            ->setHandlingTax2Rate($handlingTax2Rate)
            ->setHandlingRate($handlingRate)
            ->setHandlingTaxAmt($handlingTaxAmt)
            ->setHandlingTax2Amt($handlingTax2Amt)
            ->setIsShippingTaxable($isShippingTaxable)
            ->setShippingTaxCode($shippingTaxCode)
            ->setShippingTaxRate($shippingTaxRate)
            ->setShippingTax2Rate($shippingTax2Rate)
            ->setShippingRate($shippingRate)
            ->setShippingTaxAmt($shippingTaxAmt)
            ->setShippingTax2Amt($shippingTax2Amt);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\TransactionShipGroup
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get isFulfilled value
     * @return bool|null
     */
    public function getIsFulfilled()
    {
        return $this->isFulfilled;
    }
    /**
     * Set isFulfilled value
     * @param bool $isFulfilled
     * @return \StructType\TransactionShipGroup
     */
    public function setIsFulfilled($isFulfilled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFulfilled) && !is_bool($isFulfilled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFulfilled, true), gettype($isFulfilled)), __LINE__);
        }
        $this->isFulfilled = $isFulfilled;
        return $this;
    }
    /**
     * Get weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \StructType\TransactionShipGroup
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get sourceAddressRef value
     * @return \StructType\RecordRef|null
     */
    public function getSourceAddressRef()
    {
        return $this->sourceAddressRef;
    }
    /**
     * Set sourceAddressRef value
     * @param \StructType\RecordRef $sourceAddressRef
     * @return \StructType\TransactionShipGroup
     */
    public function setSourceAddressRef(\StructType\RecordRef $sourceAddressRef = null)
    {
        $this->sourceAddressRef = $sourceAddressRef;
        return $this;
    }
    /**
     * Get sourceAddress value
     * @return string|null
     */
    public function getSourceAddress()
    {
        return $this->sourceAddress;
    }
    /**
     * Set sourceAddress value
     * @param string $sourceAddress
     * @return \StructType\TransactionShipGroup
     */
    public function setSourceAddress($sourceAddress = null)
    {
        // validation for constraint: string
        if (!is_null($sourceAddress) && !is_string($sourceAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceAddress, true), gettype($sourceAddress)), __LINE__);
        }
        $this->sourceAddress = $sourceAddress;
        return $this;
    }
    /**
     * Get destinationAddressRef value
     * @return \StructType\RecordRef|null
     */
    public function getDestinationAddressRef()
    {
        return $this->destinationAddressRef;
    }
    /**
     * Set destinationAddressRef value
     * @param \StructType\RecordRef $destinationAddressRef
     * @return \StructType\TransactionShipGroup
     */
    public function setDestinationAddressRef(\StructType\RecordRef $destinationAddressRef = null)
    {
        $this->destinationAddressRef = $destinationAddressRef;
        return $this;
    }
    /**
     * Get destinationAddress value
     * @return string|null
     */
    public function getDestinationAddress()
    {
        return $this->destinationAddress;
    }
    /**
     * Set destinationAddress value
     * @param string $destinationAddress
     * @return \StructType\TransactionShipGroup
     */
    public function setDestinationAddress($destinationAddress = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAddress) && !is_string($destinationAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationAddress, true), gettype($destinationAddress)), __LINE__);
        }
        $this->destinationAddress = $destinationAddress;
        return $this;
    }
    /**
     * Get shippingMethodRef value
     * @return \StructType\RecordRef|null
     */
    public function getShippingMethodRef()
    {
        return $this->shippingMethodRef;
    }
    /**
     * Set shippingMethodRef value
     * @param \StructType\RecordRef $shippingMethodRef
     * @return \StructType\TransactionShipGroup
     */
    public function setShippingMethodRef(\StructType\RecordRef $shippingMethodRef = null)
    {
        $this->shippingMethodRef = $shippingMethodRef;
        return $this;
    }
    /**
     * Get shippingMethod value
     * @return string|null
     */
    public function getShippingMethod()
    {
        return $this->shippingMethod;
    }
    /**
     * Set shippingMethod value
     * @param string $shippingMethod
     * @return \StructType\TransactionShipGroup
     */
    public function setShippingMethod($shippingMethod = null)
    {
        // validation for constraint: string
        if (!is_null($shippingMethod) && !is_string($shippingMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingMethod, true), gettype($shippingMethod)), __LINE__);
        }
        $this->shippingMethod = $shippingMethod;
        return $this;
    }
    /**
     * Get isHandlingTaxable value
     * @return bool|null
     */
    public function getIsHandlingTaxable()
    {
        return $this->isHandlingTaxable;
    }
    /**
     * Set isHandlingTaxable value
     * @param bool $isHandlingTaxable
     * @return \StructType\TransactionShipGroup
     */
    public function setIsHandlingTaxable($isHandlingTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHandlingTaxable) && !is_bool($isHandlingTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHandlingTaxable, true), gettype($isHandlingTaxable)), __LINE__);
        }
        $this->isHandlingTaxable = $isHandlingTaxable;
        return $this;
    }
    /**
     * Get handlingTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getHandlingTaxCode()
    {
        return $this->handlingTaxCode;
    }
    /**
     * Set handlingTaxCode value
     * @param \StructType\RecordRef $handlingTaxCode
     * @return \StructType\TransactionShipGroup
     */
    public function setHandlingTaxCode(\StructType\RecordRef $handlingTaxCode = null)
    {
        $this->handlingTaxCode = $handlingTaxCode;
        return $this;
    }
    /**
     * Get handlingTaxRate value
     * @return string|null
     */
    public function getHandlingTaxRate()
    {
        return $this->handlingTaxRate;
    }
    /**
     * Set handlingTaxRate value
     * @param string $handlingTaxRate
     * @return \StructType\TransactionShipGroup
     */
    public function setHandlingTaxRate($handlingTaxRate = null)
    {
        // validation for constraint: string
        if (!is_null($handlingTaxRate) && !is_string($handlingTaxRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handlingTaxRate, true), gettype($handlingTaxRate)), __LINE__);
        }
        $this->handlingTaxRate = $handlingTaxRate;
        return $this;
    }
    /**
     * Get handlingTax2Rate value
     * @return string|null
     */
    public function getHandlingTax2Rate()
    {
        return $this->handlingTax2Rate;
    }
    /**
     * Set handlingTax2Rate value
     * @param string $handlingTax2Rate
     * @return \StructType\TransactionShipGroup
     */
    public function setHandlingTax2Rate($handlingTax2Rate = null)
    {
        // validation for constraint: string
        if (!is_null($handlingTax2Rate) && !is_string($handlingTax2Rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handlingTax2Rate, true), gettype($handlingTax2Rate)), __LINE__);
        }
        $this->handlingTax2Rate = $handlingTax2Rate;
        return $this;
    }
    /**
     * Get handlingRate value
     * @return float|null
     */
    public function getHandlingRate()
    {
        return $this->handlingRate;
    }
    /**
     * Set handlingRate value
     * @param float $handlingRate
     * @return \StructType\TransactionShipGroup
     */
    public function setHandlingRate($handlingRate = null)
    {
        // validation for constraint: float
        if (!is_null($handlingRate) && !(is_float($handlingRate) || is_numeric($handlingRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($handlingRate, true), gettype($handlingRate)), __LINE__);
        }
        $this->handlingRate = $handlingRate;
        return $this;
    }
    /**
     * Get handlingTaxAmt value
     * @return float|null
     */
    public function getHandlingTaxAmt()
    {
        return $this->handlingTaxAmt;
    }
    /**
     * Set handlingTaxAmt value
     * @param float $handlingTaxAmt
     * @return \StructType\TransactionShipGroup
     */
    public function setHandlingTaxAmt($handlingTaxAmt = null)
    {
        // validation for constraint: float
        if (!is_null($handlingTaxAmt) && !(is_float($handlingTaxAmt) || is_numeric($handlingTaxAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($handlingTaxAmt, true), gettype($handlingTaxAmt)), __LINE__);
        }
        $this->handlingTaxAmt = $handlingTaxAmt;
        return $this;
    }
    /**
     * Get handlingTax2Amt value
     * @return float|null
     */
    public function getHandlingTax2Amt()
    {
        return $this->handlingTax2Amt;
    }
    /**
     * Set handlingTax2Amt value
     * @param float $handlingTax2Amt
     * @return \StructType\TransactionShipGroup
     */
    public function setHandlingTax2Amt($handlingTax2Amt = null)
    {
        // validation for constraint: float
        if (!is_null($handlingTax2Amt) && !(is_float($handlingTax2Amt) || is_numeric($handlingTax2Amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($handlingTax2Amt, true), gettype($handlingTax2Amt)), __LINE__);
        }
        $this->handlingTax2Amt = $handlingTax2Amt;
        return $this;
    }
    /**
     * Get isShippingTaxable value
     * @return bool|null
     */
    public function getIsShippingTaxable()
    {
        return $this->isShippingTaxable;
    }
    /**
     * Set isShippingTaxable value
     * @param bool $isShippingTaxable
     * @return \StructType\TransactionShipGroup
     */
    public function setIsShippingTaxable($isShippingTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isShippingTaxable) && !is_bool($isShippingTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isShippingTaxable, true), gettype($isShippingTaxable)), __LINE__);
        }
        $this->isShippingTaxable = $isShippingTaxable;
        return $this;
    }
    /**
     * Get shippingTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getShippingTaxCode()
    {
        return $this->shippingTaxCode;
    }
    /**
     * Set shippingTaxCode value
     * @param \StructType\RecordRef $shippingTaxCode
     * @return \StructType\TransactionShipGroup
     */
    public function setShippingTaxCode(\StructType\RecordRef $shippingTaxCode = null)
    {
        $this->shippingTaxCode = $shippingTaxCode;
        return $this;
    }
    /**
     * Get shippingTaxRate value
     * @return string|null
     */
    public function getShippingTaxRate()
    {
        return $this->shippingTaxRate;
    }
    /**
     * Set shippingTaxRate value
     * @param string $shippingTaxRate
     * @return \StructType\TransactionShipGroup
     */
    public function setShippingTaxRate($shippingTaxRate = null)
    {
        // validation for constraint: string
        if (!is_null($shippingTaxRate) && !is_string($shippingTaxRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingTaxRate, true), gettype($shippingTaxRate)), __LINE__);
        }
        $this->shippingTaxRate = $shippingTaxRate;
        return $this;
    }
    /**
     * Get shippingTax2Rate value
     * @return string|null
     */
    public function getShippingTax2Rate()
    {
        return $this->shippingTax2Rate;
    }
    /**
     * Set shippingTax2Rate value
     * @param string $shippingTax2Rate
     * @return \StructType\TransactionShipGroup
     */
    public function setShippingTax2Rate($shippingTax2Rate = null)
    {
        // validation for constraint: string
        if (!is_null($shippingTax2Rate) && !is_string($shippingTax2Rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingTax2Rate, true), gettype($shippingTax2Rate)), __LINE__);
        }
        $this->shippingTax2Rate = $shippingTax2Rate;
        return $this;
    }
    /**
     * Get shippingRate value
     * @return float|null
     */
    public function getShippingRate()
    {
        return $this->shippingRate;
    }
    /**
     * Set shippingRate value
     * @param float $shippingRate
     * @return \StructType\TransactionShipGroup
     */
    public function setShippingRate($shippingRate = null)
    {
        // validation for constraint: float
        if (!is_null($shippingRate) && !(is_float($shippingRate) || is_numeric($shippingRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingRate, true), gettype($shippingRate)), __LINE__);
        }
        $this->shippingRate = $shippingRate;
        return $this;
    }
    /**
     * Get shippingTaxAmt value
     * @return float|null
     */
    public function getShippingTaxAmt()
    {
        return $this->shippingTaxAmt;
    }
    /**
     * Set shippingTaxAmt value
     * @param float $shippingTaxAmt
     * @return \StructType\TransactionShipGroup
     */
    public function setShippingTaxAmt($shippingTaxAmt = null)
    {
        // validation for constraint: float
        if (!is_null($shippingTaxAmt) && !(is_float($shippingTaxAmt) || is_numeric($shippingTaxAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingTaxAmt, true), gettype($shippingTaxAmt)), __LINE__);
        }
        $this->shippingTaxAmt = $shippingTaxAmt;
        return $this;
    }
    /**
     * Get shippingTax2Amt value
     * @return float|null
     */
    public function getShippingTax2Amt()
    {
        return $this->shippingTax2Amt;
    }
    /**
     * Set shippingTax2Amt value
     * @param float $shippingTax2Amt
     * @return \StructType\TransactionShipGroup
     */
    public function setShippingTax2Amt($shippingTax2Amt = null)
    {
        // validation for constraint: float
        if (!is_null($shippingTax2Amt) && !(is_float($shippingTax2Amt) || is_numeric($shippingTax2Amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingTax2Amt, true), gettype($shippingTax2Amt)), __LINE__);
        }
        $this->shippingTax2Amt = $shippingTax2Amt;
        return $this;
    }
}
