<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TopicSolutionList StructType
 * @subpackage Structs
 */
class TopicSolutionList extends AbstractStructBase
{
    /**
     * The solution
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TopicSolution[]
     */
    public $solution;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for TopicSolutionList
     * @uses TopicSolutionList::setSolution()
     * @uses TopicSolutionList::setReplaceAll()
     * @param \StructType\TopicSolution[] $solution
     * @param bool $replaceAll
     */
    public function __construct(array $solution = array(), $replaceAll = true)
    {
        $this
            ->setSolution($solution)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get solution value
     * @return \StructType\TopicSolution[]|null
     */
    public function getSolution()
    {
        return $this->solution;
    }
    /**
     * This method is responsible for validating the values passed to the setSolution method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSolution method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSolutionForArrayConstraintsFromSetSolution(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $topicSolutionListSolutionItem) {
            // validation for constraint: itemType
            if (!$topicSolutionListSolutionItem instanceof \StructType\TopicSolution) {
                $invalidValues[] = is_object($topicSolutionListSolutionItem) ? get_class($topicSolutionListSolutionItem) : sprintf('%s(%s)', gettype($topicSolutionListSolutionItem), var_export($topicSolutionListSolutionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The solution property can only contain items of type \StructType\TopicSolution, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set solution value
     * @throws \InvalidArgumentException
     * @param \StructType\TopicSolution[] $solution
     * @return \StructType\TopicSolutionList
     */
    public function setSolution(array $solution = array())
    {
        // validation for constraint: array
        if ('' !== ($solutionArrayErrorMessage = self::validateSolutionForArrayConstraintsFromSetSolution($solution))) {
            throw new \InvalidArgumentException($solutionArrayErrorMessage, __LINE__);
        }
        $this->solution = $solution;
        return $this;
    }
    /**
     * Add item to solution value
     * @throws \InvalidArgumentException
     * @param \StructType\TopicSolution $item
     * @return \StructType\TopicSolutionList
     */
    public function addToSolution(\StructType\TopicSolution $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TopicSolution) {
            throw new \InvalidArgumentException(sprintf('The solution property can only contain items of type \StructType\TopicSolution, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->solution[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\TopicSolutionList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
