<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeSheetSearchRow StructType
 * @subpackage Structs
 */
class TimeSheetSearchRow extends SearchRow
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TimeSheetSearchRowBasic
     */
    public $basic;
    /**
     * The employeeJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchRowBasic
     */
    public $employeeJoin;
    /**
     * The timeBillJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TimeBillSearchRowBasic
     */
    public $timeBillJoin;
    /**
     * The timeEntryJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TimeEntrySearchRowBasic
     */
    public $timeEntryJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchRowBasic[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for TimeSheetSearchRow
     * @uses TimeSheetSearchRow::setBasic()
     * @uses TimeSheetSearchRow::setEmployeeJoin()
     * @uses TimeSheetSearchRow::setTimeBillJoin()
     * @uses TimeSheetSearchRow::setTimeEntryJoin()
     * @uses TimeSheetSearchRow::setCustomSearchJoin()
     * @param \StructType\TimeSheetSearchRowBasic $basic
     * @param \StructType\EmployeeSearchRowBasic $employeeJoin
     * @param \StructType\TimeBillSearchRowBasic $timeBillJoin
     * @param \StructType\TimeEntrySearchRowBasic $timeEntryJoin
     * @param \StructType\CustomSearchRowBasic[] $customSearchJoin
     */
    public function __construct(\StructType\TimeSheetSearchRowBasic $basic = null, \StructType\EmployeeSearchRowBasic $employeeJoin = null, \StructType\TimeBillSearchRowBasic $timeBillJoin = null, \StructType\TimeEntrySearchRowBasic $timeEntryJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setEmployeeJoin($employeeJoin)
            ->setTimeBillJoin($timeBillJoin)
            ->setTimeEntryJoin($timeEntryJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\TimeSheetSearchRowBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\TimeSheetSearchRowBasic $basic
     * @return \StructType\TimeSheetSearchRow
     */
    public function setBasic(\StructType\TimeSheetSearchRowBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get employeeJoin value
     * @return \StructType\EmployeeSearchRowBasic|null
     */
    public function getEmployeeJoin()
    {
        return $this->employeeJoin;
    }
    /**
     * Set employeeJoin value
     * @param \StructType\EmployeeSearchRowBasic $employeeJoin
     * @return \StructType\TimeSheetSearchRow
     */
    public function setEmployeeJoin(\StructType\EmployeeSearchRowBasic $employeeJoin = null)
    {
        $this->employeeJoin = $employeeJoin;
        return $this;
    }
    /**
     * Get timeBillJoin value
     * @return \StructType\TimeBillSearchRowBasic|null
     */
    public function getTimeBillJoin()
    {
        return $this->timeBillJoin;
    }
    /**
     * Set timeBillJoin value
     * @param \StructType\TimeBillSearchRowBasic $timeBillJoin
     * @return \StructType\TimeSheetSearchRow
     */
    public function setTimeBillJoin(\StructType\TimeBillSearchRowBasic $timeBillJoin = null)
    {
        $this->timeBillJoin = $timeBillJoin;
        return $this;
    }
    /**
     * Get timeEntryJoin value
     * @return \StructType\TimeEntrySearchRowBasic|null
     */
    public function getTimeEntryJoin()
    {
        return $this->timeEntryJoin;
    }
    /**
     * Set timeEntryJoin value
     * @param \StructType\TimeEntrySearchRowBasic $timeEntryJoin
     * @return \StructType\TimeSheetSearchRow
     */
    public function setTimeEntryJoin(\StructType\TimeEntrySearchRowBasic $timeEntryJoin = null)
    {
        $this->timeEntryJoin = $timeEntryJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchRowBasic[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $timeSheetSearchRowCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$timeSheetSearchRowCustomSearchJoinItem instanceof \StructType\CustomSearchRowBasic) {
                $invalidValues[] = is_object($timeSheetSearchRowCustomSearchJoinItem) ? get_class($timeSheetSearchRowCustomSearchJoinItem) : sprintf('%s(%s)', gettype($timeSheetSearchRowCustomSearchJoinItem), var_export($timeSheetSearchRowCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchRowBasic, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchRowBasic[] $customSearchJoin
     * @return \StructType\TimeSheetSearchRow
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchRowBasic $item
     * @return \StructType\TimeSheetSearchRow
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchRowBasic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchRowBasic) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchRowBasic, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
