<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeItem StructType
 * @subpackage Structs
 */
class TimeItem extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The employee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $employee;
    /**
     * The timeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $timeType;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customer;
    /**
     * The isBillable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isBillable;
    /**
     * The payrollItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $payrollItem;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The temporaryLocalJurisdiction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $temporaryLocalJurisdiction;
    /**
     * The temporaryStateJurisdiction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $temporaryStateJurisdiction;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The hours
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Duration
     */
    public $hours;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $price;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $rate;
    /**
     * The overrideRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $overrideRate;
    /**
     * The hoursTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Duration
     */
    public $hoursTotal;
    /**
     * The caseTaskEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $caseTaskEvent;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The isUtilized
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isUtilized;
    /**
     * The isProductive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isProductive;
    /**
     * The isExempt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isExempt;
    /**
     * Constructor method for TimeItem
     * @uses TimeItem::setId()
     * @uses TimeItem::setEmployee()
     * @uses TimeItem::setTimeType()
     * @uses TimeItem::setTranDate()
     * @uses TimeItem::setCustomer()
     * @uses TimeItem::setIsBillable()
     * @uses TimeItem::setPayrollItem()
     * @uses TimeItem::setItem()
     * @uses TimeItem::setTemporaryLocalJurisdiction()
     * @uses TimeItem::setTemporaryStateJurisdiction()
     * @uses TimeItem::setDepartment()
     * @uses TimeItem::setClass()
     * @uses TimeItem::setLocation()
     * @uses TimeItem::setHours()
     * @uses TimeItem::setPrice()
     * @uses TimeItem::setRate()
     * @uses TimeItem::setOverrideRate()
     * @uses TimeItem::setHoursTotal()
     * @uses TimeItem::setCaseTaskEvent()
     * @uses TimeItem::setMemo()
     * @uses TimeItem::setIsUtilized()
     * @uses TimeItem::setIsProductive()
     * @uses TimeItem::setIsExempt()
     * @param int $id
     * @param \StructType\RecordRef $employee
     * @param string $timeType
     * @param string $tranDate
     * @param \StructType\RecordRef $customer
     * @param bool $isBillable
     * @param \StructType\RecordRef $payrollItem
     * @param \StructType\RecordRef $item
     * @param \StructType\RecordRef $temporaryLocalJurisdiction
     * @param \StructType\RecordRef $temporaryStateJurisdiction
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\Duration $hours
     * @param \StructType\RecordRef $price
     * @param float $rate
     * @param bool $overrideRate
     * @param \StructType\Duration $hoursTotal
     * @param \StructType\RecordRef $caseTaskEvent
     * @param string $memo
     * @param bool $isUtilized
     * @param bool $isProductive
     * @param bool $isExempt
     */
    public function __construct($id = null, \StructType\RecordRef $employee = null, $timeType = null, $tranDate = null, \StructType\RecordRef $customer = null, $isBillable = null, \StructType\RecordRef $payrollItem = null, \StructType\RecordRef $item = null, \StructType\RecordRef $temporaryLocalJurisdiction = null, \StructType\RecordRef $temporaryStateJurisdiction = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\Duration $hours = null, \StructType\RecordRef $price = null, $rate = null, $overrideRate = null, \StructType\Duration $hoursTotal = null, \StructType\RecordRef $caseTaskEvent = null, $memo = null, $isUtilized = null, $isProductive = null, $isExempt = null)
    {
        $this
            ->setId($id)
            ->setEmployee($employee)
            ->setTimeType($timeType)
            ->setTranDate($tranDate)
            ->setCustomer($customer)
            ->setIsBillable($isBillable)
            ->setPayrollItem($payrollItem)
            ->setItem($item)
            ->setTemporaryLocalJurisdiction($temporaryLocalJurisdiction)
            ->setTemporaryStateJurisdiction($temporaryStateJurisdiction)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setHours($hours)
            ->setPrice($price)
            ->setRate($rate)
            ->setOverrideRate($overrideRate)
            ->setHoursTotal($hoursTotal)
            ->setCaseTaskEvent($caseTaskEvent)
            ->setMemo($memo)
            ->setIsUtilized($isUtilized)
            ->setIsProductive($isProductive)
            ->setIsExempt($isExempt);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\TimeItem
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get employee value
     * @return \StructType\RecordRef|null
     */
    public function getEmployee()
    {
        return $this->employee;
    }
    /**
     * Set employee value
     * @param \StructType\RecordRef $employee
     * @return \StructType\TimeItem
     */
    public function setEmployee(\StructType\RecordRef $employee = null)
    {
        $this->employee = $employee;
        return $this;
    }
    /**
     * Get timeType value
     * @return string|null
     */
    public function getTimeType()
    {
        return $this->timeType;
    }
    /**
     * Set timeType value
     * @uses \EnumType\TimeItemTimeType::valueIsValid()
     * @uses \EnumType\TimeItemTimeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeType
     * @return \StructType\TimeItem
     */
    public function setTimeType($timeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TimeItemTimeType::valueIsValid($timeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TimeItemTimeType', is_array($timeType) ? implode(', ', $timeType) : var_export($timeType, true), implode(', ', \EnumType\TimeItemTimeType::getValidValues())), __LINE__);
        }
        $this->timeType = $timeType;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\TimeItem
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\RecordRef|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\RecordRef $customer
     * @return \StructType\TimeItem
     */
    public function setCustomer(\StructType\RecordRef $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get isBillable value
     * @return bool|null
     */
    public function getIsBillable()
    {
        return $this->isBillable;
    }
    /**
     * Set isBillable value
     * @param bool $isBillable
     * @return \StructType\TimeItem
     */
    public function setIsBillable($isBillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBillable) && !is_bool($isBillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBillable, true), gettype($isBillable)), __LINE__);
        }
        $this->isBillable = $isBillable;
        return $this;
    }
    /**
     * Get payrollItem value
     * @return \StructType\RecordRef|null
     */
    public function getPayrollItem()
    {
        return $this->payrollItem;
    }
    /**
     * Set payrollItem value
     * @param \StructType\RecordRef $payrollItem
     * @return \StructType\TimeItem
     */
    public function setPayrollItem(\StructType\RecordRef $payrollItem = null)
    {
        $this->payrollItem = $payrollItem;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\TimeItem
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get temporaryLocalJurisdiction value
     * @return \StructType\RecordRef|null
     */
    public function getTemporaryLocalJurisdiction()
    {
        return $this->temporaryLocalJurisdiction;
    }
    /**
     * Set temporaryLocalJurisdiction value
     * @param \StructType\RecordRef $temporaryLocalJurisdiction
     * @return \StructType\TimeItem
     */
    public function setTemporaryLocalJurisdiction(\StructType\RecordRef $temporaryLocalJurisdiction = null)
    {
        $this->temporaryLocalJurisdiction = $temporaryLocalJurisdiction;
        return $this;
    }
    /**
     * Get temporaryStateJurisdiction value
     * @return \StructType\RecordRef|null
     */
    public function getTemporaryStateJurisdiction()
    {
        return $this->temporaryStateJurisdiction;
    }
    /**
     * Set temporaryStateJurisdiction value
     * @param \StructType\RecordRef $temporaryStateJurisdiction
     * @return \StructType\TimeItem
     */
    public function setTemporaryStateJurisdiction(\StructType\RecordRef $temporaryStateJurisdiction = null)
    {
        $this->temporaryStateJurisdiction = $temporaryStateJurisdiction;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\TimeItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\TimeItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\TimeItem
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get hours value
     * @return \StructType\Duration|null
     */
    public function getHours()
    {
        return $this->hours;
    }
    /**
     * Set hours value
     * @param \StructType\Duration $hours
     * @return \StructType\TimeItem
     */
    public function setHours(\StructType\Duration $hours = null)
    {
        $this->hours = $hours;
        return $this;
    }
    /**
     * Get price value
     * @return \StructType\RecordRef|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param \StructType\RecordRef $price
     * @return \StructType\TimeItem
     */
    public function setPrice(\StructType\RecordRef $price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param float $rate
     * @return \StructType\TimeItem
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get overrideRate value
     * @return bool|null
     */
    public function getOverrideRate()
    {
        return $this->overrideRate;
    }
    /**
     * Set overrideRate value
     * @param bool $overrideRate
     * @return \StructType\TimeItem
     */
    public function setOverrideRate($overrideRate = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrideRate) && !is_bool($overrideRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overrideRate, true), gettype($overrideRate)), __LINE__);
        }
        $this->overrideRate = $overrideRate;
        return $this;
    }
    /**
     * Get hoursTotal value
     * @return \StructType\Duration|null
     */
    public function getHoursTotal()
    {
        return $this->hoursTotal;
    }
    /**
     * Set hoursTotal value
     * @param \StructType\Duration $hoursTotal
     * @return \StructType\TimeItem
     */
    public function setHoursTotal(\StructType\Duration $hoursTotal = null)
    {
        $this->hoursTotal = $hoursTotal;
        return $this;
    }
    /**
     * Get caseTaskEvent value
     * @return \StructType\RecordRef|null
     */
    public function getCaseTaskEvent()
    {
        return $this->caseTaskEvent;
    }
    /**
     * Set caseTaskEvent value
     * @param \StructType\RecordRef $caseTaskEvent
     * @return \StructType\TimeItem
     */
    public function setCaseTaskEvent(\StructType\RecordRef $caseTaskEvent = null)
    {
        $this->caseTaskEvent = $caseTaskEvent;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\TimeItem
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get isUtilized value
     * @return bool|null
     */
    public function getIsUtilized()
    {
        return $this->isUtilized;
    }
    /**
     * Set isUtilized value
     * @param bool $isUtilized
     * @return \StructType\TimeItem
     */
    public function setIsUtilized($isUtilized = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUtilized) && !is_bool($isUtilized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUtilized, true), gettype($isUtilized)), __LINE__);
        }
        $this->isUtilized = $isUtilized;
        return $this;
    }
    /**
     * Get isProductive value
     * @return bool|null
     */
    public function getIsProductive()
    {
        return $this->isProductive;
    }
    /**
     * Set isProductive value
     * @param bool $isProductive
     * @return \StructType\TimeItem
     */
    public function setIsProductive($isProductive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isProductive) && !is_bool($isProductive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isProductive, true), gettype($isProductive)), __LINE__);
        }
        $this->isProductive = $isProductive;
        return $this;
    }
    /**
     * Get isExempt value
     * @return bool|null
     */
    public function getIsExempt()
    {
        return $this->isExempt;
    }
    /**
     * Set isExempt value
     * @param bool $isExempt
     * @return \StructType\TimeItem
     */
    public function setIsExempt($isExempt = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExempt) && !is_bool($isExempt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExempt, true), gettype($isExempt)), __LINE__);
        }
        $this->isExempt = $isExempt;
        return $this;
    }
}
