<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeBill StructType
 * Meta information extracted from the WSDL
 * - type: tranEmp:TimeBill
 * @subpackage Structs
 */
class TimeBill extends Record
{
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The employee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $employee;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The approvalStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $approvalStatus;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customer;
    /**
     * The caseTaskEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $caseTaskEvent;
    /**
     * The isBillable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isBillable;
    /**
     * The payrollItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $payrollItem;
    /**
     * The paidExternally
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $paidExternally;
    /**
     * The workplace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $workplace;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The hours
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Duration
     */
    public $hours;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $price;
    /**
     * The timeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $timeType;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $rate;
    /**
     * The overrideRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $overrideRate;
    /**
     * The temporaryLocalJurisdiction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $temporaryLocalJurisdiction;
    /**
     * The temporaryStateJurisdiction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $temporaryStateJurisdiction;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The rejectionNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rejectionNote;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The supervisorApproval
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $supervisorApproval;
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The timeSheet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $timeSheet;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The timeModified
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $timeModified;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for TimeBill
     * @uses TimeBill::setCustomForm()
     * @uses TimeBill::setEmployee()
     * @uses TimeBill::setTranDate()
     * @uses TimeBill::setApprovalStatus()
     * @uses TimeBill::setCustomer()
     * @uses TimeBill::setCaseTaskEvent()
     * @uses TimeBill::setIsBillable()
     * @uses TimeBill::setPayrollItem()
     * @uses TimeBill::setPaidExternally()
     * @uses TimeBill::setWorkplace()
     * @uses TimeBill::setItem()
     * @uses TimeBill::setDepartment()
     * @uses TimeBill::setClass()
     * @uses TimeBill::setLocation()
     * @uses TimeBill::setHours()
     * @uses TimeBill::setPrice()
     * @uses TimeBill::setTimeType()
     * @uses TimeBill::setRate()
     * @uses TimeBill::setOverrideRate()
     * @uses TimeBill::setTemporaryLocalJurisdiction()
     * @uses TimeBill::setTemporaryStateJurisdiction()
     * @uses TimeBill::setMemo()
     * @uses TimeBill::setRejectionNote()
     * @uses TimeBill::setSubsidiary()
     * @uses TimeBill::setSupervisorApproval()
     * @uses TimeBill::setCreatedDate()
     * @uses TimeBill::setLastModifiedDate()
     * @uses TimeBill::setTimeSheet()
     * @uses TimeBill::setStatus()
     * @uses TimeBill::setTimeModified()
     * @uses TimeBill::setCustomFieldList()
     * @uses TimeBill::setInternalId()
     * @uses TimeBill::setExternalId()
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $employee
     * @param string $tranDate
     * @param \StructType\RecordRef $approvalStatus
     * @param \StructType\RecordRef $customer
     * @param \StructType\RecordRef $caseTaskEvent
     * @param bool $isBillable
     * @param \StructType\RecordRef $payrollItem
     * @param bool $paidExternally
     * @param \StructType\RecordRef $workplace
     * @param \StructType\RecordRef $item
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\Duration $hours
     * @param \StructType\RecordRef $price
     * @param string $timeType
     * @param float $rate
     * @param bool $overrideRate
     * @param \StructType\RecordRef $temporaryLocalJurisdiction
     * @param \StructType\RecordRef $temporaryStateJurisdiction
     * @param string $memo
     * @param string $rejectionNote
     * @param \StructType\RecordRef $subsidiary
     * @param bool $supervisorApproval
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $timeSheet
     * @param string $status
     * @param bool $timeModified
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $customForm = null, \StructType\RecordRef $employee = null, $tranDate = null, \StructType\RecordRef $approvalStatus = null, \StructType\RecordRef $customer = null, \StructType\RecordRef $caseTaskEvent = null, $isBillable = null, \StructType\RecordRef $payrollItem = null, $paidExternally = null, \StructType\RecordRef $workplace = null, \StructType\RecordRef $item = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\Duration $hours = null, \StructType\RecordRef $price = null, $timeType = null, $rate = null, $overrideRate = null, \StructType\RecordRef $temporaryLocalJurisdiction = null, \StructType\RecordRef $temporaryStateJurisdiction = null, $memo = null, $rejectionNote = null, \StructType\RecordRef $subsidiary = null, $supervisorApproval = null, $createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $timeSheet = null, $status = null, $timeModified = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCustomForm($customForm)
            ->setEmployee($employee)
            ->setTranDate($tranDate)
            ->setApprovalStatus($approvalStatus)
            ->setCustomer($customer)
            ->setCaseTaskEvent($caseTaskEvent)
            ->setIsBillable($isBillable)
            ->setPayrollItem($payrollItem)
            ->setPaidExternally($paidExternally)
            ->setWorkplace($workplace)
            ->setItem($item)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setHours($hours)
            ->setPrice($price)
            ->setTimeType($timeType)
            ->setRate($rate)
            ->setOverrideRate($overrideRate)
            ->setTemporaryLocalJurisdiction($temporaryLocalJurisdiction)
            ->setTemporaryStateJurisdiction($temporaryStateJurisdiction)
            ->setMemo($memo)
            ->setRejectionNote($rejectionNote)
            ->setSubsidiary($subsidiary)
            ->setSupervisorApproval($supervisorApproval)
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setTimeSheet($timeSheet)
            ->setStatus($status)
            ->setTimeModified($timeModified)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\TimeBill
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get employee value
     * @return \StructType\RecordRef|null
     */
    public function getEmployee()
    {
        return $this->employee;
    }
    /**
     * Set employee value
     * @param \StructType\RecordRef $employee
     * @return \StructType\TimeBill
     */
    public function setEmployee(\StructType\RecordRef $employee = null)
    {
        $this->employee = $employee;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\TimeBill
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get approvalStatus value
     * @return \StructType\RecordRef|null
     */
    public function getApprovalStatus()
    {
        return $this->approvalStatus;
    }
    /**
     * Set approvalStatus value
     * @param \StructType\RecordRef $approvalStatus
     * @return \StructType\TimeBill
     */
    public function setApprovalStatus(\StructType\RecordRef $approvalStatus = null)
    {
        $this->approvalStatus = $approvalStatus;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\RecordRef|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\RecordRef $customer
     * @return \StructType\TimeBill
     */
    public function setCustomer(\StructType\RecordRef $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get caseTaskEvent value
     * @return \StructType\RecordRef|null
     */
    public function getCaseTaskEvent()
    {
        return $this->caseTaskEvent;
    }
    /**
     * Set caseTaskEvent value
     * @param \StructType\RecordRef $caseTaskEvent
     * @return \StructType\TimeBill
     */
    public function setCaseTaskEvent(\StructType\RecordRef $caseTaskEvent = null)
    {
        $this->caseTaskEvent = $caseTaskEvent;
        return $this;
    }
    /**
     * Get isBillable value
     * @return bool|null
     */
    public function getIsBillable()
    {
        return $this->isBillable;
    }
    /**
     * Set isBillable value
     * @param bool $isBillable
     * @return \StructType\TimeBill
     */
    public function setIsBillable($isBillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBillable) && !is_bool($isBillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBillable, true), gettype($isBillable)), __LINE__);
        }
        $this->isBillable = $isBillable;
        return $this;
    }
    /**
     * Get payrollItem value
     * @return \StructType\RecordRef|null
     */
    public function getPayrollItem()
    {
        return $this->payrollItem;
    }
    /**
     * Set payrollItem value
     * @param \StructType\RecordRef $payrollItem
     * @return \StructType\TimeBill
     */
    public function setPayrollItem(\StructType\RecordRef $payrollItem = null)
    {
        $this->payrollItem = $payrollItem;
        return $this;
    }
    /**
     * Get paidExternally value
     * @return bool|null
     */
    public function getPaidExternally()
    {
        return $this->paidExternally;
    }
    /**
     * Set paidExternally value
     * @param bool $paidExternally
     * @return \StructType\TimeBill
     */
    public function setPaidExternally($paidExternally = null)
    {
        // validation for constraint: boolean
        if (!is_null($paidExternally) && !is_bool($paidExternally)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paidExternally, true), gettype($paidExternally)), __LINE__);
        }
        $this->paidExternally = $paidExternally;
        return $this;
    }
    /**
     * Get workplace value
     * @return \StructType\RecordRef|null
     */
    public function getWorkplace()
    {
        return $this->workplace;
    }
    /**
     * Set workplace value
     * @param \StructType\RecordRef $workplace
     * @return \StructType\TimeBill
     */
    public function setWorkplace(\StructType\RecordRef $workplace = null)
    {
        $this->workplace = $workplace;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\TimeBill
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\TimeBill
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\TimeBill
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\TimeBill
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get hours value
     * @return \StructType\Duration|null
     */
    public function getHours()
    {
        return $this->hours;
    }
    /**
     * Set hours value
     * @param \StructType\Duration $hours
     * @return \StructType\TimeBill
     */
    public function setHours(\StructType\Duration $hours = null)
    {
        $this->hours = $hours;
        return $this;
    }
    /**
     * Get price value
     * @return \StructType\RecordRef|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param \StructType\RecordRef $price
     * @return \StructType\TimeBill
     */
    public function setPrice(\StructType\RecordRef $price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get timeType value
     * @return string|null
     */
    public function getTimeType()
    {
        return $this->timeType;
    }
    /**
     * Set timeType value
     * @uses \EnumType\TimeBillTimeType::valueIsValid()
     * @uses \EnumType\TimeBillTimeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeType
     * @return \StructType\TimeBill
     */
    public function setTimeType($timeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TimeBillTimeType::valueIsValid($timeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TimeBillTimeType', is_array($timeType) ? implode(', ', $timeType) : var_export($timeType, true), implode(', ', \EnumType\TimeBillTimeType::getValidValues())), __LINE__);
        }
        $this->timeType = $timeType;
        return $this;
    }
    /**
     * Get rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param float $rate
     * @return \StructType\TimeBill
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get overrideRate value
     * @return bool|null
     */
    public function getOverrideRate()
    {
        return $this->overrideRate;
    }
    /**
     * Set overrideRate value
     * @param bool $overrideRate
     * @return \StructType\TimeBill
     */
    public function setOverrideRate($overrideRate = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrideRate) && !is_bool($overrideRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overrideRate, true), gettype($overrideRate)), __LINE__);
        }
        $this->overrideRate = $overrideRate;
        return $this;
    }
    /**
     * Get temporaryLocalJurisdiction value
     * @return \StructType\RecordRef|null
     */
    public function getTemporaryLocalJurisdiction()
    {
        return $this->temporaryLocalJurisdiction;
    }
    /**
     * Set temporaryLocalJurisdiction value
     * @param \StructType\RecordRef $temporaryLocalJurisdiction
     * @return \StructType\TimeBill
     */
    public function setTemporaryLocalJurisdiction(\StructType\RecordRef $temporaryLocalJurisdiction = null)
    {
        $this->temporaryLocalJurisdiction = $temporaryLocalJurisdiction;
        return $this;
    }
    /**
     * Get temporaryStateJurisdiction value
     * @return \StructType\RecordRef|null
     */
    public function getTemporaryStateJurisdiction()
    {
        return $this->temporaryStateJurisdiction;
    }
    /**
     * Set temporaryStateJurisdiction value
     * @param \StructType\RecordRef $temporaryStateJurisdiction
     * @return \StructType\TimeBill
     */
    public function setTemporaryStateJurisdiction(\StructType\RecordRef $temporaryStateJurisdiction = null)
    {
        $this->temporaryStateJurisdiction = $temporaryStateJurisdiction;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\TimeBill
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get rejectionNote value
     * @return string|null
     */
    public function getRejectionNote()
    {
        return $this->rejectionNote;
    }
    /**
     * Set rejectionNote value
     * @param string $rejectionNote
     * @return \StructType\TimeBill
     */
    public function setRejectionNote($rejectionNote = null)
    {
        // validation for constraint: string
        if (!is_null($rejectionNote) && !is_string($rejectionNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rejectionNote, true), gettype($rejectionNote)), __LINE__);
        }
        $this->rejectionNote = $rejectionNote;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\TimeBill
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get supervisorApproval value
     * @return bool|null
     */
    public function getSupervisorApproval()
    {
        return $this->supervisorApproval;
    }
    /**
     * Set supervisorApproval value
     * @param bool $supervisorApproval
     * @return \StructType\TimeBill
     */
    public function setSupervisorApproval($supervisorApproval = null)
    {
        // validation for constraint: boolean
        if (!is_null($supervisorApproval) && !is_bool($supervisorApproval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($supervisorApproval, true), gettype($supervisorApproval)), __LINE__);
        }
        $this->supervisorApproval = $supervisorApproval;
        return $this;
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\TimeBill
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\TimeBill
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get timeSheet value
     * @return \StructType\RecordRef|null
     */
    public function getTimeSheet()
    {
        return $this->timeSheet;
    }
    /**
     * Set timeSheet value
     * @param \StructType\RecordRef $timeSheet
     * @return \StructType\TimeBill
     */
    public function setTimeSheet(\StructType\RecordRef $timeSheet = null)
    {
        $this->timeSheet = $timeSheet;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\TimeBill
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get timeModified value
     * @return bool|null
     */
    public function getTimeModified()
    {
        return $this->timeModified;
    }
    /**
     * Set timeModified value
     * @param bool $timeModified
     * @return \StructType\TimeBill
     */
    public function setTimeModified($timeModified = null)
    {
        // validation for constraint: boolean
        if (!is_null($timeModified) && !is_bool($timeModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($timeModified, true), gettype($timeModified)), __LINE__);
        }
        $this->timeModified = $timeModified;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\TimeBill
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\TimeBill
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\TimeBill
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
