<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TermPercentagesList StructType
 * @subpackage Structs
 */
class TermPercentagesList extends AbstractStructBase
{
    /**
     * The termPercentages
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TermPercentages[]
     */
    public $termPercentages;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for TermPercentagesList
     * @uses TermPercentagesList::setTermPercentages()
     * @uses TermPercentagesList::setReplaceAll()
     * @param \StructType\TermPercentages[] $termPercentages
     * @param bool $replaceAll
     */
    public function __construct(array $termPercentages = array(), $replaceAll = true)
    {
        $this
            ->setTermPercentages($termPercentages)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get termPercentages value
     * @return \StructType\TermPercentages[]|null
     */
    public function getTermPercentages()
    {
        return $this->termPercentages;
    }
    /**
     * This method is responsible for validating the values passed to the setTermPercentages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTermPercentages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTermPercentagesForArrayConstraintsFromSetTermPercentages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $termPercentagesListTermPercentagesItem) {
            // validation for constraint: itemType
            if (!$termPercentagesListTermPercentagesItem instanceof \StructType\TermPercentages) {
                $invalidValues[] = is_object($termPercentagesListTermPercentagesItem) ? get_class($termPercentagesListTermPercentagesItem) : sprintf('%s(%s)', gettype($termPercentagesListTermPercentagesItem), var_export($termPercentagesListTermPercentagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The termPercentages property can only contain items of type \StructType\TermPercentages, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set termPercentages value
     * @throws \InvalidArgumentException
     * @param \StructType\TermPercentages[] $termPercentages
     * @return \StructType\TermPercentagesList
     */
    public function setTermPercentages(array $termPercentages = array())
    {
        // validation for constraint: array
        if ('' !== ($termPercentagesArrayErrorMessage = self::validateTermPercentagesForArrayConstraintsFromSetTermPercentages($termPercentages))) {
            throw new \InvalidArgumentException($termPercentagesArrayErrorMessage, __LINE__);
        }
        $this->termPercentages = $termPercentages;
        return $this;
    }
    /**
     * Add item to termPercentages value
     * @throws \InvalidArgumentException
     * @param \StructType\TermPercentages $item
     * @return \StructType\TermPercentagesList
     */
    public function addToTermPercentages(\StructType\TermPercentages $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TermPercentages) {
            throw new \InvalidArgumentException(sprintf('The termPercentages property can only contain items of type \StructType\TermPercentages, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->termPercentages[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\TermPercentagesList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
