<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TermPercentages StructType
 * @subpackage Structs
 */
class TermPercentages extends AbstractStructBase
{
    /**
     * The percentage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $percentage;
    /**
     * Constructor method for TermPercentages
     * @uses TermPercentages::setPercentage()
     * @param float $percentage
     */
    public function __construct($percentage = null)
    {
        $this
            ->setPercentage($percentage);
    }
    /**
     * Get percentage value
     * @return float|null
     */
    public function getPercentage()
    {
        return $this->percentage;
    }
    /**
     * Set percentage value
     * @param float $percentage
     * @return \StructType\TermPercentages
     */
    public function setPercentage($percentage = null)
    {
        // validation for constraint: float
        if (!is_null($percentage) && !(is_float($percentage) || is_numeric($percentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentage, true), gettype($percentage)), __LINE__);
        }
        $this->percentage = $percentage;
        return $this;
    }
}
