<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Term StructType
 * Meta information extracted from the WSDL
 * - type: listAcct:Term
 * @subpackage Structs
 */
class Term extends Record
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The dateDriven
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $dateDriven;
    /**
     * The daysUntilNetDue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $daysUntilNetDue;
    /**
     * The discountPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountPercent;
    /**
     * The daysUntilExpiry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $daysUntilExpiry;
    /**
     * The dayOfMonthNetDue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $dayOfMonthNetDue;
    /**
     * The dueNextMonthIfWithinDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $dueNextMonthIfWithinDays;
    /**
     * The discountPercentDateDriven
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountPercentDateDriven;
    /**
     * The dayDiscountExpires
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $dayDiscountExpires;
    /**
     * The preferred
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $preferred;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The installment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $installment;
    /**
     * The recurrenceFrequency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $recurrenceFrequency;
    /**
     * The recurrenceCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $recurrenceCount;
    /**
     * The repeatEvery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $repeatEvery;
    /**
     * The splitEvenly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $splitEvenly;
    /**
     * The percentagesList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TermPercentagesList
     */
    public $percentagesList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Term
     * @uses Term::setName()
     * @uses Term::setDateDriven()
     * @uses Term::setDaysUntilNetDue()
     * @uses Term::setDiscountPercent()
     * @uses Term::setDaysUntilExpiry()
     * @uses Term::setDayOfMonthNetDue()
     * @uses Term::setDueNextMonthIfWithinDays()
     * @uses Term::setDiscountPercentDateDriven()
     * @uses Term::setDayDiscountExpires()
     * @uses Term::setPreferred()
     * @uses Term::setIsInactive()
     * @uses Term::setInstallment()
     * @uses Term::setRecurrenceFrequency()
     * @uses Term::setRecurrenceCount()
     * @uses Term::setRepeatEvery()
     * @uses Term::setSplitEvenly()
     * @uses Term::setPercentagesList()
     * @uses Term::setInternalId()
     * @uses Term::setExternalId()
     * @param string $name
     * @param bool $dateDriven
     * @param int $daysUntilNetDue
     * @param float $discountPercent
     * @param int $daysUntilExpiry
     * @param int $dayOfMonthNetDue
     * @param int $dueNextMonthIfWithinDays
     * @param float $discountPercentDateDriven
     * @param int $dayDiscountExpires
     * @param bool $preferred
     * @param bool $isInactive
     * @param bool $installment
     * @param string $recurrenceFrequency
     * @param int $recurrenceCount
     * @param int $repeatEvery
     * @param bool $splitEvenly
     * @param \StructType\TermPercentagesList $percentagesList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($name = null, $dateDriven = null, $daysUntilNetDue = null, $discountPercent = null, $daysUntilExpiry = null, $dayOfMonthNetDue = null, $dueNextMonthIfWithinDays = null, $discountPercentDateDriven = null, $dayDiscountExpires = null, $preferred = null, $isInactive = null, $installment = null, $recurrenceFrequency = null, $recurrenceCount = null, $repeatEvery = null, $splitEvenly = null, \StructType\TermPercentagesList $percentagesList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setName($name)
            ->setDateDriven($dateDriven)
            ->setDaysUntilNetDue($daysUntilNetDue)
            ->setDiscountPercent($discountPercent)
            ->setDaysUntilExpiry($daysUntilExpiry)
            ->setDayOfMonthNetDue($dayOfMonthNetDue)
            ->setDueNextMonthIfWithinDays($dueNextMonthIfWithinDays)
            ->setDiscountPercentDateDriven($discountPercentDateDriven)
            ->setDayDiscountExpires($dayDiscountExpires)
            ->setPreferred($preferred)
            ->setIsInactive($isInactive)
            ->setInstallment($installment)
            ->setRecurrenceFrequency($recurrenceFrequency)
            ->setRecurrenceCount($recurrenceCount)
            ->setRepeatEvery($repeatEvery)
            ->setSplitEvenly($splitEvenly)
            ->setPercentagesList($percentagesList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Term
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get dateDriven value
     * @return bool|null
     */
    public function getDateDriven()
    {
        return $this->dateDriven;
    }
    /**
     * Set dateDriven value
     * @param bool $dateDriven
     * @return \StructType\Term
     */
    public function setDateDriven($dateDriven = null)
    {
        // validation for constraint: boolean
        if (!is_null($dateDriven) && !is_bool($dateDriven)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dateDriven, true), gettype($dateDriven)), __LINE__);
        }
        $this->dateDriven = $dateDriven;
        return $this;
    }
    /**
     * Get daysUntilNetDue value
     * @return int|null
     */
    public function getDaysUntilNetDue()
    {
        return $this->daysUntilNetDue;
    }
    /**
     * Set daysUntilNetDue value
     * @param int $daysUntilNetDue
     * @return \StructType\Term
     */
    public function setDaysUntilNetDue($daysUntilNetDue = null)
    {
        // validation for constraint: int
        if (!is_null($daysUntilNetDue) && !(is_int($daysUntilNetDue) || ctype_digit($daysUntilNetDue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($daysUntilNetDue, true), gettype($daysUntilNetDue)), __LINE__);
        }
        $this->daysUntilNetDue = $daysUntilNetDue;
        return $this;
    }
    /**
     * Get discountPercent value
     * @return float|null
     */
    public function getDiscountPercent()
    {
        return $this->discountPercent;
    }
    /**
     * Set discountPercent value
     * @param float $discountPercent
     * @return \StructType\Term
     */
    public function setDiscountPercent($discountPercent = null)
    {
        // validation for constraint: float
        if (!is_null($discountPercent) && !(is_float($discountPercent) || is_numeric($discountPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountPercent, true), gettype($discountPercent)), __LINE__);
        }
        $this->discountPercent = $discountPercent;
        return $this;
    }
    /**
     * Get daysUntilExpiry value
     * @return int|null
     */
    public function getDaysUntilExpiry()
    {
        return $this->daysUntilExpiry;
    }
    /**
     * Set daysUntilExpiry value
     * @param int $daysUntilExpiry
     * @return \StructType\Term
     */
    public function setDaysUntilExpiry($daysUntilExpiry = null)
    {
        // validation for constraint: int
        if (!is_null($daysUntilExpiry) && !(is_int($daysUntilExpiry) || ctype_digit($daysUntilExpiry))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($daysUntilExpiry, true), gettype($daysUntilExpiry)), __LINE__);
        }
        $this->daysUntilExpiry = $daysUntilExpiry;
        return $this;
    }
    /**
     * Get dayOfMonthNetDue value
     * @return int|null
     */
    public function getDayOfMonthNetDue()
    {
        return $this->dayOfMonthNetDue;
    }
    /**
     * Set dayOfMonthNetDue value
     * @param int $dayOfMonthNetDue
     * @return \StructType\Term
     */
    public function setDayOfMonthNetDue($dayOfMonthNetDue = null)
    {
        // validation for constraint: int
        if (!is_null($dayOfMonthNetDue) && !(is_int($dayOfMonthNetDue) || ctype_digit($dayOfMonthNetDue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dayOfMonthNetDue, true), gettype($dayOfMonthNetDue)), __LINE__);
        }
        $this->dayOfMonthNetDue = $dayOfMonthNetDue;
        return $this;
    }
    /**
     * Get dueNextMonthIfWithinDays value
     * @return int|null
     */
    public function getDueNextMonthIfWithinDays()
    {
        return $this->dueNextMonthIfWithinDays;
    }
    /**
     * Set dueNextMonthIfWithinDays value
     * @param int $dueNextMonthIfWithinDays
     * @return \StructType\Term
     */
    public function setDueNextMonthIfWithinDays($dueNextMonthIfWithinDays = null)
    {
        // validation for constraint: int
        if (!is_null($dueNextMonthIfWithinDays) && !(is_int($dueNextMonthIfWithinDays) || ctype_digit($dueNextMonthIfWithinDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dueNextMonthIfWithinDays, true), gettype($dueNextMonthIfWithinDays)), __LINE__);
        }
        $this->dueNextMonthIfWithinDays = $dueNextMonthIfWithinDays;
        return $this;
    }
    /**
     * Get discountPercentDateDriven value
     * @return float|null
     */
    public function getDiscountPercentDateDriven()
    {
        return $this->discountPercentDateDriven;
    }
    /**
     * Set discountPercentDateDriven value
     * @param float $discountPercentDateDriven
     * @return \StructType\Term
     */
    public function setDiscountPercentDateDriven($discountPercentDateDriven = null)
    {
        // validation for constraint: float
        if (!is_null($discountPercentDateDriven) && !(is_float($discountPercentDateDriven) || is_numeric($discountPercentDateDriven))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountPercentDateDriven, true), gettype($discountPercentDateDriven)), __LINE__);
        }
        $this->discountPercentDateDriven = $discountPercentDateDriven;
        return $this;
    }
    /**
     * Get dayDiscountExpires value
     * @return int|null
     */
    public function getDayDiscountExpires()
    {
        return $this->dayDiscountExpires;
    }
    /**
     * Set dayDiscountExpires value
     * @param int $dayDiscountExpires
     * @return \StructType\Term
     */
    public function setDayDiscountExpires($dayDiscountExpires = null)
    {
        // validation for constraint: int
        if (!is_null($dayDiscountExpires) && !(is_int($dayDiscountExpires) || ctype_digit($dayDiscountExpires))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dayDiscountExpires, true), gettype($dayDiscountExpires)), __LINE__);
        }
        $this->dayDiscountExpires = $dayDiscountExpires;
        return $this;
    }
    /**
     * Get preferred value
     * @return bool|null
     */
    public function getPreferred()
    {
        return $this->preferred;
    }
    /**
     * Set preferred value
     * @param bool $preferred
     * @return \StructType\Term
     */
    public function setPreferred($preferred = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferred) && !is_bool($preferred)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferred, true), gettype($preferred)), __LINE__);
        }
        $this->preferred = $preferred;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\Term
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get installment value
     * @return bool|null
     */
    public function getInstallment()
    {
        return $this->installment;
    }
    /**
     * Set installment value
     * @param bool $installment
     * @return \StructType\Term
     */
    public function setInstallment($installment = null)
    {
        // validation for constraint: boolean
        if (!is_null($installment) && !is_bool($installment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($installment, true), gettype($installment)), __LINE__);
        }
        $this->installment = $installment;
        return $this;
    }
    /**
     * Get recurrenceFrequency value
     * @return string|null
     */
    public function getRecurrenceFrequency()
    {
        return $this->recurrenceFrequency;
    }
    /**
     * Set recurrenceFrequency value
     * @uses \EnumType\TermRecurrenceFrequency::valueIsValid()
     * @uses \EnumType\TermRecurrenceFrequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recurrenceFrequency
     * @return \StructType\Term
     */
    public function setRecurrenceFrequency($recurrenceFrequency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TermRecurrenceFrequency::valueIsValid($recurrenceFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TermRecurrenceFrequency', is_array($recurrenceFrequency) ? implode(', ', $recurrenceFrequency) : var_export($recurrenceFrequency, true), implode(', ', \EnumType\TermRecurrenceFrequency::getValidValues())), __LINE__);
        }
        $this->recurrenceFrequency = $recurrenceFrequency;
        return $this;
    }
    /**
     * Get recurrenceCount value
     * @return int|null
     */
    public function getRecurrenceCount()
    {
        return $this->recurrenceCount;
    }
    /**
     * Set recurrenceCount value
     * @param int $recurrenceCount
     * @return \StructType\Term
     */
    public function setRecurrenceCount($recurrenceCount = null)
    {
        // validation for constraint: int
        if (!is_null($recurrenceCount) && !(is_int($recurrenceCount) || ctype_digit($recurrenceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recurrenceCount, true), gettype($recurrenceCount)), __LINE__);
        }
        $this->recurrenceCount = $recurrenceCount;
        return $this;
    }
    /**
     * Get repeatEvery value
     * @return int|null
     */
    public function getRepeatEvery()
    {
        return $this->repeatEvery;
    }
    /**
     * Set repeatEvery value
     * @param int $repeatEvery
     * @return \StructType\Term
     */
    public function setRepeatEvery($repeatEvery = null)
    {
        // validation for constraint: int
        if (!is_null($repeatEvery) && !(is_int($repeatEvery) || ctype_digit($repeatEvery))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($repeatEvery, true), gettype($repeatEvery)), __LINE__);
        }
        $this->repeatEvery = $repeatEvery;
        return $this;
    }
    /**
     * Get splitEvenly value
     * @return bool|null
     */
    public function getSplitEvenly()
    {
        return $this->splitEvenly;
    }
    /**
     * Set splitEvenly value
     * @param bool $splitEvenly
     * @return \StructType\Term
     */
    public function setSplitEvenly($splitEvenly = null)
    {
        // validation for constraint: boolean
        if (!is_null($splitEvenly) && !is_bool($splitEvenly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($splitEvenly, true), gettype($splitEvenly)), __LINE__);
        }
        $this->splitEvenly = $splitEvenly;
        return $this;
    }
    /**
     * Get percentagesList value
     * @return \StructType\TermPercentagesList|null
     */
    public function getPercentagesList()
    {
        return $this->percentagesList;
    }
    /**
     * Set percentagesList value
     * @param \StructType\TermPercentagesList $percentagesList
     * @return \StructType\Term
     */
    public function setPercentagesList(\StructType\TermPercentagesList $percentagesList = null)
    {
        $this->percentagesList = $percentagesList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Term
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Term
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
