<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxTypeNexusAccountsList StructType
 * @subpackage Structs
 */
class TaxTypeNexusAccountsList extends AbstractStructBase
{
    /**
     * The taxTypeNexusAccounts
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TaxTypeNexusAccounts[]
     */
    public $taxTypeNexusAccounts;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for TaxTypeNexusAccountsList
     * @uses TaxTypeNexusAccountsList::setTaxTypeNexusAccounts()
     * @uses TaxTypeNexusAccountsList::setReplaceAll()
     * @param \StructType\TaxTypeNexusAccounts[] $taxTypeNexusAccounts
     * @param bool $replaceAll
     */
    public function __construct(array $taxTypeNexusAccounts = array(), $replaceAll = true)
    {
        $this
            ->setTaxTypeNexusAccounts($taxTypeNexusAccounts)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get taxTypeNexusAccounts value
     * @return \StructType\TaxTypeNexusAccounts[]|null
     */
    public function getTaxTypeNexusAccounts()
    {
        return $this->taxTypeNexusAccounts;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxTypeNexusAccounts method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxTypeNexusAccounts method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxTypeNexusAccountsForArrayConstraintsFromSetTaxTypeNexusAccounts(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxTypeNexusAccountsListTaxTypeNexusAccountsItem) {
            // validation for constraint: itemType
            if (!$taxTypeNexusAccountsListTaxTypeNexusAccountsItem instanceof \StructType\TaxTypeNexusAccounts) {
                $invalidValues[] = is_object($taxTypeNexusAccountsListTaxTypeNexusAccountsItem) ? get_class($taxTypeNexusAccountsListTaxTypeNexusAccountsItem) : sprintf('%s(%s)', gettype($taxTypeNexusAccountsListTaxTypeNexusAccountsItem), var_export($taxTypeNexusAccountsListTaxTypeNexusAccountsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taxTypeNexusAccounts property can only contain items of type \StructType\TaxTypeNexusAccounts, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taxTypeNexusAccounts value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxTypeNexusAccounts[] $taxTypeNexusAccounts
     * @return \StructType\TaxTypeNexusAccountsList
     */
    public function setTaxTypeNexusAccounts(array $taxTypeNexusAccounts = array())
    {
        // validation for constraint: array
        if ('' !== ($taxTypeNexusAccountsArrayErrorMessage = self::validateTaxTypeNexusAccountsForArrayConstraintsFromSetTaxTypeNexusAccounts($taxTypeNexusAccounts))) {
            throw new \InvalidArgumentException($taxTypeNexusAccountsArrayErrorMessage, __LINE__);
        }
        $this->taxTypeNexusAccounts = $taxTypeNexusAccounts;
        return $this;
    }
    /**
     * Add item to taxTypeNexusAccounts value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxTypeNexusAccounts $item
     * @return \StructType\TaxTypeNexusAccountsList
     */
    public function addToTaxTypeNexusAccounts(\StructType\TaxTypeNexusAccounts $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxTypeNexusAccounts) {
            throw new \InvalidArgumentException(sprintf('The taxTypeNexusAccounts property can only contain items of type \StructType\TaxTypeNexusAccounts, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taxTypeNexusAccounts[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\TaxTypeNexusAccountsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
