<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxType StructType
 * Meta information extracted from the WSDL
 * - type: listAcct:TaxType
 * @subpackage Structs
 */
class TaxType extends Record
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The doesNotAddToTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $doesNotAddToTotal;
    /**
     * The postToItemCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $postToItemCost;
    /**
     * The taxInNetAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxInNetAmount;
    /**
     * The reverseCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $reverseCharge;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The nexusAccountsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxTypeNexusAccountsList
     */
    public $nexusAccountsList;
    /**
     * The nexusesTaxList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxTypeNexusesTaxList
     */
    public $nexusesTaxList;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for TaxType
     * @uses TaxType::setName()
     * @uses TaxType::setDescription()
     * @uses TaxType::setDoesNotAddToTotal()
     * @uses TaxType::setPostToItemCost()
     * @uses TaxType::setTaxInNetAmount()
     * @uses TaxType::setReverseCharge()
     * @uses TaxType::setIsInactive()
     * @uses TaxType::setNexusAccountsList()
     * @uses TaxType::setNexusesTaxList()
     * @uses TaxType::setCountry()
     * @uses TaxType::setInternalId()
     * @uses TaxType::setExternalId()
     * @param string $name
     * @param string $description
     * @param bool $doesNotAddToTotal
     * @param bool $postToItemCost
     * @param bool $taxInNetAmount
     * @param bool $reverseCharge
     * @param bool $isInactive
     * @param \StructType\TaxTypeNexusAccountsList $nexusAccountsList
     * @param \StructType\TaxTypeNexusesTaxList $nexusesTaxList
     * @param string $country
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($name = null, $description = null, $doesNotAddToTotal = null, $postToItemCost = null, $taxInNetAmount = null, $reverseCharge = null, $isInactive = null, \StructType\TaxTypeNexusAccountsList $nexusAccountsList = null, \StructType\TaxTypeNexusesTaxList $nexusesTaxList = null, $country = null, $internalId = null, $externalId = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setDoesNotAddToTotal($doesNotAddToTotal)
            ->setPostToItemCost($postToItemCost)
            ->setTaxInNetAmount($taxInNetAmount)
            ->setReverseCharge($reverseCharge)
            ->setIsInactive($isInactive)
            ->setNexusAccountsList($nexusAccountsList)
            ->setNexusesTaxList($nexusesTaxList)
            ->setCountry($country)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\TaxType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\TaxType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get doesNotAddToTotal value
     * @return bool|null
     */
    public function getDoesNotAddToTotal()
    {
        return $this->doesNotAddToTotal;
    }
    /**
     * Set doesNotAddToTotal value
     * @param bool $doesNotAddToTotal
     * @return \StructType\TaxType
     */
    public function setDoesNotAddToTotal($doesNotAddToTotal = null)
    {
        // validation for constraint: boolean
        if (!is_null($doesNotAddToTotal) && !is_bool($doesNotAddToTotal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doesNotAddToTotal, true), gettype($doesNotAddToTotal)), __LINE__);
        }
        $this->doesNotAddToTotal = $doesNotAddToTotal;
        return $this;
    }
    /**
     * Get postToItemCost value
     * @return bool|null
     */
    public function getPostToItemCost()
    {
        return $this->postToItemCost;
    }
    /**
     * Set postToItemCost value
     * @param bool $postToItemCost
     * @return \StructType\TaxType
     */
    public function setPostToItemCost($postToItemCost = null)
    {
        // validation for constraint: boolean
        if (!is_null($postToItemCost) && !is_bool($postToItemCost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($postToItemCost, true), gettype($postToItemCost)), __LINE__);
        }
        $this->postToItemCost = $postToItemCost;
        return $this;
    }
    /**
     * Get taxInNetAmount value
     * @return bool|null
     */
    public function getTaxInNetAmount()
    {
        return $this->taxInNetAmount;
    }
    /**
     * Set taxInNetAmount value
     * @param bool $taxInNetAmount
     * @return \StructType\TaxType
     */
    public function setTaxInNetAmount($taxInNetAmount = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxInNetAmount) && !is_bool($taxInNetAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxInNetAmount, true), gettype($taxInNetAmount)), __LINE__);
        }
        $this->taxInNetAmount = $taxInNetAmount;
        return $this;
    }
    /**
     * Get reverseCharge value
     * @return bool|null
     */
    public function getReverseCharge()
    {
        return $this->reverseCharge;
    }
    /**
     * Set reverseCharge value
     * @param bool $reverseCharge
     * @return \StructType\TaxType
     */
    public function setReverseCharge($reverseCharge = null)
    {
        // validation for constraint: boolean
        if (!is_null($reverseCharge) && !is_bool($reverseCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reverseCharge, true), gettype($reverseCharge)), __LINE__);
        }
        $this->reverseCharge = $reverseCharge;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\TaxType
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get nexusAccountsList value
     * @return \StructType\TaxTypeNexusAccountsList|null
     */
    public function getNexusAccountsList()
    {
        return $this->nexusAccountsList;
    }
    /**
     * Set nexusAccountsList value
     * @param \StructType\TaxTypeNexusAccountsList $nexusAccountsList
     * @return \StructType\TaxType
     */
    public function setNexusAccountsList(\StructType\TaxTypeNexusAccountsList $nexusAccountsList = null)
    {
        $this->nexusAccountsList = $nexusAccountsList;
        return $this;
    }
    /**
     * Get nexusesTaxList value
     * @return \StructType\TaxTypeNexusesTaxList|null
     */
    public function getNexusesTaxList()
    {
        return $this->nexusesTaxList;
    }
    /**
     * Set nexusesTaxList value
     * @param \StructType\TaxTypeNexusesTaxList $nexusesTaxList
     * @return \StructType\TaxType
     */
    public function setNexusesTaxList(\StructType\TaxTypeNexusesTaxList $nexusesTaxList = null)
    {
        $this->nexusesTaxList = $nexusesTaxList;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @uses \EnumType\Country::valueIsValid()
     * @uses \EnumType\Country::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $country
     * @return \StructType\TaxType
     */
    public function setCountry($country = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Country::valueIsValid($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Country', is_array($country) ? implode(', ', $country) : var_export($country, true), implode(', ', \EnumType\Country::getValidValues())), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\TaxType
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\TaxType
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
