<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxGroupTaxItemList StructType
 * @subpackage Structs
 */
class TaxGroupTaxItemList extends AbstractStructBase
{
    /**
     * The taxItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TaxGroupTaxItem[]
     */
    public $taxItem;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for TaxGroupTaxItemList
     * @uses TaxGroupTaxItemList::setTaxItem()
     * @uses TaxGroupTaxItemList::setReplaceAll()
     * @param \StructType\TaxGroupTaxItem[] $taxItem
     * @param bool $replaceAll
     */
    public function __construct(array $taxItem = array(), $replaceAll = true)
    {
        $this
            ->setTaxItem($taxItem)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get taxItem value
     * @return \StructType\TaxGroupTaxItem[]|null
     */
    public function getTaxItem()
    {
        return $this->taxItem;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxItemForArrayConstraintsFromSetTaxItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupTaxItemListTaxItemItem) {
            // validation for constraint: itemType
            if (!$taxGroupTaxItemListTaxItemItem instanceof \StructType\TaxGroupTaxItem) {
                $invalidValues[] = is_object($taxGroupTaxItemListTaxItemItem) ? get_class($taxGroupTaxItemListTaxItemItem) : sprintf('%s(%s)', gettype($taxGroupTaxItemListTaxItemItem), var_export($taxGroupTaxItemListTaxItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taxItem property can only contain items of type \StructType\TaxGroupTaxItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taxItem value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxGroupTaxItem[] $taxItem
     * @return \StructType\TaxGroupTaxItemList
     */
    public function setTaxItem(array $taxItem = array())
    {
        // validation for constraint: array
        if ('' !== ($taxItemArrayErrorMessage = self::validateTaxItemForArrayConstraintsFromSetTaxItem($taxItem))) {
            throw new \InvalidArgumentException($taxItemArrayErrorMessage, __LINE__);
        }
        $this->taxItem = $taxItem;
        return $this;
    }
    /**
     * Add item to taxItem value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxGroupTaxItem $item
     * @return \StructType\TaxGroupTaxItemList
     */
    public function addToTaxItem(\StructType\TaxGroupTaxItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxGroupTaxItem) {
            throw new \InvalidArgumentException(sprintf('The taxItem property can only contain items of type \StructType\TaxGroupTaxItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taxItem[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\TaxGroupTaxItemList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
