<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxGroupSearchRowBasic StructType
 * @subpackage Structs
 */
class TaxGroupSearchRowBasic extends SearchRowBasic
{
    /**
     * The city
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $city;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $country;
    /**
     * The county
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $county;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The includeChildren
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $includeChildren;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The isDefault
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isDefault;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isInactive;
    /**
     * The itemId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $itemId;
    /**
     * The piggyBack
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $piggyBack;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $rate;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $state;
    /**
     * The stateDisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $stateDisplayName;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $subsidiary;
    /**
     * The subsidiaryNoHierarchy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $subsidiaryNoHierarchy;
    /**
     * The taxItem1
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $taxItem1;
    /**
     * The taxItem2
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $taxItem2;
    /**
     * The taxType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $taxType;
    /**
     * The unitPrice1
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $unitPrice1;
    /**
     * The unitPrice2
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $unitPrice2;
    /**
     * The zip
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $zip;
    /**
     * Constructor method for TaxGroupSearchRowBasic
     * @uses TaxGroupSearchRowBasic::setCity()
     * @uses TaxGroupSearchRowBasic::setCountry()
     * @uses TaxGroupSearchRowBasic::setCounty()
     * @uses TaxGroupSearchRowBasic::setExternalId()
     * @uses TaxGroupSearchRowBasic::setIncludeChildren()
     * @uses TaxGroupSearchRowBasic::setInternalId()
     * @uses TaxGroupSearchRowBasic::setIsDefault()
     * @uses TaxGroupSearchRowBasic::setIsInactive()
     * @uses TaxGroupSearchRowBasic::setItemId()
     * @uses TaxGroupSearchRowBasic::setPiggyBack()
     * @uses TaxGroupSearchRowBasic::setRate()
     * @uses TaxGroupSearchRowBasic::setState()
     * @uses TaxGroupSearchRowBasic::setStateDisplayName()
     * @uses TaxGroupSearchRowBasic::setSubsidiary()
     * @uses TaxGroupSearchRowBasic::setSubsidiaryNoHierarchy()
     * @uses TaxGroupSearchRowBasic::setTaxItem1()
     * @uses TaxGroupSearchRowBasic::setTaxItem2()
     * @uses TaxGroupSearchRowBasic::setTaxType()
     * @uses TaxGroupSearchRowBasic::setUnitPrice1()
     * @uses TaxGroupSearchRowBasic::setUnitPrice2()
     * @uses TaxGroupSearchRowBasic::setZip()
     * @param \StructType\SearchColumnStringField[] $city
     * @param \StructType\SearchColumnEnumSelectField[] $country
     * @param \StructType\SearchColumnStringField[] $county
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnBooleanField[] $includeChildren
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnBooleanField[] $isDefault
     * @param \StructType\SearchColumnBooleanField[] $isInactive
     * @param \StructType\SearchColumnStringField[] $itemId
     * @param \StructType\SearchColumnBooleanField[] $piggyBack
     * @param \StructType\SearchColumnDoubleField[] $rate
     * @param \StructType\SearchColumnSelectField[] $state
     * @param \StructType\SearchColumnStringField[] $stateDisplayName
     * @param \StructType\SearchColumnSelectField[] $subsidiary
     * @param \StructType\SearchColumnSelectField[] $subsidiaryNoHierarchy
     * @param \StructType\SearchColumnSelectField[] $taxItem1
     * @param \StructType\SearchColumnSelectField[] $taxItem2
     * @param \StructType\SearchColumnSelectField[] $taxType
     * @param \StructType\SearchColumnDoubleField[] $unitPrice1
     * @param \StructType\SearchColumnDoubleField[] $unitPrice2
     * @param \StructType\SearchColumnStringField[] $zip
     */
    public function __construct(array $city = array(), array $country = array(), array $county = array(), array $externalId = array(), array $includeChildren = array(), array $internalId = array(), array $isDefault = array(), array $isInactive = array(), array $itemId = array(), array $piggyBack = array(), array $rate = array(), array $state = array(), array $stateDisplayName = array(), array $subsidiary = array(), array $subsidiaryNoHierarchy = array(), array $taxItem1 = array(), array $taxItem2 = array(), array $taxType = array(), array $unitPrice1 = array(), array $unitPrice2 = array(), array $zip = array())
    {
        $this
            ->setCity($city)
            ->setCountry($country)
            ->setCounty($county)
            ->setExternalId($externalId)
            ->setIncludeChildren($includeChildren)
            ->setInternalId($internalId)
            ->setIsDefault($isDefault)
            ->setIsInactive($isInactive)
            ->setItemId($itemId)
            ->setPiggyBack($piggyBack)
            ->setRate($rate)
            ->setState($state)
            ->setStateDisplayName($stateDisplayName)
            ->setSubsidiary($subsidiary)
            ->setSubsidiaryNoHierarchy($subsidiaryNoHierarchy)
            ->setTaxItem1($taxItem1)
            ->setTaxItem2($taxItem2)
            ->setTaxType($taxType)
            ->setUnitPrice1($unitPrice1)
            ->setUnitPrice2($unitPrice2)
            ->setZip($zip);
    }
    /**
     * Get city value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * This method is responsible for validating the values passed to the setCity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCityForArrayConstraintsFromSetCity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupSearchRowBasicCityItem) {
            // validation for constraint: itemType
            if (!$taxGroupSearchRowBasicCityItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($taxGroupSearchRowBasicCityItem) ? get_class($taxGroupSearchRowBasicCityItem) : sprintf('%s(%s)', gettype($taxGroupSearchRowBasicCityItem), var_export($taxGroupSearchRowBasicCityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The city property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set city value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $city
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function setCity(array $city = array())
    {
        // validation for constraint: array
        if ('' !== ($cityArrayErrorMessage = self::validateCityForArrayConstraintsFromSetCity($city))) {
            throw new \InvalidArgumentException($cityArrayErrorMessage, __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Add item to city value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function addToCity(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The city property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->city[] = $item;
        return $this;
    }
    /**
     * Get country value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * This method is responsible for validating the values passed to the setCountry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCountry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCountryForArrayConstraintsFromSetCountry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupSearchRowBasicCountryItem) {
            // validation for constraint: itemType
            if (!$taxGroupSearchRowBasicCountryItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($taxGroupSearchRowBasicCountryItem) ? get_class($taxGroupSearchRowBasicCountryItem) : sprintf('%s(%s)', gettype($taxGroupSearchRowBasicCountryItem), var_export($taxGroupSearchRowBasicCountryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The country property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set country value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $country
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function setCountry(array $country = array())
    {
        // validation for constraint: array
        if ('' !== ($countryArrayErrorMessage = self::validateCountryForArrayConstraintsFromSetCountry($country))) {
            throw new \InvalidArgumentException($countryArrayErrorMessage, __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Add item to country value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function addToCountry(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The country property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->country[] = $item;
        return $this;
    }
    /**
     * Get county value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getCounty()
    {
        return $this->county;
    }
    /**
     * This method is responsible for validating the values passed to the setCounty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCounty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCountyForArrayConstraintsFromSetCounty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupSearchRowBasicCountyItem) {
            // validation for constraint: itemType
            if (!$taxGroupSearchRowBasicCountyItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($taxGroupSearchRowBasicCountyItem) ? get_class($taxGroupSearchRowBasicCountyItem) : sprintf('%s(%s)', gettype($taxGroupSearchRowBasicCountyItem), var_export($taxGroupSearchRowBasicCountyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The county property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set county value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $county
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function setCounty(array $county = array())
    {
        // validation for constraint: array
        if ('' !== ($countyArrayErrorMessage = self::validateCountyForArrayConstraintsFromSetCounty($county))) {
            throw new \InvalidArgumentException($countyArrayErrorMessage, __LINE__);
        }
        $this->county = $county;
        return $this;
    }
    /**
     * Add item to county value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function addToCounty(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The county property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->county[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$taxGroupSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($taxGroupSearchRowBasicExternalIdItem) ? get_class($taxGroupSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($taxGroupSearchRowBasicExternalIdItem), var_export($taxGroupSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get includeChildren value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIncludeChildren()
    {
        return $this->includeChildren;
    }
    /**
     * This method is responsible for validating the values passed to the setIncludeChildren method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIncludeChildren method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIncludeChildrenForArrayConstraintsFromSetIncludeChildren(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupSearchRowBasicIncludeChildrenItem) {
            // validation for constraint: itemType
            if (!$taxGroupSearchRowBasicIncludeChildrenItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($taxGroupSearchRowBasicIncludeChildrenItem) ? get_class($taxGroupSearchRowBasicIncludeChildrenItem) : sprintf('%s(%s)', gettype($taxGroupSearchRowBasicIncludeChildrenItem), var_export($taxGroupSearchRowBasicIncludeChildrenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The includeChildren property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set includeChildren value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $includeChildren
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function setIncludeChildren(array $includeChildren = array())
    {
        // validation for constraint: array
        if ('' !== ($includeChildrenArrayErrorMessage = self::validateIncludeChildrenForArrayConstraintsFromSetIncludeChildren($includeChildren))) {
            throw new \InvalidArgumentException($includeChildrenArrayErrorMessage, __LINE__);
        }
        $this->includeChildren = $includeChildren;
        return $this;
    }
    /**
     * Add item to includeChildren value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function addToIncludeChildren(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The includeChildren property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->includeChildren[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$taxGroupSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($taxGroupSearchRowBasicInternalIdItem) ? get_class($taxGroupSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($taxGroupSearchRowBasicInternalIdItem), var_export($taxGroupSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get isDefault value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * This method is responsible for validating the values passed to the setIsDefault method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsDefault method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsDefaultForArrayConstraintsFromSetIsDefault(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupSearchRowBasicIsDefaultItem) {
            // validation for constraint: itemType
            if (!$taxGroupSearchRowBasicIsDefaultItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($taxGroupSearchRowBasicIsDefaultItem) ? get_class($taxGroupSearchRowBasicIsDefaultItem) : sprintf('%s(%s)', gettype($taxGroupSearchRowBasicIsDefaultItem), var_export($taxGroupSearchRowBasicIsDefaultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isDefault property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isDefault value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isDefault
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function setIsDefault(array $isDefault = array())
    {
        // validation for constraint: array
        if ('' !== ($isDefaultArrayErrorMessage = self::validateIsDefaultForArrayConstraintsFromSetIsDefault($isDefault))) {
            throw new \InvalidArgumentException($isDefaultArrayErrorMessage, __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Add item to isDefault value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function addToIsDefault(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isDefault property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isDefault[] = $item;
        return $this;
    }
    /**
     * Get isInactive value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * This method is responsible for validating the values passed to the setIsInactive method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsInactive method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsInactiveForArrayConstraintsFromSetIsInactive(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupSearchRowBasicIsInactiveItem) {
            // validation for constraint: itemType
            if (!$taxGroupSearchRowBasicIsInactiveItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($taxGroupSearchRowBasicIsInactiveItem) ? get_class($taxGroupSearchRowBasicIsInactiveItem) : sprintf('%s(%s)', gettype($taxGroupSearchRowBasicIsInactiveItem), var_export($taxGroupSearchRowBasicIsInactiveItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isInactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isInactive
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function setIsInactive(array $isInactive = array())
    {
        // validation for constraint: array
        if ('' !== ($isInactiveArrayErrorMessage = self::validateIsInactiveForArrayConstraintsFromSetIsInactive($isInactive))) {
            throw new \InvalidArgumentException($isInactiveArrayErrorMessage, __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Add item to isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function addToIsInactive(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isInactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isInactive[] = $item;
        return $this;
    }
    /**
     * Get itemId value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * This method is responsible for validating the values passed to the setItemId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemIdForArrayConstraintsFromSetItemId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupSearchRowBasicItemIdItem) {
            // validation for constraint: itemType
            if (!$taxGroupSearchRowBasicItemIdItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($taxGroupSearchRowBasicItemIdItem) ? get_class($taxGroupSearchRowBasicItemIdItem) : sprintf('%s(%s)', gettype($taxGroupSearchRowBasicItemIdItem), var_export($taxGroupSearchRowBasicItemIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itemId property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itemId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $itemId
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function setItemId(array $itemId = array())
    {
        // validation for constraint: array
        if ('' !== ($itemIdArrayErrorMessage = self::validateItemIdForArrayConstraintsFromSetItemId($itemId))) {
            throw new \InvalidArgumentException($itemIdArrayErrorMessage, __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Add item to itemId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function addToItemId(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The itemId property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->itemId[] = $item;
        return $this;
    }
    /**
     * Get piggyBack value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getPiggyBack()
    {
        return $this->piggyBack;
    }
    /**
     * This method is responsible for validating the values passed to the setPiggyBack method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPiggyBack method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePiggyBackForArrayConstraintsFromSetPiggyBack(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupSearchRowBasicPiggyBackItem) {
            // validation for constraint: itemType
            if (!$taxGroupSearchRowBasicPiggyBackItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($taxGroupSearchRowBasicPiggyBackItem) ? get_class($taxGroupSearchRowBasicPiggyBackItem) : sprintf('%s(%s)', gettype($taxGroupSearchRowBasicPiggyBackItem), var_export($taxGroupSearchRowBasicPiggyBackItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The piggyBack property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set piggyBack value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $piggyBack
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function setPiggyBack(array $piggyBack = array())
    {
        // validation for constraint: array
        if ('' !== ($piggyBackArrayErrorMessage = self::validatePiggyBackForArrayConstraintsFromSetPiggyBack($piggyBack))) {
            throw new \InvalidArgumentException($piggyBackArrayErrorMessage, __LINE__);
        }
        $this->piggyBack = $piggyBack;
        return $this;
    }
    /**
     * Add item to piggyBack value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function addToPiggyBack(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The piggyBack property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->piggyBack[] = $item;
        return $this;
    }
    /**
     * Get rate value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * This method is responsible for validating the values passed to the setRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRateForArrayConstraintsFromSetRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupSearchRowBasicRateItem) {
            // validation for constraint: itemType
            if (!$taxGroupSearchRowBasicRateItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($taxGroupSearchRowBasicRateItem) ? get_class($taxGroupSearchRowBasicRateItem) : sprintf('%s(%s)', gettype($taxGroupSearchRowBasicRateItem), var_export($taxGroupSearchRowBasicRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The rate property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set rate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $rate
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function setRate(array $rate = array())
    {
        // validation for constraint: array
        if ('' !== ($rateArrayErrorMessage = self::validateRateForArrayConstraintsFromSetRate($rate))) {
            throw new \InvalidArgumentException($rateArrayErrorMessage, __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Add item to rate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function addToRate(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The rate property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->rate[] = $item;
        return $this;
    }
    /**
     * Get state value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * This method is responsible for validating the values passed to the setState method
     * This method is willingly generated in order to preserve the one-line inline validation within the setState method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStateForArrayConstraintsFromSetState(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupSearchRowBasicStateItem) {
            // validation for constraint: itemType
            if (!$taxGroupSearchRowBasicStateItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($taxGroupSearchRowBasicStateItem) ? get_class($taxGroupSearchRowBasicStateItem) : sprintf('%s(%s)', gettype($taxGroupSearchRowBasicStateItem), var_export($taxGroupSearchRowBasicStateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The state property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set state value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $state
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function setState(array $state = array())
    {
        // validation for constraint: array
        if ('' !== ($stateArrayErrorMessage = self::validateStateForArrayConstraintsFromSetState($state))) {
            throw new \InvalidArgumentException($stateArrayErrorMessage, __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Add item to state value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function addToState(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The state property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->state[] = $item;
        return $this;
    }
    /**
     * Get stateDisplayName value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getStateDisplayName()
    {
        return $this->stateDisplayName;
    }
    /**
     * This method is responsible for validating the values passed to the setStateDisplayName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStateDisplayName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStateDisplayNameForArrayConstraintsFromSetStateDisplayName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupSearchRowBasicStateDisplayNameItem) {
            // validation for constraint: itemType
            if (!$taxGroupSearchRowBasicStateDisplayNameItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($taxGroupSearchRowBasicStateDisplayNameItem) ? get_class($taxGroupSearchRowBasicStateDisplayNameItem) : sprintf('%s(%s)', gettype($taxGroupSearchRowBasicStateDisplayNameItem), var_export($taxGroupSearchRowBasicStateDisplayNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The stateDisplayName property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set stateDisplayName value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $stateDisplayName
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function setStateDisplayName(array $stateDisplayName = array())
    {
        // validation for constraint: array
        if ('' !== ($stateDisplayNameArrayErrorMessage = self::validateStateDisplayNameForArrayConstraintsFromSetStateDisplayName($stateDisplayName))) {
            throw new \InvalidArgumentException($stateDisplayNameArrayErrorMessage, __LINE__);
        }
        $this->stateDisplayName = $stateDisplayName;
        return $this;
    }
    /**
     * Add item to stateDisplayName value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function addToStateDisplayName(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The stateDisplayName property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->stateDisplayName[] = $item;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * This method is responsible for validating the values passed to the setSubsidiary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubsidiary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubsidiaryForArrayConstraintsFromSetSubsidiary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupSearchRowBasicSubsidiaryItem) {
            // validation for constraint: itemType
            if (!$taxGroupSearchRowBasicSubsidiaryItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($taxGroupSearchRowBasicSubsidiaryItem) ? get_class($taxGroupSearchRowBasicSubsidiaryItem) : sprintf('%s(%s)', gettype($taxGroupSearchRowBasicSubsidiaryItem), var_export($taxGroupSearchRowBasicSubsidiaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $subsidiary
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function setSubsidiary(array $subsidiary = array())
    {
        // validation for constraint: array
        if ('' !== ($subsidiaryArrayErrorMessage = self::validateSubsidiaryForArrayConstraintsFromSetSubsidiary($subsidiary))) {
            throw new \InvalidArgumentException($subsidiaryArrayErrorMessage, __LINE__);
        }
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Add item to subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function addToSubsidiary(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subsidiary[] = $item;
        return $this;
    }
    /**
     * Get subsidiaryNoHierarchy value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getSubsidiaryNoHierarchy()
    {
        return $this->subsidiaryNoHierarchy;
    }
    /**
     * This method is responsible for validating the values passed to the setSubsidiaryNoHierarchy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubsidiaryNoHierarchy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubsidiaryNoHierarchyForArrayConstraintsFromSetSubsidiaryNoHierarchy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupSearchRowBasicSubsidiaryNoHierarchyItem) {
            // validation for constraint: itemType
            if (!$taxGroupSearchRowBasicSubsidiaryNoHierarchyItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($taxGroupSearchRowBasicSubsidiaryNoHierarchyItem) ? get_class($taxGroupSearchRowBasicSubsidiaryNoHierarchyItem) : sprintf('%s(%s)', gettype($taxGroupSearchRowBasicSubsidiaryNoHierarchyItem), var_export($taxGroupSearchRowBasicSubsidiaryNoHierarchyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subsidiaryNoHierarchy property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subsidiaryNoHierarchy value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $subsidiaryNoHierarchy
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function setSubsidiaryNoHierarchy(array $subsidiaryNoHierarchy = array())
    {
        // validation for constraint: array
        if ('' !== ($subsidiaryNoHierarchyArrayErrorMessage = self::validateSubsidiaryNoHierarchyForArrayConstraintsFromSetSubsidiaryNoHierarchy($subsidiaryNoHierarchy))) {
            throw new \InvalidArgumentException($subsidiaryNoHierarchyArrayErrorMessage, __LINE__);
        }
        $this->subsidiaryNoHierarchy = $subsidiaryNoHierarchy;
        return $this;
    }
    /**
     * Add item to subsidiaryNoHierarchy value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function addToSubsidiaryNoHierarchy(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The subsidiaryNoHierarchy property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subsidiaryNoHierarchy[] = $item;
        return $this;
    }
    /**
     * Get taxItem1 value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getTaxItem1()
    {
        return $this->taxItem1;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxItem1 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxItem1 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxItem1ForArrayConstraintsFromSetTaxItem1(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupSearchRowBasicTaxItem1Item) {
            // validation for constraint: itemType
            if (!$taxGroupSearchRowBasicTaxItem1Item instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($taxGroupSearchRowBasicTaxItem1Item) ? get_class($taxGroupSearchRowBasicTaxItem1Item) : sprintf('%s(%s)', gettype($taxGroupSearchRowBasicTaxItem1Item), var_export($taxGroupSearchRowBasicTaxItem1Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taxItem1 property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taxItem1 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $taxItem1
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function setTaxItem1(array $taxItem1 = array())
    {
        // validation for constraint: array
        if ('' !== ($taxItem1ArrayErrorMessage = self::validateTaxItem1ForArrayConstraintsFromSetTaxItem1($taxItem1))) {
            throw new \InvalidArgumentException($taxItem1ArrayErrorMessage, __LINE__);
        }
        $this->taxItem1 = $taxItem1;
        return $this;
    }
    /**
     * Add item to taxItem1 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function addToTaxItem1(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The taxItem1 property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taxItem1[] = $item;
        return $this;
    }
    /**
     * Get taxItem2 value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getTaxItem2()
    {
        return $this->taxItem2;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxItem2 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxItem2 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxItem2ForArrayConstraintsFromSetTaxItem2(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupSearchRowBasicTaxItem2Item) {
            // validation for constraint: itemType
            if (!$taxGroupSearchRowBasicTaxItem2Item instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($taxGroupSearchRowBasicTaxItem2Item) ? get_class($taxGroupSearchRowBasicTaxItem2Item) : sprintf('%s(%s)', gettype($taxGroupSearchRowBasicTaxItem2Item), var_export($taxGroupSearchRowBasicTaxItem2Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taxItem2 property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taxItem2 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $taxItem2
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function setTaxItem2(array $taxItem2 = array())
    {
        // validation for constraint: array
        if ('' !== ($taxItem2ArrayErrorMessage = self::validateTaxItem2ForArrayConstraintsFromSetTaxItem2($taxItem2))) {
            throw new \InvalidArgumentException($taxItem2ArrayErrorMessage, __LINE__);
        }
        $this->taxItem2 = $taxItem2;
        return $this;
    }
    /**
     * Add item to taxItem2 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function addToTaxItem2(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The taxItem2 property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taxItem2[] = $item;
        return $this;
    }
    /**
     * Get taxType value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getTaxType()
    {
        return $this->taxType;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxTypeForArrayConstraintsFromSetTaxType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupSearchRowBasicTaxTypeItem) {
            // validation for constraint: itemType
            if (!$taxGroupSearchRowBasicTaxTypeItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($taxGroupSearchRowBasicTaxTypeItem) ? get_class($taxGroupSearchRowBasicTaxTypeItem) : sprintf('%s(%s)', gettype($taxGroupSearchRowBasicTaxTypeItem), var_export($taxGroupSearchRowBasicTaxTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taxType property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taxType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $taxType
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function setTaxType(array $taxType = array())
    {
        // validation for constraint: array
        if ('' !== ($taxTypeArrayErrorMessage = self::validateTaxTypeForArrayConstraintsFromSetTaxType($taxType))) {
            throw new \InvalidArgumentException($taxTypeArrayErrorMessage, __LINE__);
        }
        $this->taxType = $taxType;
        return $this;
    }
    /**
     * Add item to taxType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function addToTaxType(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The taxType property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taxType[] = $item;
        return $this;
    }
    /**
     * Get unitPrice1 value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getUnitPrice1()
    {
        return $this->unitPrice1;
    }
    /**
     * This method is responsible for validating the values passed to the setUnitPrice1 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitPrice1 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitPrice1ForArrayConstraintsFromSetUnitPrice1(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupSearchRowBasicUnitPrice1Item) {
            // validation for constraint: itemType
            if (!$taxGroupSearchRowBasicUnitPrice1Item instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($taxGroupSearchRowBasicUnitPrice1Item) ? get_class($taxGroupSearchRowBasicUnitPrice1Item) : sprintf('%s(%s)', gettype($taxGroupSearchRowBasicUnitPrice1Item), var_export($taxGroupSearchRowBasicUnitPrice1Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The unitPrice1 property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set unitPrice1 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $unitPrice1
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function setUnitPrice1(array $unitPrice1 = array())
    {
        // validation for constraint: array
        if ('' !== ($unitPrice1ArrayErrorMessage = self::validateUnitPrice1ForArrayConstraintsFromSetUnitPrice1($unitPrice1))) {
            throw new \InvalidArgumentException($unitPrice1ArrayErrorMessage, __LINE__);
        }
        $this->unitPrice1 = $unitPrice1;
        return $this;
    }
    /**
     * Add item to unitPrice1 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function addToUnitPrice1(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The unitPrice1 property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->unitPrice1[] = $item;
        return $this;
    }
    /**
     * Get unitPrice2 value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getUnitPrice2()
    {
        return $this->unitPrice2;
    }
    /**
     * This method is responsible for validating the values passed to the setUnitPrice2 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitPrice2 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitPrice2ForArrayConstraintsFromSetUnitPrice2(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupSearchRowBasicUnitPrice2Item) {
            // validation for constraint: itemType
            if (!$taxGroupSearchRowBasicUnitPrice2Item instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($taxGroupSearchRowBasicUnitPrice2Item) ? get_class($taxGroupSearchRowBasicUnitPrice2Item) : sprintf('%s(%s)', gettype($taxGroupSearchRowBasicUnitPrice2Item), var_export($taxGroupSearchRowBasicUnitPrice2Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The unitPrice2 property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set unitPrice2 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $unitPrice2
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function setUnitPrice2(array $unitPrice2 = array())
    {
        // validation for constraint: array
        if ('' !== ($unitPrice2ArrayErrorMessage = self::validateUnitPrice2ForArrayConstraintsFromSetUnitPrice2($unitPrice2))) {
            throw new \InvalidArgumentException($unitPrice2ArrayErrorMessage, __LINE__);
        }
        $this->unitPrice2 = $unitPrice2;
        return $this;
    }
    /**
     * Add item to unitPrice2 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function addToUnitPrice2(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The unitPrice2 property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->unitPrice2[] = $item;
        return $this;
    }
    /**
     * Get zip value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * This method is responsible for validating the values passed to the setZip method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZip method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZipForArrayConstraintsFromSetZip(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxGroupSearchRowBasicZipItem) {
            // validation for constraint: itemType
            if (!$taxGroupSearchRowBasicZipItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($taxGroupSearchRowBasicZipItem) ? get_class($taxGroupSearchRowBasicZipItem) : sprintf('%s(%s)', gettype($taxGroupSearchRowBasicZipItem), var_export($taxGroupSearchRowBasicZipItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zip property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zip value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $zip
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function setZip(array $zip = array())
    {
        // validation for constraint: array
        if ('' !== ($zipArrayErrorMessage = self::validateZipForArrayConstraintsFromSetZip($zip))) {
            throw new \InvalidArgumentException($zipArrayErrorMessage, __LINE__);
        }
        $this->zip = $zip;
        return $this;
    }
    /**
     * Add item to zip value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\TaxGroupSearchRowBasic
     */
    public function addToZip(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The zip property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zip[] = $item;
        return $this;
    }
}
